/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d.border;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.wb.draw2d.border.Border;

public class CompoundBorder
extends Border {
    private final Border m_outer;
    private final Border m_inner;

    public CompoundBorder() {
        this(null, null);
    }

    public CompoundBorder(Border outer, Border inner) {
        super(null);
        this.m_outer = outer;
        this.m_inner = inner;
    }

    public Border getInnerBorder() {
        return this.m_inner;
    }

    public Border getOuterBorder() {
        return this.m_outer;
    }

    @Override
    public Insets getInsets(IFigure figure) {
        Insets insets = new Insets();
        if (this.m_inner != null) {
            insets.add(this.m_inner.getInsets(figure));
        }
        if (this.m_outer != null) {
            insets.add(this.m_outer.getInsets(figure));
        }
        return insets;
    }

    @Override
    protected void paint(int ownerWidth, int ownerHeight, Graphics graphics) {
        if (this.m_outer != null) {
            graphics.pushState();
            this.m_outer.paint(ownerWidth, ownerHeight, graphics);
            graphics.popState();
            Insets insets = this.m_outer.getInsets(null);
            graphics.translate(insets.left, insets.top);
            ownerWidth -= insets.getWidth();
            ownerHeight -= insets.getHeight();
        }
        if (this.m_inner != null) {
            this.m_inner.paint(ownerWidth, ownerHeight, graphics);
        }
    }
}

