/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.description;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;

public final class ComponentPresentation {
    private final String m_key;
    private final String m_toolkitId;
    private final String m_name;
    private final String m_description;
    private byte[] m_iconBytes;
    private ImageDescriptor m_icon;

    public ComponentPresentation(String key, String toolkitId, String name, String description, byte[] iconBytes) {
        this.m_key = key;
        this.m_toolkitId = toolkitId;
        this.m_name = name;
        this.m_description = description;
        this.m_iconBytes = iconBytes;
    }

    public ComponentPresentation(String key, String toolkitId, String name, String description, ImageDescriptor icon) {
        this.m_key = key;
        this.m_toolkitId = toolkitId;
        this.m_name = name;
        this.m_description = description;
        this.m_icon = icon;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getToolkitId() {
        return this.m_toolkitId;
    }

    public String getName() {
        return this.m_name;
    }

    public String getDescription() {
        return this.m_description;
    }

    public ImageDescriptor getIcon() {
        if (this.m_icon == null && this.m_iconBytes != null) {
            ImageData imageData = new ImageData((InputStream)new ByteArrayInputStream(this.m_iconBytes));
            this.m_icon = ImageDescriptor.createFromImageDataProvider(zoom -> zoom == 100 ? imageData : null);
        }
        return this.m_icon;
    }
}

