/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public final class BooleanDialogField
extends DialogField {
    private boolean m_selection;
    private Button m_buttonControl;
    private SelectionListener m_selectionListener;
    private final boolean m_leftToRight;

    public BooleanDialogField() {
        this(false);
    }

    public BooleanDialogField(boolean leftToRight) {
        this.m_leftToRight = leftToRight;
        this.m_selection = false;
    }

    @Override
    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        Label label;
        Button button;
        this.assertEnoughColumns(nColumns);
        if (this.m_leftToRight) {
            button = this.getButtonControl(parent);
            GridDataFactory.create((Control)button).alignHF();
            label = this.getLabelControl(parent);
            GridDataFactory.create((Control)label).spanH(nColumns - 1).alignHF();
        } else {
            label = this.getLabelControl(parent);
            GridDataFactory.create((Control)label).alignHF();
            button = this.getButtonControl(parent);
            GridDataFactory.create((Control)button).spanH(nColumns - 1).alignHF();
        }
        return new Control[]{label, button};
    }

    @Override
    public int getNumberOfControls() {
        return 2;
    }

    public Button getButtonControl(Composite parent) {
        if (this.m_buttonControl == null) {
            this.assertCompositeNotNull(parent);
            this.m_selectionListener = new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    BooleanDialogField.this.doModifySelection(e);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    BooleanDialogField.this.doModifySelection(e);
                }
            };
            this.m_buttonControl = new Button(parent, 32);
            this.m_buttonControl.setSelection(this.m_selection);
            this.m_buttonControl.addSelectionListener(this.m_selectionListener);
            this.m_buttonControl.setFont(parent.getFont());
            this.m_buttonControl.setEnabled(this.isEnabled());
        }
        return this.m_buttonControl;
    }

    private void doModifySelection(SelectionEvent e) {
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.m_selection = this.m_buttonControl.getSelection();
        }
        this.dialogFieldChanged();
    }

    public boolean getSelection() {
        return this.m_selection;
    }

    public void setSelection(boolean selection) {
        this.m_selection = selection;
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.m_buttonControl.setSelection(this.m_selection);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setSelectionWithoutUpdate(boolean selection) {
        this.m_selection = selection;
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.m_buttonControl.removeSelectionListener(this.m_selectionListener);
            this.m_buttonControl.setSelection(selection);
            this.m_buttonControl.addSelectionListener(this.m_selectionListener);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.m_buttonControl)) {
            this.setSelectionWithoutUpdate(this.m_selection);
        }
    }
}

