/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.jsdtbridge;

import java.util.Map;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.chromium.debug.core.model.JavaScriptFormatter;
import org.eclipse.wst.jsdt.chromium.debug.core.model.StringMappingData;
import org.eclipse.wst.jsdt.chromium.debug.jsdtbridge.AdHocFormatter;
import org.eclipse.wst.jsdt.chromium.debug.jsdtbridge.Messages;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;

public class JsdtFormatterBridge
implements JavaScriptFormatter {
    private static final char LINE_END_CHAR = '\n';
    private static final String LINE_END_STRING = "\n";

    public JavaScriptFormatter.Result format(String sourceString) {
        TextEdit textEdit = this.jsdtFormat(sourceString);
        if (textEdit == null) {
            String header = Messages.JsdtFormatterBridge_FALLBACK_COMMENT;
            textEdit = AdHocFormatter.format(sourceString, header);
        }
        return this.convertResult(sourceString, textEdit);
    }

    private TextEdit jsdtFormat(String sourceString) {
        CodeFormatter jsdtFormatter = ToolFactory.createCodeFormatter((Map)JavaScriptCore.getDefaultOptions());
        TextEdit textEdit = jsdtFormatter.format(8, sourceString, 0, sourceString.length(), 0, LINE_END_STRING);
        return textEdit;
    }

    private JavaScriptFormatter.Result convertResult(String sourceString, TextEdit textEdit) {
        IntBuffer intBuffer = new IntBuffer();
        Position origPos = new Position(0, 0);
        Position dstPos = new Position(0, 0);
        TextEdit[] editList = textEdit.getChildren();
        int sourceStringPos = 0;
        int editListPos = 0;
        int nextLineEndPos = sourceString.indexOf(10);
        final StringBuilder builder = new StringBuilder();
        while (true) {
            boolean processLineEndNotEdit;
            ReplaceEdit replaceEdit;
            int nextEditPos = -1;
            if (editListPos < editList.length) {
                if (!(editList[editListPos] instanceof ReplaceEdit)) {
                    throw new RuntimeException();
                }
                replaceEdit = (ReplaceEdit)editList[editListPos];
                nextEditPos = replaceEdit.getOffset();
            } else {
                replaceEdit = null;
            }
            if (nextEditPos == -1) {
                if (nextLineEndPos == -1) break;
                processLineEndNotEdit = true;
            } else if (nextLineEndPos == -1) {
                processLineEndNotEdit = false;
            } else {
                boolean bl = processLineEndNotEdit = nextLineEndPos < nextEditPos;
            }
            if (processLineEndNotEdit) {
                builder.append(sourceString.substring(sourceStringPos, nextLineEndPos + 1));
                ++origPos.line;
                origPos.col = 0;
                ++dstPos.line;
                dstPos.col = 0;
                sourceStringPos = nextLineEndPos + 1;
                nextLineEndPos = sourceString.indexOf(10, sourceStringPos);
                continue;
            }
            builder.append(sourceString.substring(sourceStringPos, nextEditPos));
            origPos.col += nextEditPos - sourceStringPos;
            dstPos.col += nextEditPos - sourceStringPos;
            origPos.writeToArray(intBuffer);
            dstPos.writeToArray(intBuffer);
            if (replaceEdit.getLength() > 0) {
                String removedString = sourceString.substring(replaceEdit.getOffset(), replaceEdit.getOffset() + replaceEdit.getLength());
                origPos.advanceToString(removedString);
            }
            builder.append(replaceEdit.getText());
            dstPos.advanceToString(replaceEdit.getText());
            origPos.writeToArray(intBuffer);
            dstPos.writeToArray(intBuffer);
            sourceStringPos = nextEditPos + replaceEdit.getLength();
            ++editListPos;
            if (nextLineEndPos == -1 || nextLineEndPos >= sourceStringPos) continue;
            nextLineEndPos = sourceString.indexOf(10, sourceStringPos);
        }
        builder.append(sourceString.substring(sourceStringPos));
        origPos.col += sourceString.length() - sourceStringPos;
        dstPos.col += sourceString.length() - sourceStringPos;
        int[] inputArray = new int[intBuffer.size() / 2];
        int[] formattedArray = new int[intBuffer.size() / 2];
        int i = 0;
        while (i < inputArray.length) {
            inputArray[i] = intBuffer.get(i * 2 + 0);
            inputArray[i + 1] = intBuffer.get(i * 2 + 1);
            formattedArray[i] = intBuffer.get(i * 2 + 2);
            formattedArray[i + 1] = intBuffer.get(i * 2 + 3);
            i += 2;
        }
        final StringMappingData inputTextData = new StringMappingData(inputArray, origPos.line, origPos.col);
        final StringMappingData formattedTextData = new StringMappingData(formattedArray, dstPos.line, dstPos.col);
        return new JavaScriptFormatter.Result(){

            public String getFormattedText() {
                return builder.toString();
            }

            public StringMappingData getInputTextData() {
                return inputTextData;
            }

            public StringMappingData getFormattedTextData() {
                return formattedTextData;
            }
        };
    }

    private static class IntBuffer {
        private int[] array = new int[INITIAL_SIZE];
        private int pos = 0;
        private static int INITIAL_SIZE = 10;

        private IntBuffer() {
        }

        public void add2(int i1, int i2) {
            if (this.pos + 2 > this.array.length) {
                int[] newArray = new int[this.array.length * 2];
                System.arraycopy(this.array, 0, newArray, 0, this.pos);
                this.array = newArray;
            }
            this.array[this.pos] = i1;
            this.array[this.pos + 1] = i2;
            this.pos += 2;
        }

        public int get(int pos) {
            return this.array[pos];
        }

        public int size() {
            return this.pos;
        }
    }

    private static class Position {
        int line;
        int col;

        Position(int line, int col) {
            this.line = line;
            this.col = col;
        }

        void advanceToString(String str) {
            int innerLineEndPos;
            int innerPos = 0;
            while ((innerLineEndPos = str.indexOf(10, innerPos)) != -1) {
                ++this.line;
                this.col = 0;
                innerPos = innerLineEndPos + 1;
            }
            this.col += str.length() - innerPos;
        }

        void writeToArray(IntBuffer buffer) {
            buffer.add2(this.line, this.col);
        }
    }
}

