/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.search;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.SearchPlugin;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.wsdl.ui.internal.search.WSDLSearchContributor;
import org.eclipse.wst.xml.core.internal.search.ComponentSearchContributor;
import org.eclipse.wst.xml.core.internal.search.XMLComponentDeclarationPattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentReferencePattern;
import org.eclipse.wst.xml.core.internal.search.XMLComponentSearchPattern;
import org.eclipse.wst.xml.core.internal.search.XMLSearchParticipant;
import org.eclipse.wst.xml.core.internal.search.XMLSearchPattern;

public class WSDLSearchParticipant
extends XMLSearchParticipant {
    private static String ID = "org.eclipse.wst.wsdl.search.WSDLSearchParticipant";
    private static String XSD_PARTICIPANNT_ID = "org.eclipse.wst.xsd.search.XSDSearchParticipant";

    public WSDLSearchParticipant() {
        this.id = ID;
    }

    public String[] getSupportedContentTypes() {
        String[] result = new String[]{"org.eclipse.wst.wsdl.wsdlsource"};
        return result;
    }

    public boolean isApplicable(SearchPattern pattern, Map searchOptions) {
        XMLComponentSearchPattern componentPattern;
        String namespace;
        return pattern instanceof XMLComponentSearchPattern && ("http://schemas.xmlsoap.org/wsdl/".equals(namespace = (componentPattern = (XMLComponentSearchPattern)pattern).getMetaName().getNamespace()) || "http://www.w3.org/2001/XMLSchema".equals(namespace));
    }

    public ComponentSearchContributor getSearchContributor() {
        return new WSDLSearchContributor();
    }

    public void beginSearching(SearchPattern pattern, Map searchOptions) {
        super.beginSearching(pattern, searchOptions);
        ArrayList<XMLSearchPattern> patterns = new ArrayList<XMLSearchPattern>();
        if (pattern instanceof XMLComponentDeclarationPattern) {
            XMLSearchPattern childPattern;
            ComponentSearchContributor xsdContributor;
            SearchParticipant xsdParticipant;
            XMLComponentDeclarationPattern componentPattern = (XMLComponentDeclarationPattern)pattern;
            if ("http://schemas.xmlsoap.org/wsdl/".equals(componentPattern.getMetaName().getNamespace())) {
                XMLSearchPattern childPattern2 = this.getSearchContributor().getDeclarationPattern(componentPattern.getMetaName());
                if (childPattern2 != null) {
                    childPattern2.setSearchName(componentPattern.getName().getLocalName());
                    childPattern2.setSearchNamespace(componentPattern.getName().getNamespace());
                    patterns.add(childPattern2);
                }
            } else if ("http://www.w3.org/2001/XMLSchema".equals(componentPattern.getMetaName().getNamespace()) && (xsdParticipant = SearchPlugin.getDefault().getSearchParticipant(XSD_PARTICIPANNT_ID)) instanceof XMLSearchParticipant && (xsdContributor = ((XMLSearchParticipant)xsdParticipant).getSearchContributor()) != null && (childPattern = xsdContributor.getDeclarationPattern(componentPattern.getMetaName())) != null) {
                childPattern.setSearchName(componentPattern.getName().getLocalName());
                childPattern.setSearchNamespace(componentPattern.getName().getNamespace());
                patterns.add(childPattern);
            }
            componentPattern.addChildren((SearchParticipant)this, patterns.toArray(new XMLSearchPattern[patterns.size()]));
        } else if (pattern instanceof XMLComponentReferencePattern) {
            ComponentSearchContributor xsdContributor;
            XMLComponentReferencePattern componentPattern = (XMLComponentReferencePattern)pattern;
            XMLSearchPattern[] childPatterns = this.getSearchContributor().getReferencesPatterns(componentPattern.getMetaName());
            int i = 0;
            while (i < childPatterns.length) {
                XMLSearchPattern childPattern = childPatterns[i];
                childPattern.setSearchName(componentPattern.getName().getLocalName());
                childPattern.setSearchNamespace(componentPattern.getName().getNamespace());
                patterns.add(childPattern);
                ++i;
            }
            SearchParticipant xsdParticipant = SearchPlugin.getDefault().getSearchParticipant(XSD_PARTICIPANNT_ID);
            if (xsdParticipant instanceof XMLSearchParticipant && (xsdContributor = ((XMLSearchParticipant)xsdParticipant).getSearchContributor()) != null) {
                childPatterns = xsdContributor.getReferencesPatterns(componentPattern.getMetaName());
                int i2 = 0;
                while (i2 < childPatterns.length) {
                    XMLSearchPattern childPattern = childPatterns[i2];
                    childPattern.setSearchName(componentPattern.getName().getLocalName());
                    childPattern.setSearchNamespace(componentPattern.getName().getNamespace());
                    patterns.add(childPattern);
                    ++i2;
                }
            }
            componentPattern.addChildren((SearchParticipant)this, patterns.toArray(new XMLSearchPattern[patterns.size()]));
        }
    }
}

