/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ReplicatedService;

final class ImmutableReplicatedService
implements ReplicatedService {
    @Nullable
    private final Long replicas;
    @Nullable
    private final Long maxConcurrent;

    private ImmutableReplicatedService(@Nullable Long replicas, @Nullable Long maxConcurrent) {
        this.replicas = replicas;
        this.maxConcurrent = maxConcurrent;
    }

    @Override
    @JsonProperty(value="Replicas")
    @Nullable
    public Long replicas() {
        return this.replicas;
    }

    @Override
    @JsonProperty(value="MaxConcurrent")
    @Nullable
    public Long maxConcurrent() {
        return this.maxConcurrent;
    }

    public final ImmutableReplicatedService withReplicas(@Nullable Long value) {
        if (Objects.equals(this.replicas, value)) {
            return this;
        }
        return new ImmutableReplicatedService(value, this.maxConcurrent);
    }

    public final ImmutableReplicatedService withMaxConcurrent(@Nullable Long value) {
        if (Objects.equals(this.maxConcurrent, value)) {
            return this;
        }
        return new ImmutableReplicatedService(this.replicas, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReplicatedService && this.equalTo((ImmutableReplicatedService)another);
    }

    private boolean equalTo(ImmutableReplicatedService another) {
        return Objects.equals(this.replicas, another.replicas) && Objects.equals(this.maxConcurrent, another.maxConcurrent);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.replicas);
        h += (h << 5) + Objects.hashCode(this.maxConcurrent);
        return h;
    }

    public String toString() {
        return "ReplicatedService{replicas=" + this.replicas + ", maxConcurrent=" + this.maxConcurrent + "}";
    }

    public static ImmutableReplicatedService copyOf(ReplicatedService instance) {
        if (instance instanceof ImmutableReplicatedService) {
            return (ImmutableReplicatedService)instance;
        }
        return ImmutableReplicatedService.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements ReplicatedService.Builder {
        private Long replicas;
        private Long maxConcurrent;

        private Builder() {
        }

        public final Builder from(ReplicatedService instance) {
            Long maxConcurrentValue;
            Objects.requireNonNull(instance, "instance");
            Long replicasValue = instance.replicas();
            if (replicasValue != null) {
                this.replicas(replicasValue);
            }
            if ((maxConcurrentValue = instance.maxConcurrent()) != null) {
                this.maxConcurrent(maxConcurrentValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Replicas")
        public final Builder replicas(@Nullable Long replicas) {
            this.replicas = replicas;
            return this;
        }

        @Override
        @JsonProperty(value="MaxConcurrent")
        public final Builder maxConcurrent(@Nullable Long maxConcurrent) {
            this.maxConcurrent = maxConcurrent;
            return this;
        }

        @Override
        public ImmutableReplicatedService build() {
            return new ImmutableReplicatedService(this.replicas, this.maxConcurrent);
        }
    }
}

