/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.client.StringKey;

public final class ApprovalCategory {
    public static final Id SUBMIT = new Id("SUBM");
    public static final Id READ = new Id("READ");
    public static final Id OWN = new Id("OWN");
    public static final Id PUSH_TAG = new Id("pTAG");
    public static final short PUSH_TAG_SIGNED = 1;
    public static final short PUSH_TAG_ANNOTATED = 2;
    public static final Id PUSH_HEAD = new Id("pHD");
    public static final short PUSH_HEAD_UPDATE = 1;
    public static final short PUSH_HEAD_CREATE = 2;
    public static final short PUSH_HEAD_REPLACE = 3;
    public static final Id FORGE_IDENTITY = new Id("FORG");
    public static final short FORGE_AUTHOR = 1;
    public static final short FORGE_COMMITTER = 2;
    public static final short FORGE_SERVER = 3;
    @Column(id=1)
    protected Id categoryId;
    @Column(id=2, length=20)
    protected String name;
    @Column(id=3, length=4, notNull=false)
    protected String abbreviatedName;
    @Column(id=4)
    protected short position;
    @Column(id=5)
    protected String functionName;
    @Column(id=6)
    protected boolean copyMinScore;

    protected ApprovalCategory() {
    }

    public ApprovalCategory(Id id, String name) {
        this.categoryId = id;
        this.name = name;
        this.functionName = "MaxWithBlock";
    }

    public Id getId() {
        return this.categoryId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getAbbreviatedName() {
        return this.abbreviatedName;
    }

    public void setAbbreviatedName(String n) {
        this.abbreviatedName = n;
    }

    public short getPosition() {
        return this.position;
    }

    public void setPosition(short p) {
        this.position = p;
    }

    public boolean isAction() {
        return this.position < 0;
    }

    public boolean isRange() {
        return !this.isAction();
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String name) {
        this.functionName = name;
    }

    public boolean isCopyMinScore() {
        return this.copyMinScore;
    }

    public void setCopyMinScore(boolean copy) {
        this.copyMinScore = copy;
    }

    public static class Id
    extends StringKey<Key<?>> {
        private static final long serialVersionUID = 1L;
        @Column(id=1, length=4)
        protected String id;

        protected Id() {
        }

        public Id(String a) {
            this.id = a;
        }

        public String get() {
            return this.id;
        }

        protected void set(String newValue) {
            this.id = newValue;
        }

        public boolean canInheritFromWildProject() {
            return !OWN.equals((Object)this);
        }
    }
}

