/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.helper.AntXMLContext;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JAXPUtils;
import org.eclipse.ant.internal.ui.editor.utils.ProjectHelperMessages;
import org.eclipse.ant.internal.ui.model.IAntModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.BadLocationException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class ProjectHelper
extends ProjectHelper2 {
    private static FileUtils fu = null;
    private File buildFile = null;
    private static String currentEntityName = null;
    private static String currentEntityPath = null;
    private static int currentImportStackSize = 1;
    private static IAntModel fgAntModel;
    private static AntXMLContext fgAntContext;
    private static ProjectHelper2.AntHandler elementHandler;
    private static ProjectHelper2.AntHandler projectHandler;
    private static ProjectHelper2.AntHandler targetHandler;
    private static ProjectHelper2.AntHandler mainHandler;
    private static LexicalHandler lexicalHandler;
    private static XMLReader fgXMLReader;
    private static Map<String, String> parsedProjectNames;

    static {
        elementHandler = new ElementHandler();
        projectHandler = new ProjectHandler();
        targetHandler = new TargetHandler();
        mainHandler = new MainHandler();
        lexicalHandler = new LexHandler();
        fgXMLReader = null;
        parsedProjectNames = null;
    }

    public static String getProjectNameOfBuildFile(IFile buildFile) {
        return parsedProjectNames.get(ProjectHelper.getBuildFileKey(buildFile));
    }

    public static String getProjectNameOfBuildFile(String absolutePath) {
        return parsedProjectNames.get(absolutePath);
    }

    private static String getBuildFileKey(IFile buildFile) {
        return buildFile.getLocation().toFile().getAbsolutePath();
    }

    public static void storeParsedProjectName(String key, String projectName) {
        if (parsedProjectNames == null) {
            parsedProjectNames = new HashMap<String, String>();
        }
        parsedProjectNames.put(key, projectName);
    }

    public static void clearAdditionalPropertyHolders() {
        if (parsedProjectNames != null) {
            parsedProjectNames.clear();
            parsedProjectNames = null;
        }
    }

    public ProjectHelper(IAntModel model) {
        ProjectHelper.setAntModel(model);
    }

    public ProjectHelper() {
    }

    public void parse(Project project, Object source, ProjectHelper2.RootHandler handler) throws BuildException {
        if (!(source instanceof String) && !(source instanceof File)) {
            super.parse(project, source, handler);
            return;
        }
        AntXMLContext context = (AntXMLContext)project.getReference("ant.parsing.context");
        handler = new RootHandler(context, mainHandler);
        try {
            Throwable throwable = null;
            Object var6_11 = null;
            try (InputStream stream = this.createInputStream(source);){
                InputSource inputSource = stream == null ? null : new InputSource(stream);
                XMLReader parser = this.getNamespaceXMLReader();
                if (parser == null) {
                    throw new BuildException(ProjectHelperMessages.ProjectHelper_0);
                }
                String uri = null;
                if (this.buildFile != null) {
                    uri = ProjectHelper.getFileUtils().toURI(this.buildFile.getAbsolutePath());
                }
                if (uri != null) {
                    inputSource.setSystemId(uri);
                }
                context.setBuildFile(this.buildFile);
                parser.setContentHandler((ContentHandler)handler);
                parser.setEntityResolver((EntityResolver)handler);
                parser.setErrorHandler((ErrorHandler)handler);
                parser.setDTDHandler((DTDHandler)handler);
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
                parser.parse(inputSource);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SAXParseException exc) {
            ProjectHelper.getAntModel().fatalError(exc);
        }
        catch (SAXException sAXException) {
        }
        catch (FileNotFoundException exc) {
            throw new BuildException((Throwable)exc);
        }
        catch (UnsupportedEncodingException exc) {
            throw new BuildException((Throwable)exc);
        }
        catch (IOException exc) {
            throw new BuildException((Throwable)exc);
        }
    }

    private InputStream createInputStream(Object source) throws FileNotFoundException, UnsupportedEncodingException {
        if (source instanceof File) {
            this.buildFile = (File)source;
            this.buildFile = ProjectHelper.getFileUtils().normalize(this.buildFile.getAbsolutePath());
            return new FileInputStream(this.buildFile);
        }
        if (source instanceof String) {
            IAntModel model = ProjectHelper.getAntModel();
            String encoding = "UTF-8";
            if (model != null) {
                encoding = model.getEncoding();
            }
            return new ByteArrayInputStream(((String)source).getBytes(encoding));
        }
        return null;
    }

    public void setBuildFile(File file) {
        this.buildFile = file;
        currentImportStackSize = 1;
    }

    public void parse(Project project, Object source) throws BuildException {
        AntXMLContext context = (AntXMLContext)project.getReference("ant.parsing.context");
        if (context == null) {
            this.getImportStack().removeAllElements();
            context = new AntXMLContext(project);
            project.addReference("ant.parsing.context", (Object)context);
            project.addReference("ant.targets", (Object)context.getTargets());
            fgAntContext = context;
        }
        this.getImportStack().addElement(source);
        currentImportStackSize = this.getImportStack().size();
        if (this.getImportStack().size() > 1) {
            context.setIgnoreProjectTag(true);
            Target currentTarget = context.getCurrentTarget();
            Target currentImplicit = context.getImplicitTarget();
            Map currentTargets = context.getCurrentTargets();
            try {
                Target newCurrent = new Target();
                newCurrent.setProject(project);
                newCurrent.setName("");
                context.setCurrentTarget(newCurrent);
                context.setCurrentTargets(new HashMap());
                context.setImplicitTarget(newCurrent);
                this.parse(project, source, new RootHandler(context, mainHandler));
            }
            finally {
                context.setCurrentTarget(currentTarget);
                context.setImplicitTarget(currentImplicit);
                context.setCurrentTargets(currentTargets);
            }
        } else {
            context.setCurrentTargets(new HashMap());
            this.parse(project, source, new RootHandler(context, mainHandler));
        }
    }

    public static void reset() {
        fgXMLReader = null;
        fu = null;
    }

    public static void setAntModel(IAntModel antModel) {
        fgAntModel = antModel;
        ((ElementHandler)elementHandler).reset();
        fu = null;
        fgAntContext = null;
    }

    public static IAntModel getAntModel() {
        return fgAntModel;
    }

    public static AntXMLContext getContext() {
        return fgAntContext;
    }

    private static FileUtils getFileUtils() {
        if (fu == null) {
            fu = FileUtils.getFileUtils();
        }
        return fu;
    }

    private XMLReader getNamespaceXMLReader() throws BuildException {
        if (fgXMLReader == null) {
            try {
                fgXMLReader = this.newSAXParser(this.getNSParserFactory()).getXMLReader();
            }
            catch (SAXException sAXException) {}
        }
        return fgXMLReader;
    }

    private SAXParserFactory getNSParserFactory() throws BuildException {
        SAXParserFactory nsParserFactory = JAXPUtils.newParserFactory();
        nsParserFactory.setNamespaceAware(true);
        return nsParserFactory;
    }

    private SAXParser newSAXParser(SAXParserFactory factory) {
        try {
            return factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        return null;
    }

    public static class ElementHandler
    extends ProjectHelper2.ElementHandler {
        private UnknownElement task = null;
        private Task currentTask = null;
        private final Map<String, String> fNormalizedFileNames = new HashMap<String, String>();

        public ProjectHelper2.AntHandler onStartChild(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) {
            return elementHandler;
        }

        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) {
            try {
                RuntimeConfigurable wrapper = context.currentWrapper();
                this.currentTask = null;
                this.task = null;
                if (wrapper != null && wrapper.getProxy() instanceof Task) {
                    this.currentTask = (Task)wrapper.getProxy();
                }
                this.onStartElement0(uri, tag, qname, attrs, context);
                Locator locator = context.getLocator();
                ProjectHelper.getAntModel().addTask((Task)this.task, this.currentTask, attrs, locator.getLineNumber(), locator.getColumnNumber());
            }
            catch (BuildException be) {
                Locator locator = context.getLocator();
                ProjectHelper.getAntModel().addTask((Task)this.task, this.currentTask, attrs, locator.getLineNumber(), locator.getColumnNumber());
                ProjectHelper.getAntModel().error((Exception)((Object)be));
            }
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
            super.onEndElement(uri, tag, context);
            Locator locator = context.getLocator();
            if (ProjectHelper.getAntModel().canGetTaskInfo()) {
                ProjectHelper.getAntModel().setCurrentElementLength(locator.getLineNumber(), locator.getColumnNumber());
            }
        }

        private void onStartElement0(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) {
            RuntimeConfigurable parentWrapper = context.currentWrapper();
            Object parent = null;
            if (parentWrapper != null) {
                parent = parentWrapper.getProxy();
            }
            this.task = new UnknownElement(tag);
            this.task.setProject(context.getProject());
            this.task.setNamespace(uri);
            this.task.setQName(qname);
            this.task.setTaskType(org.apache.tools.ant.ProjectHelper.genComponentName((String)this.task.getNamespace(), (String)tag));
            this.task.setTaskName(qname);
            Locator contextLocator = context.getLocator();
            String fileName = contextLocator.getSystemId();
            String normalizedFileName = this.fNormalizedFileNames.get(fileName);
            if (normalizedFileName == null) {
                if (fileName.startsWith("file:")) {
                    normalizedFileName = ProjectHelper.getFileUtils().fromURI(fileName);
                    this.fNormalizedFileNames.put(fileName, normalizedFileName);
                } else {
                    normalizedFileName = fileName;
                }
            }
            Target currentTarget = context.getCurrentTarget();
            Location location = new Location(normalizedFileName, contextLocator.getLineNumber(), contextLocator.getColumnNumber());
            this.task.setLocation(location);
            this.task.setOwningTarget(currentTarget);
            if (parent != null) {
                ((UnknownElement)parent).addChild(this.task);
            } else {
                currentTarget.addTask((Task)this.task);
            }
            if (!"augment".equals(this.task.getQName())) {
                context.configureId((Object)this.task, attrs);
            }
            RuntimeConfigurable wrapper = new RuntimeConfigurable((Object)this.task, this.task.getTaskName());
            int i = 0;
            while (i < attrs.getLength()) {
                String attrUri = attrs.getURI(i);
                if (attrUri == null || attrUri.length() == 0 || attrUri.equals(uri)) {
                    int index;
                    String name = attrs.getLocalName(i);
                    String value = attrs.getValue(i);
                    if (name.equals("ant-type") && (index = value.indexOf(58)) != -1) {
                        String prefix = value.substring(0, index);
                        String mappedUri = context.getPrefixMapping(prefix);
                        if (mappedUri == null) {
                            throw new BuildException("Unable to find XML NS prefix " + prefix);
                        }
                        value = org.apache.tools.ant.ProjectHelper.genComponentName((String)mappedUri, (String)value.substring(index + 1));
                    }
                    wrapper.setAttribute(name, value);
                }
                ++i;
            }
            if (parentWrapper != null) {
                parentWrapper.addChild(wrapper);
            }
            context.pushWrapper(wrapper);
        }

        public void characters(char[] buf, int start, int count, AntXMLContext context) {
            try {
                super.characters(buf, start, count, context);
            }
            catch (SAXParseException e) {
                ErrorHelper.handleErrorFromElementText(start, count, context, e);
            }
            catch (BuildException be) {
                ErrorHelper.handleErrorFromElementText(start, count, context, (Exception)((Object)be));
            }
        }

        public void reset() {
            this.task = null;
            this.currentTask = null;
            this.fNormalizedFileNames.clear();
        }
    }

    private static class ErrorHelper {
        private ErrorHelper() {
        }

        public static void handleErrorFromElementText(int start, int count, AntXMLContext context, Exception e) {
            Locator locator = context.getLocator();
            int columnNumber = locator.getColumnNumber();
            if (columnNumber > -1) {
                int offset = start;
                try {
                    offset = ProjectHelper.getAntModel().getOffset(locator.getLineNumber(), 1);
                }
                catch (BadLocationException badLocationException) {}
                ProjectHelper.getAntModel().errorFromElementText(e, offset, locator.getColumnNumber());
            } else {
                ProjectHelper.getAntModel().errorFromElementText(e, start, count);
            }
        }
    }

    private static class LexHandler
    implements LexicalHandler {
        private LexHandler() {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
            if (ProjectHelper.getAntModel().canGetLexicalInfo()) {
                AntXMLContext context = ProjectHelper.getContext();
                Locator locator = context.getLocator();
                ProjectHelper.getAntModel().setCurrentElementLength(locator.getLineNumber(), locator.getColumnNumber());
            }
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            AntXMLContext context;
            Locator locator;
            if (ProjectHelper.getAntModel().canGetLexicalInfo() && (locator = (context = ProjectHelper.getContext()).getLocator()) != null) {
                ProjectHelper.getAntModel().addComment(locator.getLineNumber(), locator.getColumnNumber(), length);
            }
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
            if (currentEntityPath == null) {
                currentEntityName = name;
            } else {
                ProjectHelper.getAntModel().addEntity(name, currentEntityPath);
                currentEntityPath = null;
            }
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (ProjectHelper.getAntModel().canGetLexicalInfo()) {
                AntXMLContext context = ProjectHelper.getContext();
                Locator locator = context.getLocator();
                ProjectHelper.getAntModel().addDTD(name, locator.getLineNumber(), locator.getColumnNumber());
            }
        }
    }

    public static class MainHandler
    extends ProjectHelper2.MainHandler {
        public ProjectHelper2.AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) throws SAXParseException {
            if (name.equals("project") && (uri.length() == 0 || uri.equals("antlib:org.apache.tools.ant"))) {
                return projectHandler;
            }
            try {
                return super.onStartChild(uri, name, qname, attrs, context);
            }
            catch (SAXParseException e) {
                ProjectHelper.getAntModel().error(e);
                throw e;
            }
        }
    }

    public static class ProjectHandler
    extends ProjectHelper2.ProjectHandler {
        public ProjectHelper2.AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) {
            if ((name.equals("target") || name.equals("extension-point")) && (uri.length() == 0 || uri.equals("antlib:org.apache.tools.ant"))) {
                return targetHandler;
            }
            return elementHandler;
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
            super.onEndElement(uri, tag, context);
            if (currentImportStackSize == 1) {
                Locator locator = context.getLocator();
                ProjectHelper.getAntModel().setCurrentElementLength(locator.getLineNumber(), locator.getColumnNumber());
            }
        }

        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) {
            try {
                super.onStartElement(uri, tag, qname, attrs, context);
                String currentProjectName = context.getCurrentProjectName();
                if (this.isCurrentProjectNameValid(currentProjectName)) {
                    if (context.getBuildFile() != null) {
                        ProjectHelper.storeParsedProjectName(context.getBuildFile().getAbsolutePath(), currentProjectName);
                    } else if (context.getBuildFileURL() != null) {
                        ProjectHelper.storeParsedProjectName(new File(context.getBuildFileURL().getPath()).getAbsolutePath(), currentProjectName);
                    }
                }
            }
            catch (SAXParseException e) {
                ProjectHelper.getAntModel().error(e);
            }
            catch (BuildException be) {
                ProjectHelper.getAntModel().error((Exception)((Object)be));
            }
            if (context.getCurrentTarget() == null) {
                context.getProject().addTarget("", context.getImplicitTarget());
                context.setCurrentTarget(context.getImplicitTarget());
            }
            if (currentImportStackSize == 1) {
                Locator locator = context.getLocator();
                ProjectHelper.getAntModel().addProject(context.getProject(), locator.getLineNumber(), locator.getColumnNumber());
            }
        }

        private boolean isCurrentProjectNameValid(String currentProjectName) {
            return currentProjectName != null && !currentProjectName.isEmpty();
        }

        public void characters(char[] buf, int start, int count, AntXMLContext context) {
            try {
                super.characters(buf, start, count, context);
            }
            catch (SAXParseException e) {
                ErrorHelper.handleErrorFromElementText(start, count, context, e);
            }
            catch (BuildException be) {
                ErrorHelper.handleErrorFromElementText(start, count, context, (Exception)((Object)be));
            }
        }
    }

    public static class RootHandler
    extends ProjectHelper2.RootHandler {
        public RootHandler(AntXMLContext context, ProjectHelper2.AntHandler rootHandler) {
            super(context, rootHandler);
        }

        public void error(SAXParseException e) {
            ProjectHelper.getAntModel().error(e);
        }

        public void fatalError(SAXParseException e) {
            ProjectHelper.getAntModel().fatalError(e);
        }

        public void warning(SAXParseException e) {
            ProjectHelper.getAntModel().warning(e);
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            InputSource source = super.resolveEntity(publicId, systemId);
            if (source != null) {
                String path = ProjectHelper.getFileUtils().fromURI(source.getSystemId());
                if (currentEntityName == null) {
                    currentEntityPath = path;
                } else {
                    ProjectHelper.getAntModel().addEntity(currentEntityName, path);
                    currentEntityName = null;
                }
            }
            return source;
        }

        public void startPrefixMapping(String prefix, String uri) {
            super.startPrefixMapping(prefix, uri);
            ProjectHelper.getAntModel().addPrefixMapping(prefix, uri);
        }
    }

    public static class TargetHandler
    extends ProjectHelper2.TargetHandler {
        public ProjectHelper2.AntHandler onStartChild(String uri, String name, String qname, Attributes attrs, AntXMLContext context) {
            return elementHandler;
        }

        public void onStartElement(String uri, String tag, String qname, Attributes attrs, AntXMLContext context) {
            try {
                super.onStartElement(uri, tag, qname, attrs, context);
                Target newTarget = context.getCurrentTarget();
                Locator locator = context.getLocator();
                ProjectHelper.getAntModel().addTarget(newTarget, locator.getLineNumber(), locator.getColumnNumber());
            }
            catch (SAXParseException e) {
                this.handleErrorInTarget(context, e);
            }
            catch (BuildException be) {
                this.handleErrorInTarget(context, (Exception)((Object)be));
            }
        }

        private void handleErrorInTarget(AntXMLContext context, Exception e) {
            Target newTarget = context.getCurrentTarget();
            Locator locator = context.getLocator();
            ProjectHelper.getAntModel().addTarget(newTarget, locator.getLineNumber(), locator.getColumnNumber());
            ProjectHelper.getAntModel().errorFromElement(e, null, locator.getLineNumber(), locator.getColumnNumber());
        }

        public void onEndElement(String uri, String tag, AntXMLContext context) {
            super.onEndElement(uri, tag, context);
            Locator locator = context.getLocator();
            ProjectHelper.getAntModel().setCurrentElementLength(locator.getLineNumber(), locator.getColumnNumber());
        }

        public void characters(char[] buf, int start, int count, AntXMLContext context) {
            try {
                super.characters(buf, start, count, context);
            }
            catch (SAXParseException e) {
                ErrorHelper.handleErrorFromElementText(start, count, context, e);
            }
            catch (BuildException be) {
                ErrorHelper.handleErrorFromElementText(start, count, context, (Exception)((Object)be));
            }
        }
    }
}

