/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.model.AntProjectNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.ant.internal.ui.views.actions.SearchForBuildFilesDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SearchForBuildFilesAction
extends Action {
    private final AntView view;

    public SearchForBuildFilesAction(AntView view) {
        super(AntViewActionMessages.SearchForBuildFilesAction_Search_1, AntUIImages.getImageDescriptor("org.eclipse.ant.ui.search"));
        this.setToolTipText(AntViewActionMessages.SearchForBuildFilesAction_Add_build_files_with_search_2);
        this.view = view;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.ant.ui.search_for_buildfiles_action_context");
    }

    public void run() {
        SearchForBuildFilesDialog dialog = new SearchForBuildFilesDialog();
        if (dialog.open() != 1) {
            final IFile[] files = dialog.getResults();
            final boolean includeErrorNodes = dialog.getIncludeErrorResults();
            final AntProjectNode[] existingProjects = this.view.getProjects();
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(AntViewActionMessages.SearchForBuildFilesAction_Processing_search_results_3, files.length);
                        int i = 0;
                        while (i < files.length && !monitor.isCanceled()) {
                            String buildFileName = files[i].getFullPath().toString();
                            monitor.subTask(MessageFormat.format(AntViewActionMessages.SearchForBuildFilesAction_Adding__0__4, buildFileName));
                            if (!this.alreadyAdded(buildFileName)) {
                                AntProjectNodeProxy project = new AntProjectNodeProxy(buildFileName);
                                project.parseBuildFile();
                                monitor.worked(1);
                                if (includeErrorNodes || !project.isErrorNode()) {
                                    Display.getDefault().asyncExec(() -> SearchForBuildFilesAction.this.view.addProject(project));
                                }
                            }
                            ++i;
                        }
                    }

                    private boolean alreadyAdded(String buildFileName) {
                        AntProjectNode[] antProjectNodeArray = existingProjects;
                        int n = existingProjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            AntProjectNode existingProject = antProjectNodeArray[n2];
                            if (existingProject.getBuildFileName().equals(buildFileName)) {
                                return true;
                            }
                            ++n2;
                        }
                        return false;
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

