/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.label;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.modeler.core.preferences.ShapeStyle;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.impl.DefaultMoveShapeFeature;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class MoveShapeLabelFeature
extends DefaultMoveShapeFeature {
    public MoveShapeLabelFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean canMoveShape(IMoveShapeContext context) {
        return super.canMoveShape(context);
    }

    public void moveShape(IMoveShapeContext context) {
        PictogramElement[] pes = this.getFeatureProvider().getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().getSelectedPictogramElements();
        Shape labelShape = context.getShape();
        PictogramElement[] pictogramElementArray = pes;
        int n = pes.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe = pictogramElementArray[n2];
            ContainerShape s = BusinessObjectUtil.getFirstElementOfType(pe, ContainerShape.class);
            if (s == labelShape) {
                return;
            }
            ++n2;
        }
        ContainerShape elementShape = BusinessObjectUtil.getFirstElementOfType((PictogramElement)labelShape, ContainerShape.class);
        BaseElement element = BusinessObjectUtil.getFirstElementOfType((PictogramElement)elementShape, BaseElement.class);
        ShapeStyle ss = ShapeStyle.getShapeStyle(element);
        if (ss.getLabelPosition() != ShapeStyle.LabelPosition.MOVABLE) {
            GraphicsAlgorithm elementGA = elementShape.getGraphicsAlgorithm();
            MoveShapeContext newContext = new MoveShapeContext((Shape)elementShape);
            newContext.setDeltaX(context.getDeltaX());
            newContext.setDeltaY(context.getDeltaY());
            newContext.setX(elementGA.getX() + context.getDeltaX());
            newContext.setY(elementGA.getY() + context.getDeltaY());
            newContext.setSourceContainer(context.getSourceContainer());
            newContext.setTargetContainer(context.getTargetContainer());
            IMoveShapeFeature f = this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)newContext);
            f.moveShape((IMoveShapeContext)newContext);
        }
        super.moveShape(context);
    }
}

