/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation;

import java.util.List;
import org.eclipse.bpmn2.modeler.core.utils.ErrorUtils;
import org.eclipse.bpmn2.modeler.core.validation.ValidationErrorHandler;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidationListener;
import org.eclipse.emf.validation.service.ValidationEvent;

public class LiveValidationListener
implements IValidationListener {
    static ValidationErrorHandler handler;

    public void validationOccurred(ValidationEvent event) {
        this.reportError(null);
        if (event.getEvaluationMode() == EvaluationMode.LIVE) {
            List results = event.getValidationResults();
            for (IStatus s : results) {
                this.reportError(s);
            }
        }
    }

    public static void setValidationErrorHandler(ValidationErrorHandler h) {
        handler = h;
    }

    private void reportError(IStatus s) {
        if (handler == null) {
            String message = s == null ? null : s.getMessage();
            ErrorUtils.showErrorMessage(message);
        } else {
            handler.reportError(s);
        }
    }
}

