/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property.dialogs;

import java.util.ArrayList;
import org.eclipse.bpmn2.modeler.ui.property.dialogs.ViewerFileFilter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class FileSelectionGroup
extends Composite {
    private Listener listener;
    private String message;
    private IResource selectedResource;
    private TreeViewer treeViewer;
    private ViewerFileFilter viewerFileFilter;
    private String filterPatterns;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 175;
    private static final int SIZING_SELECTION_PANE_WIDTH = 200;

    public FileSelectionGroup(Composite parent, Listener listener, String message) {
        this(parent, listener, message, null);
    }

    public FileSelectionGroup(Composite parent, Listener listener, String message, String filterPatterns) {
        super(parent, 0);
        this.filterPatterns = filterPatterns;
        this.listener = listener;
        this.message = message;
        this.setFont(parent.getFont());
        this.createViewerFileFilter();
        this.createContents();
    }

    public void setFileFilter(String filter) {
        this.filterPatterns = filter;
        this.createViewerFileFilter();
        this.treeViewer.setFilters(new ViewerFilter[]{this.viewerFileFilter});
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public void createViewerFileFilter() {
        if (this.filterPatterns != null) {
            this.viewerFileFilter = new ViewerFileFilter(this.filterPatterns);
        }
    }

    public void createContents() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(this.message != null ? this.message : "");
        label.setFont(this.getFont());
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 200;
        spec.heightHint = 175;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                FileSelectionGroup.this.resourceSelectionChanged((IResource)selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (FileSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        FileSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        FileSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        if (this.viewerFileFilter != null) {
            this.treeViewer.addFilter((ViewerFilter)this.viewerFileFilter);
        }
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getResourceFullPath() {
        if (this.selectedResource == null) {
            return null;
        }
        return this.selectedResource.getFullPath();
    }

    public IResource getSelectedResource() {
        return this.selectedResource;
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    public void resourceSelectionChanged(IResource resource) {
        this.selectedResource = resource;
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void setInitialFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public void setSelectedResource(IResource resource) {
        if (resource == null) {
            return;
        }
        this.selectedResource = resource;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = resource.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)resource), true);
    }
}

