/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.gnu.mingw;

import java.io.File;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.internal.core.MinGW;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;
import org.eclipse.core.runtime.Path;

public class MingwEnvironmentVariableSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private static final String ENV_PATH = "PATH";
    private static final String BACKSLASH = File.separator;
    private static final String PATH_DELIMITER = EnvironmentVariableManager.getDefault().getDefaultDelimiter();

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (variableName.equals("MINGW_HOME")) {
            IEnvironmentVariable varMinGWHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable("MINGW_HOME", null, false);
            if (varMinGWHome == null) {
                String minGWHome = MinGW.getMinGWHome();
                if (minGWHome == null) {
                    minGWHome = "";
                }
                return new BuildEnvVar("MINGW_HOME", new Path(minGWHome).toOSString(), 1);
            }
            return null;
        }
        if (variableName.equals("MSYS_HOME")) {
            IEnvironmentVariable varMsysHome = CCorePlugin.getDefault().getBuildEnvironmentManager().getVariable("MSYS_HOME", null, false);
            if (varMsysHome == null) {
                String msysHome = MinGW.getMSysHome();
                if (msysHome == null) {
                    msysHome = "";
                }
                return new BuildEnvVar("MSYS_HOME", new Path(msysHome).toOSString(), 1);
            }
            return null;
        }
        if (variableName.equals(ENV_PATH)) {
            String path = "${MINGW_HOME}" + BACKSLASH + "bin" + PATH_DELIMITER + "${" + "MSYS_HOME" + "}" + BACKSLASH + "bin" + PATH_DELIMITER + "${" + "MSYS_HOME" + "}" + BACKSLASH + "usr" + BACKSLASH + "bin";
            return new BuildEnvVar(ENV_PATH, path, 3);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        return new IBuildEnvironmentVariable[]{this.getVariable("MINGW_HOME", configuration, provider), this.getVariable("MSYS_HOME", configuration, provider), this.getVariable(ENV_PATH, configuration, provider)};
    }
}

