/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.core.analysis;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacoco.core.analysis.IClassCoverage;
import org.jacoco.core.analysis.ISourceFileCoverage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class AnalyzedNodes {
    static final AnalyzedNodes EMPTY = new AnalyzedNodes(Collections.<IClassCoverage>emptySet(), Collections.<ISourceFileCoverage>emptySet());
    private final Map<String, IClassCoverage> classmap = new HashMap<String, IClassCoverage>();
    private final Map<String, ISourceFileCoverage> sourcemap;

    AnalyzedNodes(Collection<IClassCoverage> classes, Collection<ISourceFileCoverage> sourcefiles) {
        for (IClassCoverage c : classes) {
            this.classmap.put(c.getName(), c);
        }
        this.sourcemap = new HashMap<String, ISourceFileCoverage>();
        for (ISourceFileCoverage s : sourcefiles) {
            String key = this.sourceKey(s.getPackageName(), s.getName());
            this.sourcemap.put(key, s);
        }
    }

    IClassCoverage getClassCoverage(String vmname) {
        return this.classmap.get(vmname);
    }

    ISourceFileCoverage getSourceFileCoverage(String vmpackagename, String filename) {
        return this.sourcemap.get(this.sourceKey(vmpackagename, filename));
    }

    private String sourceKey(String vmpackagename, String filename) {
        return String.valueOf(vmpackagename) + '/' + filename;
    }
}

