/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.spi.common.admin;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.emf.cdo.common.admin.CDOAdmin;
import org.eclipse.emf.cdo.common.admin.CDOAdminRepository;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.TimeoutRuntimeException;
import org.eclipse.net4j.util.container.SetContainer;

public abstract class AbstractCDOAdmin
extends SetContainer<CDOAdminRepository>
implements CDOAdmin {
    private final long timeout;

    protected AbstractCDOAdmin(long timeout) {
        super(CDOAdminRepository.class);
        this.timeout = timeout;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public boolean isClosed() {
        return !this.isActive();
    }

    public void close() {
        this.deactivate();
    }

    @Override
    public CDOAdminRepository[] getRepositories() {
        return (CDOAdminRepository[])this.getElements();
    }

    @Override
    public synchronized CDOAdminRepository getRepository(String name) {
        for (CDOAdminRepository repository : this.getSet()) {
            if (!ObjectUtil.equals((Object)repository.getName(), (Object)name)) continue;
            return repository;
        }
        return null;
    }

    @Override
    public CDOAdminRepository waitForRepository(String name) {
        this.checkActive();
        AbstractCDOAdmin abstractCDOAdmin = this;
        synchronized (abstractCDOAdmin) {
            long end = System.currentTimeMillis() + this.timeout;
            while (System.currentTimeMillis() < end) {
                CDOAdminRepository repository = this.getRepository(name);
                if (repository != null) {
                    return repository;
                }
                try {
                    this.wait(10L);
                }
                catch (InterruptedException ex) {
                    throw WrappedException.wrap((Exception)ex);
                }
            }
            throw new TimeoutRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CDOAdminRepository createRepository(String name, String type, Map<String, Object> properties) {
        this.checkActive();
        AbstractCDOAdmin abstractCDOAdmin = this;
        synchronized (abstractCDOAdmin) {
            block4: {
                if (this.doCreateRepository(name, type, properties)) break block4;
                return null;
            }
            return this.waitForRepository(name);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteRepository(CDOAdminRepository repository, String type) {
        this.checkActive();
        String name = repository.getName();
        AbstractCDOAdmin abstractCDOAdmin = this;
        synchronized (abstractCDOAdmin) {
            if (!this.doDeleteRepository(name, type)) {
                return false;
            }
            long end = System.currentTimeMillis() + this.timeout;
            while (System.currentTimeMillis() < end) {
                if (this.getRepository(name) == null) {
                    return true;
                }
                try {
                    this.wait(10L);
                }
                catch (InterruptedException ex) {
                    return false;
                }
            }
            throw new TimeoutRuntimeException();
        }
    }

    protected CDOAdminRepository[] sortElements(CDOAdminRepository[] array) {
        Arrays.sort(array, new Comparator<CDOAdminRepository>(){

            @Override
            public int compare(CDOAdminRepository r1, CDOAdminRepository r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        return array;
    }

    protected boolean validateElement(CDOAdminRepository repository) {
        return this.getRepository(repository.getName()) == null;
    }

    protected abstract boolean doCreateRepository(String var1, String var2, Map<String, Object> var3);

    protected abstract boolean doDeleteRepository(String var1, String var2);
}

