/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.edit.internal.swt.util;

import java.text.MessageFormat;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.InvalidDatatypeValueException;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VDiagnostic;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationService;
import org.eclipse.emfforms.spi.common.validation.PreSetValidationServiceRunnable;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsContextListener;
import org.eclipse.emfforms.spi.core.services.view.EMFFormsViewContext;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public final class PreSetValidationListeners {
    @Deprecated
    private static PreSetValidationListeners validationListeners;
    @Deprecated
    private static ServiceTracker<PreSetValidationService, PreSetValidationService> serviceTracker;
    private final ViewModelContext context;
    private PreSetValidationService preSetValidationService;

    @Deprecated
    private PreSetValidationListeners() {
        this(null);
    }

    private PreSetValidationListeners(ViewModelContext context) {
        this.context = context;
        this.init(context);
    }

    @Deprecated
    public static PreSetValidationListeners create() {
        if (validationListeners == null) {
            validationListeners = new PreSetValidationListeners();
        }
        return validationListeners;
    }

    public static PreSetValidationListeners create(ViewModelContext context) {
        String key = PreSetValidationListeners.class.getName();
        PreSetValidationListeners result = (PreSetValidationListeners)context.getContextValue(key);
        if (result == null) {
            result = new PreSetValidationListeners(context);
            context.putContextValue(key, (Object)result);
        }
        return result;
    }

    @Deprecated
    private static PreSetValidationService getPreSetValidationService() {
        if (serviceTracker == null) {
            BundleContext bundleContext = FrameworkUtil.getBundle(PreSetValidationListeners.class).getBundleContext();
            serviceTracker = new ServiceTracker(bundleContext, PreSetValidationService.class, null);
            serviceTracker.open();
        }
        return (PreSetValidationService)serviceTracker.getService();
    }

    private void init(ViewModelContext context) {
        if (context == null) {
            this.preSetValidationService = PreSetValidationListeners.getPreSetValidationService();
        } else if (context.hasService(PreSetValidationService.class)) {
            this.preSetValidationService = (PreSetValidationService)context.getService(PreSetValidationService.class);
        }
    }

    public void verify(Text text, EStructuralFeature feature) {
        this.verify(text, feature, null);
    }

    public void verify(Combo combo, EStructuralFeature feature) {
        this.verify(combo, feature, null);
    }

    public void verify(Text text, EStructuralFeature feature, VElement vElement) {
        if (!EAttribute.class.isInstance(feature)) {
            return;
        }
        EAttribute attribute = (EAttribute)feature;
        if (this.preSetValidationService != null) {
            PreSetVerifyListener verifyListener = new PreSetVerifyListener(vElement, attribute, this, this.preSetValidationService);
            verifyListener.register((Control)text);
        }
    }

    public void verify(Combo combo, EStructuralFeature feature, VElement vElement) {
        if (!EAttribute.class.isInstance(feature)) {
            return;
        }
        EAttribute attribute = (EAttribute)feature;
        if (this.preSetValidationService != null) {
            PreSetVerifyListener verifyListener = new PreSetVerifyListener(vElement, attribute, this, this.preSetValidationService);
            verifyListener.register((Control)combo);
        }
    }

    protected VDiagnostic validateStrict(EStructuralFeature feature, Object value) {
        Diagnostic strictDiag = this.preSetValidationService.validate(feature, value);
        VDiagnostic vDiagnostic = VViewFactory.eINSTANCE.createDiagnostic();
        if (strictDiag.getSeverity() != 0) {
            vDiagnostic.getDiagnostics().add((Object)strictDiag);
            return vDiagnostic;
        }
        if (feature.isRequired() && (value == null || this.isString(feature.getEType()) && "".equals(value))) {
            BasicDiagnostic multiplicityDiagnostic = new BasicDiagnostic(4, "", 1, MessageFormat.format("The required feature ''{0}'' must be set", feature.getName()), new Object[0]);
            vDiagnostic.getDiagnostics().add((Object)multiplicityDiagnostic);
            return vDiagnostic;
        }
        return null;
    }

    private boolean isString(EClassifier classifier) {
        return classifier.getInstanceTypeName().equals(String.class.getCanonicalName());
    }

    public void focus(Text text, EStructuralFeature feature, final PreSetValidationServiceRunnable focusLost, final Runnable focusGained) {
        if (this.preSetValidationService != null) {
            text.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    focusLost.run(PreSetValidationListeners.this.preSetValidationService);
                }

                public void focusGained(FocusEvent e) {
                    focusGained.run();
                }
            });
        }
    }

    public static class PreSetVerifyListener
    implements VerifyListener {
        private final EAttribute attribute;
        private final VElement vElement;
        private final PreSetValidationListeners validationListeners;
        private final PreSetValidationService preSetValidationService;
        private Control control;

        @Deprecated
        public PreSetVerifyListener(VElement vElement, EAttribute attribute) {
            this(vElement, attribute, validationListeners, PreSetValidationListeners.getPreSetValidationService());
        }

        PreSetVerifyListener(VElement vElement, EAttribute attribute, PreSetValidationListeners validationListeners, PreSetValidationService preSetValidationService) {
            this.vElement = vElement;
            this.attribute = attribute;
            this.validationListeners = validationListeners;
            this.preSetValidationService = preSetValidationService;
            validationListeners.context.registerEMFFormsContextListener(this.createContextListener());
        }

        public void verifyText(VerifyEvent e) {
            Diagnostic looseDiag;
            VDiagnostic prevDiagnostic;
            Object changedValue;
            String changedText = this.obtainText(e);
            try {
                changedValue = EcoreUtil.createFromString((EDataType)this.attribute.getEAttributeType(), (String)changedText);
            }
            catch (IllegalArgumentException | InvalidDatatypeValueException formatException) {
                if (this.isInteger(this.attribute.getEType()) && changedText.isEmpty() || XMLGregorianCalendar.class.isAssignableFrom(this.attribute.getEType().getInstanceClass()) || Double.TYPE.isAssignableFrom(this.attribute.getEType().getInstanceClass()) || Double.class.isAssignableFrom(this.attribute.getEType().getInstanceClass())) {
                    return;
                }
                e.doit = false;
                return;
            }
            VDiagnostic vDiagnostic = prevDiagnostic = this.vElement == null ? null : this.vElement.getDiagnostic();
            if (this.vElement != null) {
                this.vElement.setDiagnostic(this.validationListeners.validateStrict((EStructuralFeature)this.attribute, changedValue));
            }
            if ((looseDiag = this.preSetValidationService.validateLoose((EStructuralFeature)this.attribute, changedValue)).getSeverity() == 0) {
                return;
            }
            if (this.validationListeners.isString(this.attribute.getEType())) {
                e.doit = false;
                if (this.vElement != null) {
                    this.vElement.setDiagnostic(prevDiagnostic);
                }
            }
        }

        protected String obtainText(VerifyEvent event) {
            String currentText = "";
            if (event.widget instanceof Text) {
                currentText = ((Text)Text.class.cast(event.widget)).getText();
            } else if (event.widget instanceof Combo) {
                currentText = ((Combo)Combo.class.cast(event.widget)).getText();
            }
            String changedText = String.valueOf(currentText.substring(0, event.start)) + event.text + currentText.substring(event.end);
            return changedText;
        }

        private boolean isInteger(EClassifier classifier) {
            return classifier.getInstanceTypeName().equals(Integer.class.getCanonicalName());
        }

        private void register(Control control) {
            this.control = control;
            control.getDisplay().asyncExec(this::start);
        }

        private void start() {
            if (this.control != null && !this.control.isDisposed()) {
                if (this.control instanceof Text) {
                    ((Text)this.control).addVerifyListener((VerifyListener)this);
                } else if (this.control instanceof Combo) {
                    ((Combo)this.control).addVerifyListener((VerifyListener)this);
                }
            }
        }

        private Control stop() {
            Control result = this.control;
            if (this.control != null && !this.control.isDisposed()) {
                if (this.control instanceof Text) {
                    ((Text)this.control).removeVerifyListener((VerifyListener)this);
                } else if (this.control instanceof Combo) {
                    ((Combo)this.control).removeVerifyListener((VerifyListener)this);
                }
            }
            this.control = null;
            return result;
        }

        private EMFFormsContextListener createContextListener() {
            return new EMFFormsContextListener(){
                private Control control;

                public void contextInitialised() {
                    if (this.control != null && !this.control.isDisposed()) {
                        this.register(this.control);
                    }
                }

                public void contextDispose() {
                    this.control = this.stop();
                }

                public void childContextAdded(VElement parentElement, EMFFormsViewContext childContext) {
                }

                public void childContextDisposed(EMFFormsViewContext childContext) {
                }
            };
        }
    }
}

