/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ClassnameLockManager {
    private final ConcurrentHashMap<String, LockWithCount> classnameLocks = new ConcurrentHashMap(5000);

    private Lock acquireLock(String classname, boolean writeLock) {
        Lock[] lockWrapper = new Lock[1];
        this.classnameLocks.compute(classname, (key, existingEntry) -> {
            LockWithCount resultingEntry = existingEntry != null ? existingEntry : new LockWithCount();
            lockArray[0] = writeLock ? resultingEntry.lock.writeLock() : resultingEntry.lock.readLock();
            resultingEntry.count.incrementAndGet();
            return resultingEntry;
        });
        lockWrapper[0].lock();
        return lockWrapper[0];
    }

    public byte[] executeRead(String classname, ReadOperation readOperation) {
        Lock lock = this.acquireLock(classname, false);
        try {
            byte[] byArray = readOperation.read();
            return byArray;
        }
        finally {
            this.releaseLock(classname, lock);
        }
    }

    public void executeWrite(String classname, WriteOperation writeOperation) throws IOException {
        Lock lock = this.acquireLock(classname, true);
        try {
            writeOperation.write();
        }
        finally {
            this.releaseLock(classname, lock);
        }
    }

    private void releaseLock(String classname, Lock lock) {
        this.classnameLocks.computeIfPresent(classname, (key, existingEntry) -> {
            lock.unlock();
            return existingEntry.count.decrementAndGet() == 0 ? null : existingEntry;
        });
    }

    private static class LockWithCount {
        final AtomicInteger count;
        final ReadWriteLock lock = new ReentrantReadWriteLock();

        LockWithCount() {
            this.count = new AtomicInteger(0);
        }
    }

    @FunctionalInterface
    public static interface ReadOperation {
        public byte[] read();
    }

    @FunctionalInterface
    public static interface WriteOperation {
        public void write() throws IOException;
    }
}

