/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.internal.figures;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;

public class LabelHelper {
    public static Point offsetFromRelativeCoordinate(IFigure label, Rectangle bounds, Point ref) {
        return LabelHelper.offsetFromRelativeCoordinate(label, bounds, LabelHelper.getParentPointList(label), ref);
    }

    private static Point offsetFromRelativeCoordinate(IFigure label, Rectangle bounds, PointList points, Point ref) {
        Rectangle rect = new Rectangle(bounds);
        rect.translate(rect.width / 2, rect.height / 2);
        Point normalPoint = LabelHelper.normalizeRelativePointToPointOnLine(points, ref, new Point(rect.x - ref.x, rect.y - ref.y));
        return normalPoint;
    }

    public static Point relativeCoordinateFromOffset(IFigure label, Point ref, Point offset) {
        return LabelHelper.relativeCoordinateFromOffset(label, LabelHelper.getParentPointList(label), ref, offset);
    }

    private static Point relativeCoordinateFromOffset(IFigure label, PointList points, Point ref, Point offset) {
        Point location = LabelHelper.calculatePointRelativeToPointOnLine(points, ref, offset);
        location.translate(-1 * label.getBounds().width / 2, -1 * label.getBounds().height / 2);
        return location;
    }

    private static PointList getParentPointList(IFigure label) {
        IFigure parent = label.getParent();
        if (parent instanceof Connection) {
            return ((Connection)parent).getPoints();
        }
        PointList ptList = new PointList();
        ptList.addPoint(parent.getBounds().getLocation());
        return ptList;
    }

    protected static Point calculatePointRelativeToPointOnLine(PointList ptLst, Point ptOnLine, Point offset) {
        if (ptLst.size() == 1) {
            return ptLst.getFirstPoint().getTranslated(offset);
        }
        if (ptLst.size() >= 2) {
            int index = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)ptLst, (Point)ptOnLine);
            if (index < 1) {
                return ptLst.getFirstPoint().getTranslated(offset);
            }
            LineSeg segment = (LineSeg)PointListUtilities.getLineSegments((PointList)ptLst).get(index - 1);
            Point relativeOffset = null;
            if (segment != null) {
                if (segment.isHorizontal()) {
                    if (segment.getOrigin().x > segment.getTerminus().x) {
                        relativeOffset = ptOnLine.getTranslated(offset.getNegated());
                        return relativeOffset;
                    }
                    relativeOffset = ptOnLine.getTranslated(offset);
                    return relativeOffset;
                }
                if (segment.isVertical()) {
                    if (segment.getOrigin().y > segment.getTerminus().y) {
                        relativeOffset = ptOnLine.getTranslated(offset.getCopy().scale(-1.0, 1.0).transpose());
                        return relativeOffset;
                    }
                    relativeOffset = ptOnLine.getTranslated(offset.getCopy().scale(1.0, -1.0).transpose());
                    return relativeOffset;
                }
                double slope = segment.slope();
                double theta = Math.atan(slope);
                Point normalizedOffset = new Point(offset);
                Point calculatedOffset = new Point();
                if (segment.getOrigin().x > segment.getTerminus().x) {
                    normalizedOffset = offset.getCopy().scale(-1.0, -1.0);
                }
                calculatedOffset = new PrecisionPoint((double)normalizedOffset.x * Math.cos(theta) - (double)normalizedOffset.y * Math.sin(theta), (double)normalizedOffset.x * Math.sin(theta) + (double)normalizedOffset.y * Math.cos(theta));
                relativeOffset = ptOnLine.getTranslated(calculatedOffset);
                return relativeOffset;
            }
        }
        return null;
    }

    private static Point normalizeRelativePointToPointOnLine(PointList ptLst, Point ptOnLine, Point offset) {
        if (ptLst.size() == 1) {
            return offset;
        }
        if (ptLst.size() >= 2) {
            int index = PointListUtilities.findNearestLineSegIndexOfPoint((PointList)ptLst, (Point)ptOnLine);
            LineSeg segment = (LineSeg)PointListUtilities.getLineSegments((PointList)ptLst).get(index - 1);
            Point normalOffset = null;
            if (segment != null) {
                if (segment.isHorizontal()) {
                    if (segment.getOrigin().x > segment.getTerminus().x) {
                        normalOffset = offset.getNegated();
                        return normalOffset;
                    }
                    normalOffset = offset;
                    return normalOffset;
                }
                if (segment.isVertical()) {
                    if (segment.getOrigin().y < segment.getTerminus().y) {
                        normalOffset = offset.scale(-1.0, 1.0).transpose();
                        return normalOffset;
                    }
                    normalOffset = offset.scale(1.0, -1.0).transpose();
                    return normalOffset;
                }
                Point p = ptOnLine.getTranslated(offset);
                normalOffset = LabelHelper.getOrthogonalDistances(segment, ptOnLine, p);
                return normalOffset;
            }
        }
        return null;
    }

    private static Point getOrthogonalDistances(LineSeg lineSeg, Point ptOnLine, Point refPoint) {
        LineSeg parallelSeg = lineSeg.getParallelLineSegThroughPoint(refPoint);
        Point p1 = parallelSeg.perpIntersect(ptOnLine.x, ptOnLine.y);
        double dx = p1.getDistance(refPoint) * (double)(p1.x > refPoint.x ? -1 : 1);
        double dy = p1.getDistance(ptOnLine) * (double)(p1.y < ptOnLine.y ? -1 : 1);
        PrecisionPoint orth = new PrecisionPoint(dx, dy);
        if (lineSeg.getOrigin().x > lineSeg.getTerminus().x) {
            orth = orth.scale(-1.0, -1.0);
        }
        return orth;
    }
}

