/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.internal.command.CommandContainer;
import org.eclipse.graphiti.internal.command.DefaultExecutionInfo;
import org.eclipse.graphiti.internal.command.FeatureCommand;
import org.eclipse.graphiti.internal.command.GFPreparableCommand2;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.graphiti.ui.internal.command.AddModelObjectCommand;
import org.eclipse.graphiti.ui.internal.command.ContextEntryCommand;
import org.eclipse.graphiti.ui.internal.command.CreateConnectionCommand;
import org.eclipse.graphiti.ui.internal.command.GFCommand;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.command.ReconnectCommand;
import org.eclipse.graphiti.ui.internal.services.GraphitiUiInternal;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;

public class GFCommandStack
extends CommandStack
implements CommandStackListener {
    static final String OPTION_EXECUTION_INFO = "org.eclipse.graphiti.execution.info";
    private TransactionalCommandStack emfCommandStack;
    private IConfigurationProvider configurationProvider;
    private TransactionalEditingDomain editingDomain;

    public GFCommandStack(IConfigurationProvider configurationProvider, TransactionalEditingDomain editingDomain) {
        org.eclipse.emf.common.command.CommandStack commandStack = editingDomain.getCommandStack();
        if (!(commandStack instanceof TransactionalCommandStack)) {
            IllegalArgumentException e = new IllegalArgumentException("The command stack of the passed editing domain must be a TransactionalCommandStack");
            e.fillInStackTrace();
            throw e;
        }
        this.emfCommandStack = (TransactionalCommandStack)commandStack;
        this.emfCommandStack.addCommandStackListener((CommandStackListener)this);
        this.setConfigurationProvider(configurationProvider);
        this.editingDomain = editingDomain;
    }

    public boolean canRedo() {
        return this.getEmfCommandStack().canRedo();
    }

    public boolean canUndo() {
        return this.getEmfCommandStack().canUndo();
    }

    public void dispose() {
        super.dispose();
        this.emfCommandStack.removeCommandStackListener((CommandStackListener)this);
        this.emfCommandStack = null;
        this.configurationProvider = null;
        this.editingDomain = null;
    }

    public void execute(org.eclipse.gef.commands.Command gefCommand) {
        if (gefCommand == null) {
            return;
        }
        Command emfCommand = GraphitiUiInternal.getCommandService().transformFromGefToEmfCommand(gefCommand);
        GFPreparableCommand2 gfPreparableCommand = new GFPreparableCommand2(this.getTransactionalEditingDomain(), emfCommand);
        IToolBehaviorProvider tbp = this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
        DefaultExecutionInfo executionInfo = new DefaultExecutionInfo();
        GraphitiUiInternal.getCommandService().completeExecutionInfo(executionInfo, gefCommand);
        HashMap<String, DefaultExecutionInfo> options = new HashMap<String, DefaultExecutionInfo>(2);
        options.put(OPTION_EXECUTION_INFO, executionInfo);
        IUndoContext[][] contexts = new IUndoContext[][]{};
        if (this.emfCommandStack instanceof IWorkspaceCommandStack) {
            IUndoableOperation[] originalRedoOperations = ((IWorkspaceCommandStack)this.emfCommandStack).getOperationHistory().getRedoHistory(IOperationHistory.GLOBAL_UNDO_CONTEXT);
            contexts = new IUndoContext[originalRedoOperations.length][];
            int i = 0;
            while (i < originalRedoOperations.length) {
                contexts[i] = originalRedoOperations[i].getContexts();
                ++i;
            }
        }
        tbp.preExecute((IExecutionInfo)executionInfo);
        try {
            this.getEmfCommandStack().execute((Command)gfPreparableCommand, options);
        }
        catch (RollbackException e) {
            if (e.getStatus().getSeverity() == 8) {
                T.racer().log(1, "Command execution was cancelled: " + e.getMessage());
            } else {
                T.racer().error("GFCommandStack.execute(Command) " + (Object)((Object)e), e);
            }
        }
        catch (Exception e) {
            T.racer().error("GFCommandStack.execute(Command) " + e, e);
        }
        tbp.postExecute((IExecutionInfo)executionInfo);
        ArrayList<IFeature> features = new ArrayList<IFeature>(2);
        if (gefCommand instanceof GefCommandWrapper) {
            GefCommandWrapper gefCommandWrapper = (GefCommandWrapper)gefCommand;
            ICommand command = gefCommandWrapper.getCommand();
            this.extractFeatures(features, command);
        } else {
            this.extractFeatures(features, gefCommand);
        }
        boolean changesDone = false;
        if (features.size() == 0) {
            changesDone = true;
        }
        for (IFeature feature : features) {
            if (!feature.hasDoneChanges()) continue;
            changesDone = true;
            break;
        }
        if (!changesDone && this.emfCommandStack instanceof IWorkspaceCommandStack) {
            IWorkspaceCommandStack workspaceCommandStackImpl = (IWorkspaceCommandStack)this.getEmfCommandStack();
            IUndoContext context = workspaceCommandStackImpl.getDefaultUndoContext();
            IUndoableOperation operation = workspaceCommandStackImpl.getOperationHistory().getUndoOperation(context);
            workspaceCommandStackImpl.getOperationHistory().replaceOperation(operation, new IUndoableOperation[0]);
            IUndoableOperation[] newRedoOperations = workspaceCommandStackImpl.getOperationHistory().getRedoHistory(IOperationHistory.GLOBAL_UNDO_CONTEXT);
            int i = 0;
            while (i < newRedoOperations.length) {
                int j = 0;
                while (j < contexts[i].length) {
                    if (!newRedoOperations[i].hasContext(contexts[i][j])) {
                        newRedoOperations[i].addContext(contexts[i][j]);
                    }
                    ++j;
                }
                ++i;
            }
            this.notifyListeners(gefCommand, 824);
        }
    }

    private void extractFeatures(List<IFeature> features, Object command) {
        block4: {
            block9: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block3: {
                                    if (!(command instanceof FeatureCommand)) break block3;
                                    features.add(((FeatureCommand)command).getFeature());
                                    break block4;
                                }
                                if (!(command instanceof ContextEntryCommand)) break block5;
                                features.add(((ContextEntryCommand)((Object)command)).getContextEntry().getFeature());
                                break block4;
                            }
                            if (!(command instanceof AddModelObjectCommand)) break block6;
                            IFeatureAndContext[] innerFeatures = ((AddModelObjectCommand)command).getFeaturesAndContexts();
                            int i = 0;
                            while (i < innerFeatures.length) {
                                features.add(innerFeatures[i].getFeature());
                                ++i;
                            }
                            break block4;
                        }
                        if (!(command instanceof CreateConnectionCommand)) break block7;
                        IFeatureAndContext[] innerFeatures = ((CreateConnectionCommand)command).getFeaturesAndContexts();
                        int i = 0;
                        while (i < innerFeatures.length) {
                            features.add(innerFeatures[i].getFeature());
                            ++i;
                        }
                        break block4;
                    }
                    if (!(command instanceof GFCommand)) break block8;
                    features.add(((GFCommand)command).getFeature());
                    break block4;
                }
                if (!(command instanceof ReconnectCommand)) break block9;
                features.add(((ReconnectCommand)command).getFeature());
                break block4;
            }
            if (!(command instanceof CommandContainer)) break block4;
            ICommand[] innerCommands = ((CommandContainer)command).getCommands();
            int i = 0;
            while (i < innerCommands.length) {
                this.extractFeatures(features, innerCommands[i]);
                ++i;
            }
        }
    }

    public void flush() {
        super.flush();
    }

    public Object[] getCommands() {
        return super.getCommands();
    }

    public org.eclipse.gef.commands.Command getRedoCommand() {
        Command emfCommand = this.getEmfCommandStack().getRedoCommand();
        return emfCommand != null ? GraphitiUiInternal.getCommandService().transformFromEmfToGefCommand(emfCommand) : null;
    }

    public org.eclipse.gef.commands.Command getUndoCommand() {
        Command emfCommand = this.getEmfCommandStack().getUndoCommand();
        return emfCommand != null ? GraphitiUiInternal.getCommandService().transformFromEmfToGefCommand(emfCommand) : null;
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void redo() {
        this.getEmfCommandStack().redo();
    }

    public void undo() {
        this.getEmfCommandStack().undo();
    }

    private TransactionalCommandStack getEmfCommandStack() {
        return this.emfCommandStack;
    }

    private TransactionalEditingDomain getTransactionalEditingDomain() {
        return this.editingDomain;
    }

    public void commandStackChanged(EventObject event) {
        this.notifyListeners();
        this.notifyListeners(null, 0);
    }

    private IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    private void setConfigurationProvider(IConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }
}

