/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.man.help;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.IUAElement;
import org.eclipse.linuxtools.internal.man.help.Messages;
import org.eclipse.linuxtools.internal.man.help.SectionTopic;
import org.eclipse.linuxtools.internal.man.parser.ManParser;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ManualToc
implements IToc {
    private final Map<String, SectionTopic> sections = new HashMap<String, SectionTopic>();

    public ITopic[] getTopics() {
        if (this.sections.isEmpty()) {
            this.generateSections();
        }
        ArrayList<SectionTopic> sectionList = new ArrayList<SectionTopic>(this.sections.values());
        Collections.sort(sectionList);
        return sectionList.toArray(new SectionTopic[sectionList.size()]);
    }

    private void generateSections() {
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){
            private final Pattern p = Pattern.compile("^man\\d[xp]?");

            @Override
            public boolean accept(Path path) throws IOException {
                Matcher m = this.p.matcher(path.getFileName().toString());
                return Files.isDirectory(path, new LinkOption[0]) && m.matches();
            }
        };
        List manPaths = ManParser.getManPaths();
        for (Path manPath : manPaths) {
            if (Files.notExists(manPath, new LinkOption[0])) continue;
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (DirectoryStream<Path> manPathStream = Files.newDirectoryStream(manPath, (DirectoryStream.Filter<? super Path>)filter);){
                    for (Path sectionPath : manPathStream) {
                        Throwable throwable2 = null;
                        Object var11_15 = null;
                        try (DirectoryStream<Path> sectionPathStream = Files.newDirectoryStream(sectionPath);){
                            for (Path pagePath : sectionPathStream) {
                                String pageName = pagePath.getFileName().toString();
                                if (pageName.endsWith(".gz")) {
                                    pageName = pageName.substring(0, pageName.length() - 3);
                                }
                                int dot = pageName.lastIndexOf(46);
                                String sectionId = pageName.substring(dot + 1, pageName.length());
                                String pageId = pageName.substring(0, dot);
                                this.addSectionPage(sectionId, pageId);
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Bundle bundle = FrameworkUtil.getBundle(this.getClass());
                Platform.getLog((Bundle)bundle).log(Status.error((String)e.getMessage(), (Throwable)e));
            }
        }
    }

    public ITopic getTopic(String href) {
        return null;
    }

    public boolean isEnabled(IEvaluationContext context) {
        return true;
    }

    public IUAElement[] getChildren() {
        return this.getTopics();
    }

    public String getHref() {
        return null;
    }

    public String getLabel() {
        return Messages.ManualToc_TocLabel;
    }

    private void addSectionPage(String sectionId, String pageId) {
        StringBuilder label = new StringBuilder();
        String displaySectionId = sectionId;
        switch (sectionId.substring(0, 1)) {
            case "0": {
                label.append(Messages.ManualToc_Section0);
                break;
            }
            case "1": {
                label.append(Messages.ManualToc_Section1);
                break;
            }
            case "2": {
                label.append(Messages.ManualToc_Section2);
                break;
            }
            case "3": {
                label.append(Messages.ManualToc_Section3);
                break;
            }
            case "4": {
                label.append(Messages.ManualToc_Section4);
                break;
            }
            case "5": {
                label.append(Messages.ManualToc_Section5);
                break;
            }
            case "6": {
                label.append(Messages.ManualToc_Section6);
                break;
            }
            case "7": {
                label.append(Messages.ManualToc_Section7);
                break;
            }
            case "8": {
                label.append(Messages.ManualToc_Section8);
                break;
            }
            case "9": {
                label.append(Messages.ManualToc_Section9);
            }
        }
        switch (sectionId.substring(1, sectionId.length())) {
            case "am": {
                label.append(Messages.ManualToc_SectionAM);
                break;
            }
            case "G": {
                label.append(Messages.ManualToc_SectionG);
                break;
            }
            case "p": {
                label.append(Messages.ManualToc_SectionP);
                break;
            }
            case "pm": {
                label.append(Messages.ManualToc_SectionPM);
                break;
            }
            case "python": {
                label.append(Messages.ManualToc_SectionPY);
                break;
            }
            case "x": {
                label.append(Messages.ManualToc_SectionX);
                break;
            }
            case "ssl": {
                label.append(Messages.ManualToc_SectionSSL);
                break;
            }
            case "stap": {
                label.append(Messages.ManualToc_SectionSTAP);
                break;
            }
            default: {
                displaySectionId = sectionId.substring(0, 1);
            }
        }
        SectionTopic section = this.sections.get(displaySectionId);
        if (section == null) {
            section = new SectionTopic(displaySectionId, label.toString());
            this.sections.put(displaySectionId, section);
        }
        section.addPage(sectionId, pageId);
    }
}

