/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.scanners;

import java.util.ArrayList;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.KeywordWordDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.MacroWordDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.PatchNumberDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.SuffixNumberDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.detectors.TagWordDetector;
import org.eclipse.linuxtools.internal.rpm.ui.editor.rules.CommentRule;
import org.eclipse.linuxtools.internal.rpm.ui.editor.rules.MacroRule;
import org.eclipse.linuxtools.internal.rpm.ui.editor.rules.StringWithEndingRule;
import org.eclipse.ui.PlatformUI;

public class SpecfileScanner
extends RuleBasedScanner {
    private static final String[] SECTIONS = new String[]{"%prep", "%build", "%install", "%pretrans", "%pre", "%preun", "%post", "%files", "%changelog", "%package", "%description", "%postun", "%posttrans", "%clean", "%check"};
    public static final String[] DEFINED_MACROS = new String[]{"%define", "%global", "%make", "%setup", "%autosetup", "%autopatch", "%attrib", "%defattr", "%attr", "%dir", "%config", "%docdir", "%doc", "%lang", "%license", "%verify", "%ghost"};
    private static final String[] KEYWORDS = new String[]{"%if", "%ifarch", "%ifnarch", "%else", "%endif"};
    private static final String[] TAGS = new String[]{"Summary", "Name", "Version", "Packager", "Icon", "URL", "Prefix", "Group", "License", "Release", "BuildRoot", "Distribution", "Vendor", "Provides", "ExclusiveArch", "ExcludeArch", "ExclusiveOS", "BuildArch", "BuildArchitectures", "AutoRequires", "AutoReq", "AutoReqProv", "AutoProv", "Epoch"};

    public SpecfileScanner() {
        ColorRegistry colors = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
        Token sectionToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.sections"), null, 2));
        Token macroToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.macros")));
        Token keywordToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.keywords"), null, 1));
        Token tagToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.tags")));
        Token commentToken = new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.editor.color.comment")));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add((Object)new CommentRule((IToken)commentToken));
        rules.add((Object)new MacroRule((IToken)macroToken));
        WordRule wordRule = new WordRule((IWordDetector)new MacroWordDetector(), Token.UNDEFINED);
        String[] stringArray = DEFINED_MACROS;
        int n = DEFINED_MACROS.length;
        int n2 = 0;
        while (n2 < n) {
            String definedMacro = stringArray[n2];
            wordRule.addWord(definedMacro, (IToken)macroToken);
            ++n2;
        }
        rules.add(wordRule);
        rules.add(new StringWithEndingRule("%patch", new PatchNumberDetector(), (IToken)macroToken, false));
        wordRule = new WordRule((IWordDetector)new KeywordWordDetector(), Token.UNDEFINED);
        stringArray = KEYWORDS;
        n = KEYWORDS.length;
        n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            wordRule.addWord(keyword, (IToken)keywordToken);
            ++n2;
        }
        rules.add(wordRule);
        wordRule = new WordRule((IWordDetector)new KeywordWordDetector(), Token.UNDEFINED);
        stringArray = SECTIONS;
        n = SECTIONS.length;
        n2 = 0;
        while (n2 < n) {
            String section = stringArray[n2];
            wordRule.addWord(section, (IToken)sectionToken);
            ++n2;
        }
        rules.add(wordRule);
        wordRule = new WordRule((IWordDetector)new TagWordDetector(), Token.UNDEFINED);
        stringArray = TAGS;
        n = TAGS.length;
        n2 = 0;
        while (n2 < n) {
            String tag = stringArray[n2];
            wordRule.addWord(tag + ":", (IToken)tagToken);
            ++n2;
        }
        rules.add(wordRule);
        rules.add(new StringWithEndingRule("Source", new SuffixNumberDetector(), (IToken)tagToken, false));
        rules.add(new StringWithEndingRule("Patch", new SuffixNumberDetector(), (IToken)tagToken, false));
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
        this.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(colors.get("org.eclipse.linuxtools.rpm.edtor.color.default"))));
    }
}

