/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.vagrant.ui.wizards;

import java.nio.file.Paths;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.typed.BeanProperties;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.internal.vagrant.core.EnvironmentsManager;
import org.eclipse.linuxtools.internal.vagrant.ui.SWTImagesFactory;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.CreateVMAdvancedComposite;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.CreateVMPageModel;
import org.eclipse.linuxtools.internal.vagrant.ui.wizards.WizardMessages;
import org.eclipse.linuxtools.vagrant.core.IVagrantBox;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CreateVMPage
extends WizardPage {
    private final CreateVMPageModel model;
    private final DataBindingContext dbc;
    private CreateVMAdvancedComposite advanced;

    public CreateVMPage(IVagrantBox box) {
        super("createVMPage", WizardMessages.getString("CreateVM.label"), SWTImagesFactory.DESC_BANNER_REPOSITORY);
        this.setMessage(WizardMessages.getString("CreateVM.desc"));
        this.model = new CreateVMPageModel();
        if (box != null) {
            this.model.setBoxRef(box.getName());
        }
        this.dbc = new DataBindingContext();
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public String getVMName() {
        return this.model.getVFileMode() ? null : this.model.getVMName();
    }

    public String getBoxReference() {
        return this.model.getVFileMode() ? null : this.model.getBoxRef();
    }

    public String getVMFile() {
        return this.model.getVFileMode() ? this.model.getVMFile() : null;
    }

    public Map<String, String> getEnvironment() {
        return this.model.getEnvironment();
    }

    public void createControl(Composite parent) {
        ScrolledComposite scrollTop = new ScrolledComposite(parent, 768);
        scrollTop.setExpandVertical(true);
        scrollTop.setExpandHorizontal(true);
        Composite container = new Composite((Composite)scrollTop, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).margins(6, 6).applyTo(container);
        Label vmNameLabel = new Label(container, 0);
        vmNameLabel.setText(WizardMessages.getString("CreateVM.name.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)vmNameLabel);
        Text vmNameText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)vmNameText);
        vmNameText.setToolTipText(WizardMessages.getString("CreateVMPage.name.tooltip"));
        IObservableValue vmmNameObservable = BeanProperties.value(CreateVMPageModel.class, (String)"VMName", String.class).observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)vmNameText), vmmNameObservable);
        Label boxRefLabel = new Label(container, 0);
        boxRefLabel.setText(WizardMessages.getString("CreateVMPage.boxRef.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)boxRefLabel);
        Text boxRefText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)boxRefText);
        boxRefText.setToolTipText(WizardMessages.getString("CreateVMPage.boxRef.tooltip"));
        IObservableValue boxRefObservable = BeanProperties.value(CreateVMPageModel.class, (String)"boxRef", String.class).observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)boxRefText), boxRefObservable);
        Button boxSearchButton = new Button(container, 0);
        boxSearchButton.setText(WizardMessages.getString("CreateVMPage.search.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)boxSearchButton);
        boxSearchButton.addSelectionListener(this.onSearchImage());
        Button customVMFileButton = new Button(container, 32);
        customVMFileButton.setText(WizardMessages.getString("CreateVMPage.File.CheckBox"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).span(3, 1).applyTo((Control)customVMFileButton);
        IObservableValue customVMFileObservable = BeanProperties.value(CreateVMPageModel.class, (String)"VFileMode", String.class).observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.widgetSelection().observe((Widget)customVMFileButton), customVMFileObservable);
        Label boxLocLabel = new Label(container, 0);
        boxLocLabel.setText(WizardMessages.getString("CreateVMPage.loc.label"));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)boxLocLabel);
        Text boxLocText = new Text(container, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)boxLocText);
        boxLocText.setToolTipText(WizardMessages.getString("CreateVMPage.loc.tooltip"));
        boxLocText.setEnabled(false);
        IObservableValue boxLocObservable = BeanProperties.value(CreateVMPageModel.class, (String)"VMFile", String.class).observe((Object)this.model);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)boxLocText), boxLocObservable);
        boxLocText.addModifyListener(e -> this.vmFileChanged(boxLocText.getText()));
        Button vgFilesearchButton = new Button(container, 0);
        vgFilesearchButton.setText(WizardMessages.getString("CreateVMPage.search.label"));
        vgFilesearchButton.setEnabled(false);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(false, false).applyTo((Control)vgFilesearchButton);
        vgFilesearchButton.addSelectionListener(this.onSearchVMFile());
        customVMFileButton.addSelectionListener(this.onCheckCustomVMFile(vmNameText, boxRefText, boxLocText, vgFilesearchButton, boxSearchButton));
        this.dbc.addValidationStatusProvider((ValidationStatusProvider)new CreateVMValidationStatusProvider((IObservableValue<String>)vmmNameObservable, (IObservableValue<String>)boxRefObservable, (IObservableValue<String>)boxLocObservable));
        this.advanced = new CreateVMAdvancedComposite(container, scrollTop, this.model);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).applyTo((Control)this.advanced);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        scrollTop.setContent((Control)container);
        Point point = container.computeSize(-1, -1);
        scrollTop.setSize(point);
        scrollTop.setMinSize(point);
        this.setControl((Control)container);
    }

    private SelectionListener onCheckCustomVMFile(Text vmNameText, Text boxRefText, Text boxLocText, Button searchButton, Button boxSearchButton) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            Widget widget = e.widget;
            if (widget instanceof Button) {
                void bt;
                Button button3 = (Button)widget;
                Button cfr_ignored_0 = (Button)widget;
                if (bt.getSelection()) {
                    vmNameText.setEnabled(false);
                    boxRefText.setEnabled(false);
                    boxSearchButton.setEnabled(false);
                    searchButton.setEnabled(true);
                    boxLocText.setEnabled(true);
                    this.model.setVFileMode(true);
                } else {
                    vmNameText.setEnabled(true);
                    boxRefText.setEnabled(true);
                    boxSearchButton.setEnabled(true);
                    searchButton.setEnabled(false);
                    boxLocText.setEnabled(false);
                    this.model.setVFileMode(false);
                }
            }
        });
    }

    private SelectionListener onSearchImage() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog fd = new FileDialog(this.getShell());
            String location = fd.open();
            if (location != null && !location.isEmpty()) {
                this.model.setBoxRef(location);
            }
        });
    }

    private SelectionListener onSearchVMFile() {
        return SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog fd = new FileDialog(this.getShell());
            String location = fd.open();
            if (location != null && !location.isEmpty()) {
                this.model.setVMFile(location);
                this.vmFileChanged(location);
            }
        });
    }

    private void vmFileChanged(String vagrantFile) {
        IPath folder = new Path(vagrantFile).removeLastSegments(1);
        Map existingEnv = EnvironmentsManager.getSingleton().getEnvironment(folder.toFile());
        if (existingEnv != null) {
            this.model.setEnvironment(existingEnv);
            this.advanced.refresh();
        }
    }

    private class CreateVMValidationStatusProvider
    extends MultiValidator {
        private IObservableValue<String> vmNameOb;
        private IObservableValue<String> boxRefOb;
        private IObservableValue<String> boxLocOb;

        public CreateVMValidationStatusProvider(IObservableValue<String> vmNameOb, IObservableValue<String> boxRefOb, IObservableValue<String> boxLocOb) {
            this.vmNameOb = vmNameOb;
            this.boxRefOb = boxRefOb;
            this.boxLocOb = boxLocOb;
        }

        public IObservableList<IObservable> getTargets() {
            return new WritableList();
        }

        protected IStatus validate() {
            String vmName = (String)this.vmNameOb.getValue();
            String boxRef = (String)this.boxRefOb.getValue();
            String boxLoc = (String)this.boxLocOb.getValue();
            if (!CreateVMPage.this.model.getVFileMode()) {
                if (vmName == null || vmName.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("CreateVMPage.emptyVMName"));
                }
                if (boxRef == null || boxRef.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("CreateVMPage.emptyBoxRef"));
                }
            } else {
                if (boxLoc == null || boxLoc.isEmpty()) {
                    return ValidationStatus.error((String)WizardMessages.getString("CreateVMPage.emptyVagrantfile"));
                }
                if (!Paths.get(boxLoc, new String[0]).toFile().canRead()) {
                    return ValidationStatus.error((String)WizardMessages.getString("CreateVMPage.invalidVagrantfile"));
                }
            }
            return ValidationStatus.ok();
        }
    }
}

