/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor;

import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.m2e.pde.target.MavenTargetLocation;
import org.eclipse.m2e.pde.ui.target.editor.AbstractFeatureSpecPage;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.BundleProviderHistoryUtil;
import org.eclipse.pde.internal.ui.wizards.feature.FeatureData;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class FeatureSpecPage
extends AbstractFeatureSpecPage {
    private Combo fFeatureProviderCombo;
    private Text fFeatureIdText;
    private MavenTargetLocation targetLocation;

    public FeatureSpecPage(MavenTargetLocation targetLocation) {
        this.targetLocation = targetLocation;
        this.setTitle(PDEUIMessages.NewFeatureWizard_SpecPage_title);
        this.setDescription(PDEUIMessages.NewFeatureWizard_SpecPage_desc);
    }

    @Override
    protected void initialize() {
        this.fFeatureVersionText.setText("1.0.0.qualifier");
        this.setMessage(PDEUIMessages.NewFeatureWizard_MainPage_desc);
    }

    @Override
    public FeatureData getFeatureData() {
        FeatureData data = new FeatureData();
        data.id = this.fFeatureIdText.getText();
        data.version = this.fFeatureVersionText.getText();
        data.provider = this.fFeatureProviderCombo.getText();
        data.name = this.fFeatureNameText.getText();
        data.library = this.getInstallHandlerLibrary();
        return data;
    }

    @Override
    protected String validateContent() {
        this.setMessage(null);
        return null;
    }

    @Override
    protected String getHelpId() {
        return "org.eclipse.pde.doc.user.new_feature_data";
    }

    @Override
    protected void createContents(Composite container) {
        IFeature template;
        Composite group = new Composite(container, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(768);
        gd.verticalIndent = 10;
        group.setLayoutData((Object)gd);
        Label label = new Label(group, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_id);
        this.fFeatureIdText = new Text(group, 2048);
        this.fFeatureIdText.setLayoutData((Object)new GridData(768));
        this.createCommonInput(group);
        label = new Label(group, 0);
        label.setText(PDEUIMessages.NewFeatureWizard_SpecPage_provider);
        this.fFeatureProviderCombo = new Combo(group, 2052);
        this.fFeatureProviderCombo.setLayoutData((Object)new GridData(768));
        BundleProviderHistoryUtil.loadHistory((Combo)this.fFeatureProviderCombo, (IDialogSettings)this.getDialogSettings());
        this.createInstallHandlerText(group);
        if (this.targetLocation != null && (template = this.targetLocation.getFeatureTemplate()) != null) {
            this.fFeatureIdText.setText(Objects.requireNonNullElse(template.getId(), ""));
            this.fFeatureNameText.setText(Objects.requireNonNullElse(template.getLabel(), ""));
            this.fFeatureVersionText.setText(Objects.requireNonNullElse(template.getVersion(), ""));
            this.fFeatureProviderCombo.setText(Objects.requireNonNullElse(template.getProviderName(), ""));
            IFeatureInstallHandler handler = template.getInstallHandler();
            if (handler != null) {
                this.fLibraryText.setText(handler.getHandlerName());
            }
        }
    }

    @Override
    protected void attachListeners(ModifyListener listener) {
        this.fFeatureProviderCombo.addModifyListener(listener);
        this.fFeatureIdText.addModifyListener(listener);
    }

    @Override
    protected String getFeatureId() {
        return this.fFeatureIdText.getText();
    }

    public void update(IFeatureModel model, boolean createFeatureInfos) throws CoreException {
        IFeatureInstallHandler handler;
        FeatureData featureData = this.getFeatureData();
        IFeature feature = model.getFeature();
        feature.setLabel(featureData.name);
        feature.setId(featureData.id);
        feature.setVersion(featureData.version);
        feature.setProviderName(featureData.provider);
        if (featureData.hasCustomHandler()) {
            feature.setInstallHandler(model.getFactory().createInstallHandler());
        }
        if ((handler = feature.getInstallHandler()) != null) {
            handler.setLibrary(featureData.library);
        }
        if (createFeatureInfos) {
            IFeatureInfo info = model.getFactory().createInfo(1);
            feature.setFeatureInfo(info, 1);
            info.setURL("http://www.example.com/copyright");
            info.setDescription(PDEUIMessages.NewFeatureWizard_sampleCopyrightDesc);
            info = model.getFactory().createInfo(2);
            feature.setFeatureInfo(info, 2);
            info.setURL("http://www.example.com/license");
            info.setDescription(PDEUIMessages.NewFeatureWizard_sampleLicenseDesc);
            info = model.getFactory().createInfo(0);
            feature.setFeatureInfo(info, 0);
            info.setURL("http://www.example.com/description");
            info.setDescription(PDEUIMessages.NewFeatureWizard_sampleDescriptionDesc);
        }
    }

    @Override
    protected void saveSettings(IDialogSettings settings) {
        BundleProviderHistoryUtil.saveHistory((Combo)this.fFeatureProviderCombo, (IDialogSettings)settings);
    }
}

