/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.query.ui.views.queryExecution.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.modisco.infra.common.core.internal.builder.AbstractMoDiscoCatalog;
import org.eclipse.modisco.infra.common.core.internal.utils.ModelUtils;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.infra.common.ui.internal.util.ImageUtils;
import org.eclipse.modisco.infra.query.ModelQuery;
import org.eclipse.modisco.infra.query.ModelQuerySet;
import org.eclipse.modisco.infra.query.core.AbstractModelQuery;
import org.eclipse.modisco.infra.query.core.IQuerySetProvider;
import org.eclipse.modisco.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.modisco.infra.query.core.exception.BundleClassPathException;
import org.eclipse.modisco.infra.query.core.exception.ExecutionEnvironmentException;
import org.eclipse.modisco.infra.query.core.exception.MissingBundleException;
import org.eclipse.modisco.infra.query.runtime.ModelQueryContext;
import org.eclipse.modisco.infra.query.runtime.ModelQueryResult;
import org.eclipse.modisco.infra.query.runtime.RuntimeFactory;
import org.eclipse.modisco.infra.query.ui.Activator;
import org.eclipse.modisco.infra.query.ui.Messages;
import org.eclipse.modisco.infra.query.ui.actions.CreateQuerySetAction;
import org.eclipse.modisco.infra.query.ui.controls.QueryFilteredTree;
import org.eclipse.modisco.infra.query.ui.filters.QueryScopeFilter;
import org.eclipse.modisco.infra.query.ui.views.queryExecution.internal.ContextPaneMenuManager;
import org.eclipse.modisco.infra.query.ui.views.queryExecution.internal.DropAdapter;
import org.eclipse.modisco.infra.query.ui.views.queryExecution.internal.EditableContext;
import org.eclipse.modisco.infra.query.ui.views.queryExecution.internal.QueryResultDisplayersRegistry;
import org.eclipse.modisco.infra.query.ui.views.queryExecution.internal.QueryTooltip;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

@Deprecated
public class QueryExecutionView
extends ViewPart {
    private static final String QUERY_SET_PROVIDER_EXTENSION_POINT = "org.eclipse.modisco.infra.query.core.querySetProvider";
    private static final int EXECUTE_BUTTON_MIN_WIDTH = 100;
    public static final String ID = "org.eclipse.modisco.infra.query.ui.queryExecutionView";
    private TreeViewer contextViewer;
    private Composite mainComposite;
    private Composite parentComposite;
    private final Set<EObject> fContext = new HashSet<EObject>();
    private LayoutStyle layoutStyle = LayoutStyle.Horizontal;
    private QueryFilteredTree querySelectionFilteredTree;
    private Combo comboResultDisplayer;
    private AbstractMoDiscoCatalog.ModiscoCatalogChangeListener modiscoCatalogChangeListener;
    private List<IQuerySetProvider> fQuerySetProviders = null;
    private Job refreshJob = null;

    public void createPartControl(final Composite parent) {
        this.parentComposite = parent;
        parent.setLayout((Layout)this.gridLayoutWithNoMargins());
        this.layoutStyle = LayoutStyle.Horizontal;
        this.createMainComposite();
        parent.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LayoutStyle oldLayoutStyle = QueryExecutionView.this.layoutStyle;
                Point size = parent.getSize();
                QueryExecutionView.this.layoutStyle = size.x > size.y ? LayoutStyle.Horizontal : LayoutStyle.Vertical;
                if (QueryExecutionView.this.layoutStyle != oldLayoutStyle) {
                    QueryExecutionView.this.createMainComposite();
                }
            }
        });
        this.modiscoCatalogChangeListener = new AbstractMoDiscoCatalog.ModiscoCatalogChangeListener(){

            public void removed(IFile file) {
                QueryExecutionView.this.refreshQueries();
            }

            public void changed(EObject eObject, IFile file) {
                QueryExecutionView.this.refreshQueries();
            }

            public void added(EObject eObject, IFile file) {
                QueryExecutionView.this.refreshQueries();
            }
        };
        ModelQuerySetCatalog.getSingleton().addChangeListener(this.modiscoCatalogChangeListener);
        this.createContextMenu();
    }

    protected void createContextMenu() {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IAction)new CreateQuerySetAction());
        contextMenu.add((IContributionItem)new GroupMarker("additions"));
        TreeViewer viewer = this.querySelectionFilteredTree.getViewer();
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    public void dispose() {
        ModelQuerySetCatalog.getSingleton().removeChangeListener(this.modiscoCatalogChangeListener);
        super.dispose();
    }

    private void refreshQueries() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                QueryExecutionView.this.updateQueriesInput();
            }
        });
    }

    private void createMainComposite() {
        if (this.mainComposite != null) {
            this.mainComposite.dispose();
        }
        this.mainComposite = new Composite(this.parentComposite, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)this.gridLayoutWithNoMargins());
        int direction = this.layoutStyle == LayoutStyle.Horizontal ? 256 : 512;
        SashForm sashForm = new SashForm(this.mainComposite, 0x10000 | direction);
        sashForm.setLayout((Layout)new FillLayout());
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createContextGroup((Composite)sashForm);
        Composite lastGroup = new Composite((Composite)sashForm, 0);
        this.createQueryGroup(lastGroup);
        lastGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gridLayout = this.layoutStyle == LayoutStyle.Horizontal ? new GridLayout(2, false) : new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        lastGroup.setLayout((Layout)gridLayout);
        this.createExecuteGroup(lastGroup);
    }

    private GridLayout gridLayoutWithNoMargins() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        return gridLayout;
    }

    private void createQueryGroup(Composite parent) {
        Group queryGroup = new Group(parent, 0);
        queryGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        queryGroup.setText(Messages.QueryExecutionView_Query);
        GridLayout groupLayout = new GridLayout();
        queryGroup.setLayout((Layout)groupLayout);
        ArrayList<ModelQuerySet> querySets = new ArrayList<ModelQuerySet>();
        querySets.addAll(ModelQuerySetCatalog.getSingleton().getAllModelQuerySets());
        querySets.addAll(this.dynamicQuerySets(new ArrayList<EObject>()));
        this.querySelectionFilteredTree = new QueryFilteredTree((Composite)queryGroup, querySets, null, false);
        GridData controlData = new GridData(4, 4, true, true);
        this.querySelectionFilteredTree.setLayoutData(controlData);
        this.querySelectionFilteredTree.getViewer().addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                QueryExecutionView.this.executeClicked();
            }
        });
        QueryTooltip queryTooltip = new QueryTooltip();
        queryTooltip.installOn(this.querySelectionFilteredTree.getViewer().getTree());
    }

    private Collection<? extends ModelQuerySet> dynamicQuerySets(Collection<EObject> context) {
        List<IQuerySetProvider> querySetProviders = this.getQuerySetProviders();
        ArrayList dynamicQuerySets = new ArrayList();
        for (IQuerySetProvider querySetProvider : querySetProviders) {
            dynamicQuerySets.addAll(querySetProvider.getQuerySets(context));
        }
        return dynamicQuerySets;
    }

    private List<IQuerySetProvider> getQuerySetProviders() {
        if (this.fQuerySetProviders == null) {
            IConfigurationElement[] configs;
            this.fQuerySetProviders = new ArrayList<IQuerySetProvider>();
            IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(QUERY_SET_PROVIDER_EXTENSION_POINT);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement config = iConfigurationElementArray[n2];
                try {
                    Object executableExtension = config.createExecutableExtension("class");
                    if (executableExtension instanceof IQuerySetProvider) {
                        IQuerySetProvider querySetProvider = (IQuerySetProvider)executableExtension;
                        this.fQuerySetProviders.add(querySetProvider);
                    }
                }
                catch (CoreException e) {
                    MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                }
                ++n2;
            }
        }
        return this.fQuerySetProviders;
    }

    private void createContextGroup(Composite parent) {
        Group contextGroup = new Group(parent, 0);
        contextGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        contextGroup.setText(Messages.QueryExecutionView_Context);
        GridLayout groupLayout = new GridLayout();
        contextGroup.setLayout((Layout)groupLayout);
        this.createContextViewer(contextGroup);
    }

    private void createContextViewer(Group contextGroup) {
        this.contextViewer = new TreeViewer((Composite)contextGroup, 2050);
        GridData listData = new GridData(4, 4, true, true);
        this.contextViewer.getTree().setLayoutData((Object)listData);
        this.addDropSupport(this.contextViewer);
        this.createContextMenu(this.contextViewer);
        this.contextViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof Set) {
                    Set set = (Set)inputElement;
                    if (!set.isEmpty()) {
                        if (set.size() > 1000) {
                            ArrayList<ElementsGroup> groups = new ArrayList<ElementsGroup>();
                            Iterator iterator = set.iterator();
                            int start = 0;
                            while (start < set.size()) {
                                int end = start + 1000;
                                if (end > set.size()) {
                                    end = set.size();
                                }
                                ArrayList<Object> elementsList = new ArrayList<Object>();
                                int i = start;
                                while (i < end) {
                                    Object element = iterator.next();
                                    elementsList.add(element);
                                    ++i;
                                }
                                groups.add(new ElementsGroup(start, end, elementsList, set.size()));
                                start += 1000;
                            }
                            return groups.toArray(new ElementsGroup[groups.size()]);
                        }
                        return set.toArray();
                    }
                    return new Object[]{Messages.QueryExecutionView_dragAndDropHint};
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof ElementsGroup;
            }

            public Object getParent(Object element) {
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof ElementsGroup) {
                    ElementsGroup elementsGroup = (ElementsGroup)parentElement;
                    return elementsGroup.getElements().toArray();
                }
                return null;
            }
        });
        this.contextViewer.setLabelProvider((IBaseLabelProvider)new QueryContextLabelProvider());
        this.contextViewer.setInput(this.fContext);
        this.contextViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                LabelProvider labelProvider = (LabelProvider)QueryExecutionView.this.contextViewer.getLabelProvider();
                String label1 = labelProvider.getText(e1);
                String label2 = labelProvider.getText(e2);
                return label1.compareToIgnoreCase(label2);
            }
        });
    }

    private EditableContext createEditableContext() {
        return new EditableContext(){

            @Override
            public void add(EObject eObject) {
                QueryExecutionView.this.fContext.add(eObject);
            }

            @Override
            public void remove(EObject eObject) {
                QueryExecutionView.this.fContext.remove(eObject);
            }

            @Override
            public void clear() {
                QueryExecutionView.this.fContext.clear();
            }

            @Override
            public void done() {
                QueryExecutionView.this.refreshContextViewer();
            }
        };
    }

    private void createContextMenu(TreeViewer treeViewer) {
        ContextPaneMenuManager menuManager = new ContextPaneMenuManager(this, this.createEditableContext(), treeViewer);
        Menu menu = menuManager.createContextMenu((Control)treeViewer.getTree());
        treeViewer.getTree().setMenu(menu);
    }

    private void addDropSupport(TreeViewer viewer) {
        DropAdapter dropTargetListener = new DropAdapter(new DropAdapter.DropAction(){

            @Override
            public void dropped(Set<EObject> eObjects) {
                QueryExecutionView.this.fContext.addAll(eObjects);
                QueryExecutionView.this.refreshContextViewerDelayed();
            }
        });
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)dropTargetListener);
    }

    protected void refreshContextViewerDelayed() {
        if (this.refreshJob == null) {
            this.refreshJob = new Job(Messages.QueryExecutionView_refreshing){

                protected IStatus run(IProgressMonitor monitor) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            QueryExecutionView.this.refreshContextViewer();
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
        } else {
            this.refreshJob.cancel();
        }
        this.refreshJob.setPriority(50);
        int delay = 100;
        this.refreshJob.schedule(100L);
    }

    private void refreshContextViewer() {
        this.contextViewer.refresh();
        this.updateQueriesInput();
        this.updateScopeFilters();
    }

    private void updateQueriesInput() {
        ArrayList<ModelQuerySet> querySets = new ArrayList<ModelQuerySet>();
        querySets.addAll(ModelQuerySetCatalog.getSingleton().getAllModelQuerySets());
        querySets.addAll(this.dynamicQuerySets(this.fContext));
        this.querySelectionFilteredTree.setInput(querySets);
    }

    private void updateScopeFilters() {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        HashSet<EClass> classes = new HashSet<EClass>();
        for (EObject eObject : this.fContext) {
            classes.add(eObject.eClass());
        }
        for (EClass eClass : classes) {
            filters.add(new QueryScopeFilter(eClass));
        }
        this.querySelectionFilteredTree.setFilters(filters);
    }

    private void createExecuteGroup(Composite parent) {
        Group executeGroup = new Group(parent, 0);
        executeGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        executeGroup.setText(Messages.QueryExecutionView_ExecuteGroup);
        executeGroup.setLayout((Layout)new GridLayout());
        this.createDisplayStyleComposite(executeGroup);
        Button buttonExecute = new Button((Composite)executeGroup, 8);
        buttonExecute.setText(Messages.QueryExecutionView_ExecuteButton);
        GridData buttonData = new GridData(0x1000000, 0, true, false);
        buttonData.minimumWidth = 100;
        buttonExecute.setLayoutData((Object)buttonData);
        buttonExecute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QueryExecutionView.this.executeClicked();
            }
        });
    }

    protected void executeClicked() {
        ModelQuerySetCatalog querySetCatalog = ModelQuerySetCatalog.getSingleton();
        ModelQuery selectedQuery = this.getSelectedQuery();
        if (selectedQuery != null) {
            try {
                AbstractModelQuery modelQueryImpl = querySetCatalog.getModelQueryImpl(selectedQuery);
                ModelQueryContext modelQueryContext = RuntimeFactory.eINSTANCE.createModelQueryContext();
                modelQueryContext.getSelectedModelElements().addAll(this.fContext);
                List result = modelQueryImpl.evaluate(modelQueryContext, Collections.emptyList());
                if (this.checkResult(result)) {
                    this.displayResult(result);
                }
            }
            catch (ExecutionEnvironmentException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_execEnvNotAvailable, (String)NLS.bind((String)Messages.QueryExecutionView_execEnvError, (Object)e.getRequiredExecEnv(), (Object)e.getAvailableExecEnv()));
            }
            catch (MissingBundleException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_0, (String)NLS.bind((String)Messages.QueryExecutionView_1, (Object)e.getBundleName()));
            }
            catch (BundleClassPathException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_errorInBundleClasspath, (String)NLS.bind((String)Messages.QueryExecutionView_classpathWarning, (Object)e.getProject().getName(), (Object)e.getOutputLocation()));
            }
            catch (Exception e) {
                StackTraceElement[] stackTrace = e.getStackTrace();
                String stack = "";
                if (stackTrace.length > 0) {
                    stack = "\nat:" + stackTrace[0].toString();
                }
                String message = e.getMessage() != null ? " : " + e.getMessage() : "";
                MessageDialog.openError((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_ErrorExecutingQuery, (String)(String.valueOf(e.getClass().getSimpleName()) + message + stack));
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
        } else {
            MessageDialog.openInformation((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_NoQuerySelected, (String)Messages.QueryExecutionView_SelectQueryToExecute);
        }
    }

    private boolean checkResult(List<ModelQueryResult> result) {
        for (ModelQueryResult modelQueryResult : result) {
            Exception exc = modelQueryResult.getException();
            if (exc == null) continue;
            MoDiscoLogger.logError((Throwable)exc, (String)"Query exception", (Plugin)Activator.getDefault());
            MessageDialog.openError((Shell)this.mainComposite.getShell(), (String)Messages.QueryExecutionView_QueryException, (String)(String.valueOf(exc.getClass().getSimpleName()) + " : " + exc.getMessage()));
            return false;
        }
        return true;
    }

    private void displayResult(List<ModelQueryResult> result) {
        String displayerName = this.comboResultDisplayer.getText();
        QueryResultDisplayersRegistry.NamedQueryResultDisplayer queryResultDisplayer = QueryResultDisplayersRegistry.getInstance().getQueryResultDisplayer(displayerName);
        if (queryResultDisplayer != null) {
            queryResultDisplayer.getDisplayer().displayQueryResult(result);
        } else {
            String message = NLS.bind((String)"Query Displayer with name \"{0}\" not found", (Object)displayerName);
            MoDiscoLogger.logError((String)message, (Plugin)Activator.getDefault());
            MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)Messages.QueryExecutionView_NoQueryDisplayer, (String)message);
        }
    }

    private ModelQuery getSelectedQuery() {
        IStructuredSelection structuredSelection;
        Object selectedElement;
        ISelection selection = this.querySelectionFilteredTree.getViewer().getSelection();
        if (selection instanceof IStructuredSelection && (selectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof ModelQuery) {
            ModelQuery selectedQuery = (ModelQuery)selectedElement;
            return selectedQuery;
        }
        return null;
    }

    private void createDisplayStyleComposite(Group executeGroup) {
        Composite displayStyleComposite = new Composite((Composite)executeGroup, 0);
        displayStyleComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        displayStyleComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(displayStyleComposite, 0);
        label.setText(Messages.QueryExecutionView_DisplayResultIn);
        this.comboResultDisplayer = new Combo(displayStyleComposite, 12);
        List<QueryResultDisplayersRegistry.NamedQueryResultDisplayer> queryResultDisplayers = QueryResultDisplayersRegistry.getInstance().getQueryResultDisplayers();
        for (QueryResultDisplayersRegistry.NamedQueryResultDisplayer namedQueryResultDisplayer : queryResultDisplayers) {
            this.comboResultDisplayer.add(namedQueryResultDisplayer.getName());
        }
        this.comboResultDisplayer.select(0);
        this.comboResultDisplayer.setLayoutData((Object)new GridData(4, 0, true, false));
    }

    public void setFocus() {
        this.querySelectionFilteredTree.setFocus();
    }

    public void setContext(List<EObject> selectedEObjects) {
        this.fContext.clear();
        this.fContext.addAll(selectedEObjects);
        this.refreshContextViewer();
    }

    public void setSelectedQueries(List<ModelQuery> queries) {
        this.querySelectionFilteredTree.getViewer().setSelection((ISelection)new StructuredSelection(queries));
    }

    public ContextInfo getContextInfo() {
        ContextInfo contextSelectionInfo = new ContextInfo(new ArrayList<EObject>(this.fContext));
        ISelection selection = this.contextViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object selectedElement : structuredSelection) {
                if (!(selectedElement instanceof EObject)) continue;
                EObject eObject = (EObject)selectedElement;
                contextSelectionInfo.addSelectedEObject(eObject);
            }
        }
        return contextSelectionInfo;
    }

    public final class ContextInfo {
        private final List<EObject> eObjects;
        private final List<EObject> selectedEObjects = new ArrayList<EObject>();

        private ContextInfo(List<EObject> eObjects) {
            this.eObjects = eObjects;
        }

        public List<EObject> getEObjects() {
            return this.eObjects;
        }

        private void addSelectedEObject(EObject eObject) {
            this.selectedEObjects.add(eObject);
        }

        public List<EObject> getSelectedEObjects() {
            return this.selectedEObjects;
        }
    }

    private static class ElementsGroup {
        public static final int GROUP_SIZE = 1000;
        private final List<Object> elements;
        private final int start;
        private final int end;
        private final int fullListSize;

        public ElementsGroup(int first, int last, List<Object> elements, int fullListSize) {
            this.start = first;
            this.end = last;
            this.elements = elements;
            this.fullListSize = fullListSize;
        }

        public List<Object> getElements() {
            return this.elements;
        }

        public String toString() {
            int maxDigits = (int)Math.ceil(Math.log10(this.fullListSize));
            StringBuilder buffer = new StringBuilder();
            buffer.append("[");
            String strStartIndex = "" + this.start;
            String strEndIndex = "" + (this.end - 1);
            this.zeroes(maxDigits - strStartIndex.length(), buffer);
            buffer.append(strStartIndex);
            buffer.append("..");
            this.zeroes(maxDigits - strEndIndex.length(), buffer);
            buffer.append(strEndIndex);
            buffer.append("]");
            return buffer.toString();
        }

        private void zeroes(int count, StringBuilder buffer) {
            int i = 0;
            while (i < count) {
                buffer.append('0');
                ++i;
            }
        }
    }

    private static enum LayoutStyle {
        Horizontal,
        Vertical;

    }

    private final class QueryContextLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private final Color gray;

        public QueryContextLabelProvider() {
            Display display = Display.getCurrent();
            RGB rgbGray = new RGB(128, 128, 128);
            this.gray = new Color((Device)display, rgbGray);
        }

        public String getText(Object element) {
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                String prefix = "";
                EClass eClass = eObject.eClass();
                if (eClass != null) {
                    prefix = "[" + eClass.getName() + "] ";
                }
                return String.valueOf(prefix) + ModelUtils.getName((EObject)eObject);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            return ImageUtils.getImage((Object)element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof String) {
                return this.gray;
            }
            return null;
        }

        public void dispose() {
            super.dispose();
            this.gray.dispose();
        }
    }
}

