/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;

public class ZipFileUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> unzipFiles(File zippedfile, String destPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipFile zipFile = new ZipFile(zippedfile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ArrayList<File> outputFiles = new ArrayList<File>();
            File destinationFile = new File(destPath);
            if (!destinationFile.exists()) {
                destinationFile.mkdirs();
            }
            while (true) {
                File outputFile;
                block25: {
                    if (!entries.hasMoreElements()) {
                        return outputFiles;
                    }
                    ZipEntry entry = entries.nextElement();
                    outputFile = new File(destinationFile, entry.getName());
                    if (entry.isDirectory() && !outputFile.exists()) {
                        outputFile.mkdirs();
                        continue;
                    }
                    if (!outputFile.getParentFile().exists()) {
                        outputFile.getParentFile().mkdirs();
                    }
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try {
                        BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
                        try {
                            try (BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                                ZipFileUtil.copyStream(inputStream, outStream);
                            }
                            if (inputStream == null) break block25;
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            if (inputStream == null) throw throwable2;
                            ((InputStream)inputStream).close();
                            throw throwable2;
                        }
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable4) {
                        if (throwable2 == null) {
                            throwable2 = throwable4;
                            throw throwable2;
                        }
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                        throw throwable2;
                    }
                }
                outputFiles.add(outputFile);
                if (monitor == null) continue;
                monitor.worked(1);
            }
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int readCount;
        Assert.isNotNull((Object)in);
        Assert.isNotNull((Object)out);
        byte[] buffer = new byte[4096];
        while ((readCount = in.read(buffer)) != -1) {
            out.write(buffer, 0, readCount);
        }
        out.flush();
    }

    public static void createZipFile(File zipFile, List<File> files) throws FileNotFoundException, IOException {
        ZipFileUtil.createZipFile(zipFile, files, null, null);
    }

    public static void createZipFile(File zipFile, List<File> files, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        ZipFileUtil.createZipFile(zipFile, files, null, monitor);
    }

    public static void createZipFile(File zipFile, List<File> files, String rootPath, IProgressMonitor monitor) throws FileNotFoundException, IOException {
        if (rootPath == null) {
            rootPath = "";
        } else if (!((String)rootPath).endsWith("\\") || !((String)rootPath).endsWith("/")) {
            rootPath = (String)rootPath + "/";
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(zipFile)));){
            for (File file : files) {
                try {
                    ZipFileUtil.addZipEntry(zipOut, (String)rootPath, file);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.commons.core", "Could not add " + file.getName() + " to zip", (Throwable)e));
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addZipEntry(ZipOutputStream zipOut, String rootPath, File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File child = fileArray[n2];
                    ZipFileUtil.addZipEntry(zipOut, rootPath, child);
                    ++n2;
                }
            } else {
                String path = "";
                if (!rootPath.equals("")) {
                    rootPath = rootPath.replaceAll("\\\\", "/");
                    path = file.getAbsolutePath().replaceAll("\\\\", "/");
                    path = path.substring(rootPath.length());
                } else {
                    path = file.getName();
                }
                zipOut.putNextEntry(new ZipEntry(path));
                try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
                    ZipFileUtil.copyStream(in, zipOut);
                }
                zipOut.closeEntry();
            }
        }
    }
}

