/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.ui.factories;

import com.google.gerrit.common.data.PatchSetDetail;
import com.google.gerrit.reviewdb.PatchSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.gerrit.core.client.PatchSetContent;
import org.eclipse.mylyn.internal.gerrit.core.remote.PatchSetContentCompareRemoteFactory;
import org.eclipse.mylyn.internal.gerrit.ui.GerritCompareUi;
import org.eclipse.mylyn.internal.gerrit.ui.GerritReviewBehavior;
import org.eclipse.mylyn.internal.gerrit.ui.factories.AbstractPatchSetUiFactory;
import org.eclipse.mylyn.internal.gerrit.ui.factories.Messages;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.reviews.core.model.IReviewsFactory;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfConsumer;
import org.eclipse.mylyn.reviews.core.spi.remote.emf.RemoteEmfObserver;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.mylyn.reviews.ui.spi.factories.IUiContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.statushandlers.StatusManager;

public class CompareWithUiFactory
extends AbstractPatchSetUiFactory {
    private IReviewItemSet baseSet;
    private IReviewItemSet targetSet;
    private IReviewItemSet compareSet;

    public CompareWithUiFactory(IUiContext context, IReviewItemSet set) {
        super(Messages.CompareWithUiFactory_Compare_With, context, set);
    }

    public Control createControl(IUiContext context, Composite parent, FormToolkit toolkit) {
        if (this.isExecutable()) {
            final Composite compareComposite = toolkit.createComposite(parent);
            GridLayoutFactory.fillDefaults().numColumns(2).spacing(0, 0).applyTo(compareComposite);
            Button compareButton = toolkit.createButton(compareComposite, Messages.CompareWithUiFactory_Compare_With_Base, 8);
            compareButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CompareWithUiFactory.this.baseSet = null;
                    CompareWithUiFactory.this.targetSet = (IReviewItemSet)CompareWithUiFactory.this.getModelObject();
                    CompareWithUiFactory.this.execute();
                }
            });
            if (((IReviewItemSet)this.getModelObject()).getReview().getSets().size() > 1) {
                Button compareWithButton = toolkit.createButton(compareComposite, "", 8);
                GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)compareWithButton);
                compareWithButton.setImage(WorkbenchImages.getImage((String)"IMG_LCL_BUTTON_MENU"));
                compareWithButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.showCompareMenu(compareComposite);
                    }

                    private void showCompareMenu(Composite compareComposite2) {
                        Menu menu = new Menu((Control)compareComposite2);
                        Point p = compareComposite2.getLocation();
                        p.y += compareComposite2.getSize().y;
                        p = compareComposite2.getParent().toDisplay(p);
                        for (final IReviewItemSet otherSet : ((IReviewItemSet)CompareWithUiFactory.this.getModelObject()).getReview().getSets()) {
                            if (otherSet == CompareWithUiFactory.this.getModelObject()) continue;
                            MenuItem item = new MenuItem(menu, 0);
                            item.setText(NLS.bind((String)Messages.CompareWithUiFactory_Compare_with_X, (Object)otherSet.getName()));
                            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                public void widgetSelected(SelectionEvent e) {
                                    (this).CompareWithUiFactory.this.baseSet = otherSet;
                                    (this).CompareWithUiFactory.this.targetSet = (IReviewItemSet)CompareWithUiFactory.this.getModelObject();
                                    CompareWithUiFactory.this.execute();
                                }
                            });
                        }
                        menu.setLocation(p);
                        menu.setVisible(true);
                    }
                });
            }
            return compareComposite;
        }
        return null;
    }

    public void execute() {
        PatchSetDetail targetSetDetail;
        PatchSet basePatch = null;
        if (this.baseSet != null) {
            PatchSetDetail baseSetDetail = this.getPatchSetDetail(this.baseSet);
            if (baseSetDetail == null) {
                this.handleExecutionStateError();
                return;
            }
            basePatch = baseSetDetail.getPatchSet();
        }
        if ((targetSetDetail = this.getPatchSetDetail(this.targetSet)) == null) {
            this.handleExecutionStateError();
            return;
        }
        PatchSetContent content = new PatchSetContent(basePatch, targetSetDetail.getPatchSet());
        this.compareSet = IReviewsFactory.INSTANCE.createReviewItemSet();
        String basePatchSetLabel = content.getBase() != null ? Integer.toString(content.getBase().getPatchSetId()) : Messages.CompareWithUiFactory_Base;
        this.compareSet.setName(NLS.bind((String)Messages.CompareWithUiFactory_Compare_Patch_Set_X_with_Y, (Object)content.getTarget().getPatchSetId(), (Object)basePatchSetLabel));
        PatchSetContentCompareRemoteFactory remoteFactory = new PatchSetContentCompareRemoteFactory(this.getGerritFactoryProvider());
        RemoteEmfConsumer consumer = remoteFactory.getConsumerForRemoteObject((EObject)this.compareSet, (Object)content);
        consumer.setUiJob(true);
        consumer.addObserver((RemoteEmfObserver)new ItemListClient(this.baseSet, this.targetSet, this.compareSet));
        int delimiterIndex = ((String)consumer.getLocalKey()).indexOf(44);
        String taskId = ((String)consumer.getLocalKey()).substring(0, delimiterIndex);
        ReviewItemSetCompareEditorInput input = this.createCompareEditorInput(this.compareSet);
        CompareEditorInput newInput = GerritCompareUi.getReviewItemSetComparisonEditor(input, this.compareSet, taskId);
        if (newInput == input) {
            consumer.retrieve(true);
        } else {
            GerritCompareUi.openCompareEditor(newInput);
        }
    }

    @Override
    protected boolean isExecutableStateKnown() {
        return true;
    }

    public boolean isExecutable() {
        return true;
    }

    private ReviewItemSetCompareEditorInput createCompareEditorInput(IReviewItemSet compareSet) {
        CompareConfiguration configuration = new CompareConfiguration();
        GerritReviewBehavior behavior = new GerritReviewBehavior(this.getTask(), this.resolveGitRepository());
        return new ReviewItemSetCompareEditorInput(configuration, compareSet, null, (ReviewBehavior)behavior);
    }

    private final class ItemListClient
    extends RemoteEmfObserver<IReviewItemSet, List<IFileItem>, String, Long> {
        private final IReviewItemSet baseSet;
        private final IReviewItemSet targetSet;
        private final IReviewItemSet compareSet;

        public ItemListClient(IReviewItemSet baseSet, IReviewItemSet targetSet, IReviewItemSet compareSet) {
            this.baseSet = baseSet;
            this.targetSet = targetSet;
            this.compareSet = compareSet;
        }

        public void updated(boolean modified) {
            IStatus status = this.getConsumer().getStatus();
            if (status.isOK()) {
                HashSet<String> fileNames = new HashSet<String>();
                this.addItems(this.baseSet, fileNames);
                this.addItems(this.targetSet, fileNames);
                if (!fileNames.isEmpty()) {
                    Iterator iter = this.compareSet.getItems().iterator();
                    while (iter.hasNext()) {
                        IFileItem file = (IFileItem)iter.next();
                        if (fileNames.contains(file.getName())) continue;
                        iter.remove();
                    }
                }
                GerritCompareUi.openCompareEditor((CompareEditorInput)CompareWithUiFactory.this.createCompareEditorInput(this.compareSet));
                this.dispose();
            } else {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.mylyn.gerrit.ui", "Couldn't load content for compare editor", status.getException()), 3);
            }
        }

        private void addItems(IReviewItemSet itemSet, Set<String> fileNames) {
            if (itemSet != null) {
                itemSet.getItems().stream().map(f -> f.getName()).forEachOrdered(fileNames::add);
            }
        }
    }
}

