/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.tasks;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.internal.java.tasks.Messages;
import org.eclipse.mylyn.tasks.ui.IHighlightingHyperlink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaStackTraceFileHyperlink
implements IHyperlink,
IHighlightingHyperlink {
    private static final String ID_PLUGIN = "org.eclipse.mylyn.java.tasks";
    protected static boolean reflectionErrorLogged;
    private final IRegion region;
    private final String traceLine;
    private final IRegion highlightingRegion;

    public JavaStackTraceFileHyperlink(IRegion region, String traceLine, IRegion highlightingRegion) {
        this.region = region;
        this.traceLine = traceLine;
        this.highlightingRegion = highlightingRegion;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        try {
            String typeName = this.getTypeName();
            int lineNumber = this.getLineNumber();
            if (lineNumber > 0) {
                --lineNumber;
            }
            this.startSourceSearch(typeName, lineNumber);
        }
        catch (CoreException e1) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.JavaStackTraceFileHyperlink_Open_Type, (String)Messages.JavaStackTraceFileHyperlink_Failed_to_open_type);
            return;
        }
    }

    protected void startSourceSearch(final String typeName, final int lineNumber) {
        Job search = new Job(Messages.JavaStackTraceFileHyperlink_Searching_){

            protected IStatus run(IProgressMonitor monitor) {
                block7: {
                    try {
                        Object result;
                        try {
                            try {
                                Method findTypeInWorspace = OpenTypeAction.class.getDeclaredMethod("findTypeInWorkspace", String.class);
                                result = findTypeInWorspace.invoke(null, typeName);
                            }
                            catch (NoSuchMethodException e) {
                                Method findTypeInWorspace = OpenTypeAction.class.getDeclaredMethod("findTypeInWorkspace", String.class, Boolean.TYPE);
                                result = findTypeInWorspace.invoke(null, typeName, false);
                            }
                        }
                        catch (InvocationTargetException e) {
                            if (e.getCause() instanceof CoreException) {
                                JavaStackTraceFileHyperlink.this.searchCompleted(null, typeName, lineNumber, ((CoreException)e.getCause()).getStatus());
                            }
                            throw e;
                        }
                        JavaStackTraceFileHyperlink.this.searchCompleted(result, typeName, lineNumber, null);
                    }
                    catch (Exception e) {
                        if (reflectionErrorLogged) break block7;
                        reflectionErrorLogged = true;
                        StatusManager.getManager().handle((IStatus)new Status(4, JavaStackTraceFileHyperlink.ID_PLUGIN, "Unexpected error searching for Java type", (Throwable)e), 1);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        search.schedule();
    }

    protected void searchCompleted(final Object source, final String typeName, final int lineNumber, IStatus status) {
        UIJob job = new UIJob(Messages.JavaStackTraceFileHyperlink_link_search_complete){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (source == null) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.JavaStackTraceFileHyperlink_Open_Type, (String)Messages.JavaStackTraceFileHyperlink_Type_could_not_be_located);
                } else {
                    JavaStackTraceFileHyperlink.this.processSearchResult(source, typeName, lineNumber);
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    protected void processSearchResult(Object source, String typeName, int lineNumber) {
        block5: {
            String editorId;
            IDebugModelPresentation presentation = JDIDebugUIPlugin.getDefault().getModelPresentation();
            IEditorInput editorInput = presentation.getEditorInput(source);
            if (editorInput != null && (editorId = presentation.getEditorId(editorInput, source)) != null) {
                try {
                    IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor(editorInput, editorId);
                    if (!(editorPart instanceof ITextEditor) || lineNumber < 0) break block5;
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    provider.connect((Object)editorInput);
                    IDocument document = provider.getDocument((Object)editorInput);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException e) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.JavaStackTraceFileHyperlink_Open_Type, (String)Messages.JavaStackTraceFileHyperlink_Line_not_found_in_type);
                    }
                    provider.disconnect((Object)editorInput);
                }
                catch (CoreException e) {
                    MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.JavaStackTraceFileHyperlink_Open_Type, (String)Messages.JavaStackTraceFileHyperlink_Failed_to_open_type);
                }
            }
        }
    }

    private String getTypeName() {
        int start = this.traceLine.indexOf(40);
        int end = this.traceLine.indexOf(58);
        if (start >= 0 && end > start) {
            Object typeName = this.traceLine.substring(start + 1, end);
            typeName = ((String)typeName).substring(0, ((String)typeName).indexOf("."));
            String qualifier = this.traceLine.substring(0, start);
            if ((start = qualifier.lastIndexOf(46)) >= 0 && (start = qualifier.subSequence(0, start).toString().lastIndexOf(46)) == -1) {
                start = 0;
            }
            if (start >= 0) {
                qualifier = qualifier.substring(0, start);
            }
            if (qualifier.length() > 0) {
                typeName = qualifier + "." + (String)typeName;
            }
            return ((String)typeName).trim();
        }
        return "error";
    }

    private int getLineNumber() throws CoreException {
        int index = this.traceLine.lastIndexOf(58);
        if (index >= 0) {
            String numText = this.traceLine.substring(index + 1);
            if ((index = numText.indexOf(41)) >= 0) {
                numText = numText.substring(0, index);
            }
            try {
                return Integer.parseInt(numText);
            }
            catch (NumberFormatException e) {
                throw new CoreException(null);
            }
        }
        throw new CoreException(null);
    }

    public IRegion getHighlightingRegion() {
        return this.highlightingRegion != null ? this.highlightingRegion : this.region;
    }
}

