/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeChecker;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.BasicEnvironment;
import org.eclipse.ocl.options.ParsingOptions;
import org.eclipse.ocl.types.AnyType;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.util.OCLStandardLibraryUtil;
import org.eclipse.ocl.util.OCLUtil;
import org.eclipse.ocl.util.ObjectUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeChecker<C, O, P, PM>
implements TypeChecker<C, O, P> {
    private static final Set<String> RELATIONAL_OPERATORS = new HashSet<String>();
    private final Environment<?, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> env;
    private final UMLReflection<?, C, O, P, ?, PM, ?, ?, ?, ?> uml;
    private final OCLFactory oclFactory;
    private final OCLStandardLibrary<C> stdlib;
    private final C implicitRootClass;

    static {
        RELATIONAL_OPERATORS.add("<");
        RELATIONAL_OPERATORS.add("<=");
        RELATIONAL_OPERATORS.add(">");
        RELATIONAL_OPERATORS.add(">=");
    }

    public AbstractTypeChecker(Environment<?, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> env) {
        this.env = env;
        this.uml = env.getUMLReflection();
        this.oclFactory = env.getOCLFactory();
        this.stdlib = env.getOCLStandardLibrary();
        C optionValue = ParsingOptions.getValue(env, ParsingOptions.implicitRootClass(env));
        this.implicitRootClass = optionValue != null && !this.uml.isClass(optionValue) ? null : optionValue;
    }

    protected Environment<?, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> getEnvironment() {
        return this.env;
    }

    protected UMLReflection<?, C, O, P, ?, PM, ?, ?, ?, ?> getUMLReflection() {
        return this.uml;
    }

    protected OCLFactory getOCLFactory() {
        return this.oclFactory;
    }

    @Override
    public int getRelationship(C type1, C type2) {
        if (type1 != null) {
            type1 = this.uml.getOCLType(type1);
        }
        if (type2 != null) {
            type2 = this.uml.getOCLType(type2);
        }
        if (type1 == type2) {
            return 1;
        }
        if (type1 == this.stdlib.getOclVoid() && type2 != this.stdlib.getOclInvalid()) {
            return 2;
        }
        if (type2 == this.stdlib.getOclVoid() && type1 != this.stdlib.getOclInvalid()) {
            return 4;
        }
        if (type1 == this.stdlib.getOclInvalid()) {
            return 2;
        }
        if (type2 == this.stdlib.getOclInvalid()) {
            return 4;
        }
        if (type1 instanceof AnyType) {
            return type2 instanceof AnyType ? 1 : (type2 instanceof CollectionType ? 8 : 4);
        }
        if (type2 instanceof AnyType) {
            return type1 instanceof CollectionType ? 8 : 2;
        }
        if (type1 instanceof PrimitiveType) {
            int type2Order;
            int type1Order;
            int n = type1 == this.stdlib.getUnlimitedNatural() ? 0 : (type1 == this.stdlib.getInteger() ? 1 : (type1Order = type1 == this.stdlib.getReal() ? 2 : -1));
            int n2 = type2 == this.stdlib.getUnlimitedNatural() ? 0 : (type2 == this.stdlib.getInteger() ? 1 : (type2Order = type2 == this.stdlib.getReal() ? 2 : -1));
            if (type1Order >= 0 && type2Order >= 0) {
                if (type1Order < type2Order) {
                    return 2;
                }
                if (type1Order > type2Order) {
                    return 4;
                }
            }
            return 8;
        }
        if (type2 instanceof PrimitiveType) {
            return 8;
        }
        if (type1 instanceof CollectionType) {
            if (!(type2 instanceof CollectionType)) {
                return 8;
            }
            CollectionType first = (CollectionType)type1;
            CollectionType other = (CollectionType)type2;
            int kindRelationship = this.getRelationship(first.getKind(), other.getKind());
            if (kindRelationship == 8) {
                return kindRelationship;
            }
            int elementRelationship = this.getRelationship(first.getElementType(), other.getElementType());
            switch (kindRelationship) {
                case 1: {
                    return elementRelationship;
                }
                case 2: {
                    switch (elementRelationship) {
                        case 1: 
                        case 2: {
                            return 2;
                        }
                    }
                    return 8;
                }
                case 4: {
                    switch (elementRelationship) {
                        case 1: 
                        case 4: {
                            return 4;
                        }
                    }
                    return 8;
                }
            }
            return 8;
        }
        if (type1 instanceof MessageType && type2 == this.stdlib.getOclMessage()) {
            return 2;
        }
        if (type2 instanceof MessageType && type1 == this.stdlib.getOclMessage()) {
            return 4;
        }
        if (type1 instanceof TypeType && type2 == this.stdlib.getOclType()) {
            return 2;
        }
        if (type2 instanceof TypeType && type1 == this.stdlib.getOclType()) {
            return 4;
        }
        if (type1 instanceof TupleType || type2 instanceof TupleType) {
            if (!(type1 instanceof TupleType) || !(type2 instanceof TupleType)) {
                return 8;
            }
            List<P> props1 = this.uml.getAttributes(type1);
            List<P> props2 = this.uml.getAttributes(type2);
            if (props1.size() != props2.size()) {
                return 8;
            }
            int result = 1;
            for (P prop1 : props1) {
                boolean found = false;
                for (P prop2 : props2) {
                    if (!this.uml.getName(prop1).equals(this.uml.getName(prop2))) continue;
                    int propResult = this.getRelationship(this.resolve(this.uml.getOCLType(prop1)), this.resolve(this.uml.getOCLType(prop2)));
                    if (result == 1) {
                        result = propResult;
                    } else if (result != propResult) {
                        return 8;
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                return 8;
            }
            return result;
        }
        if (type1 instanceof PredefinedType || type2 instanceof PredefinedType) {
            return 8;
        }
        int result = this.uml.getRelationship(type1, type2);
        if (result == 8 && this.implicitRootClass != null && this.uml.isClass(type1) && this.uml.isClass(type2)) {
            if (type1 == this.implicitRootClass) {
                result = 4;
            } else if (type2 == this.implicitRootClass) {
                result = 2;
            }
        }
        return result;
    }

    @Override
    protected int getRelationship(CollectionKind kind1, CollectionKind kind2) {
        switch (kind1) {
            case BAG_LITERAL: {
                switch (kind2) {
                    case BAG_LITERAL: {
                        return 1;
                    }
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
            case SET_LITERAL: {
                switch (kind2) {
                    case SET_LITERAL: {
                        return 1;
                    }
                    case ORDERED_SET_LITERAL: {
                        return 4;
                    }
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
            case ORDERED_SET_LITERAL: {
                switch (kind2) {
                    case ORDERED_SET_LITERAL: {
                        return 1;
                    }
                    case SET_LITERAL: 
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
            case SEQUENCE_LITERAL: {
                switch (kind2) {
                    case SEQUENCE_LITERAL: {
                        return 1;
                    }
                    case COLLECTION_LITERAL: {
                        return 2;
                    }
                }
                return 8;
            }
        }
        switch (kind2) {
            case COLLECTION_LITERAL: {
                return 1;
            }
        }
        return 4;
    }

    @Override
    public C getResultType(Object problemObject, C owner, O operation, List<? extends TypedElement<C>> args) {
        int opcode;
        C actualOwner = this.uml.getOwningClassifier(operation);
        if (this.isStandardLibraryFeature(actualOwner, operation) && (opcode = OCLStandardLibraryUtil.getOperationCode(this.uml.getName(operation))) > 0) {
            C result = OCLStandardLibraryUtil.getResultTypeOf(problemObject, this.env, owner, opcode, args);
            if (result == null && owner != actualOwner) {
                result = OCLStandardLibraryUtil.getResultTypeOf(problemObject, this.env, actualOwner, opcode, args);
            }
            return result;
        }
        return this.resolve(this.uml.getOCLType(operation));
    }

    @Override
    public C getPropertyType(C owner, P property) {
        C result = this.resolve(this.uml.getOCLType(property));
        if (this.uml.isAssociationClass(owner) && this.uml.getMemberEnds(owner).contains(property) && result instanceof CollectionType) {
            result = ((CollectionType)result).getElementType();
        }
        return result;
    }

    @Override
    public C commonSuperType(Object problemObject, C type1, C type2) {
        if (type1 != null) {
            type1 = this.uml.asOCLType(type1);
        }
        if (type2 != null) {
            type2 = this.uml.asOCLType(type2);
        }
        if (ObjectUtil.equal(type1, type2)) {
            return type2;
        }
        if (type1 == this.stdlib.getT()) {
            return type2;
        }
        if (type2 == this.stdlib.getT()) {
            return type1;
        }
        if (type1 == this.stdlib.getOclVoid() || type1 == this.stdlib.getOclInvalid()) {
            return type2;
        }
        if (type2 == this.stdlib.getOclVoid() || type2 == this.stdlib.getOclInvalid()) {
            return type1;
        }
        if (type1 == this.stdlib.getOclAny() && !(type2 instanceof CollectionType)) {
            return type1;
        }
        if (type2 == this.stdlib.getOclAny() && !(type1 instanceof CollectionType)) {
            return type2;
        }
        if ((type1 == this.stdlib.getInteger() || type1 == this.stdlib.getUnlimitedNatural()) && type2 == this.stdlib.getReal()) {
            return type2;
        }
        if ((type2 == this.stdlib.getInteger() || type2 == this.stdlib.getUnlimitedNatural()) && type1 == this.stdlib.getReal()) {
            return type1;
        }
        if (type1 instanceof CollectionType && type2 instanceof CollectionType) {
            CollectionType ct1 = (CollectionType)type1;
            CollectionType ct2 = (CollectionType)type2;
            CollectionKind commonKind = this.commonSuperType(ct1.getKind(), ct2.getKind());
            Object resultElementType = this.commonSuperType(problemObject, ct1.getElementType(), ct2.getElementType());
            return (C)this.resolveCollectionType(commonKind, resultElementType);
        }
        if (type1 instanceof MessageType && type2 instanceof MessageType) {
            return this.stdlib.getOclMessage();
        }
        if (type1 instanceof TypeType && type2 instanceof TypeType) {
            return this.stdlib.getOclType();
        }
        if (type1 instanceof TupleType || type2 instanceof TupleType) {
            if (!(type1 instanceof TupleType) || !(type2 instanceof TupleType)) {
                String message = OCLMessages.bind(OCLMessages.TupleTypeMismatch_ERROR_, this.getName(type1), this.getName(type2));
                this.error(message, "commonSuperType", problemObject);
                return null;
            }
            List<P> props1 = this.uml.getAttributes(type1);
            List<P> props2 = this.uml.getAttributes(type2);
            if (props1.size() != props2.size()) {
                String message = OCLMessages.bind(OCLMessages.TupleFieldNumMismatch_ERROR_, this.getName(type1), this.getName(type2));
                this.error(message, "commonSuperType", problemObject);
                return null;
            }
            BasicEList tupleParts = new BasicEList();
            for (P prop1 : props1) {
                boolean found = false;
                for (P prop2 : props2) {
                    if (!this.uml.getName(prop1).equals(this.uml.getName(prop2))) continue;
                    C resultElementType = this.commonSuperType(problemObject, this.resolve(this.uml.getOCLType(prop1)), this.resolve(this.uml.getOCLType(prop2)));
                    found = true;
                    Variable var = this.oclFactory.createVariable();
                    this.uml.setName(var, this.getName(prop1));
                    this.uml.setType(var, resultElementType);
                    tupleParts.add(var);
                    break;
                }
                if (found) continue;
                String message = OCLMessages.bind(OCLMessages.TupleFieldNotFound_ERROR_, new Object[]{this.getName(type1), this.getName(prop1), this.getName(type2)});
                this.error(message, "commonSuperType", problemObject);
                return null;
            }
            return (C)this.resolveTupleType((EList<? extends TypedElement<C>>)tupleParts);
        }
        if (type1 instanceof CollectionType || type2 instanceof CollectionType) {
            String message = OCLMessages.bind(OCLMessages.TypeMismatch_ERROR_, this.getName(type1), this.getName(type2));
            this.error(message, "commonSuperType", problemObject);
            return null;
        }
        C result = this.uml.getCommonSuperType(type1, type2);
        if (result == null && this.implicitRootClass != null && this.uml.isClass(type1) && this.uml.isClass(type2)) {
            result = this.implicitRootClass;
        }
        return result == null ? this.stdlib.getOclAny() : result;
    }

    protected CollectionKind commonSuperType(CollectionKind kind1, CollectionKind kind2) {
        CollectionKind genericCollectionKind = CollectionKind.COLLECTION_LITERAL;
        switch (kind1) {
            case BAG_LITERAL: 
            case SEQUENCE_LITERAL: {
                if (kind2 == kind1) {
                    return kind1;
                }
                return genericCollectionKind;
            }
            case SET_LITERAL: {
                switch (kind2) {
                    case SET_LITERAL: 
                    case ORDERED_SET_LITERAL: {
                        return kind1;
                    }
                }
                return genericCollectionKind;
            }
            case ORDERED_SET_LITERAL: {
                switch (kind2) {
                    case SET_LITERAL: 
                    case ORDERED_SET_LITERAL: {
                        return kind2;
                    }
                }
                return genericCollectionKind;
            }
        }
        return genericCollectionKind;
    }

    @Override
    public boolean checkMutuallyComparable(Object problemObject, C type1, C type2, int opcode) {
        if (!(type1 instanceof PrimitiveType && type2 instanceof PrimitiveType || this.commonSuperType(problemObject, type1, type2) != null)) {
            String message = OCLMessages.bind(OCLMessages.Noncomforming_ERROR_, this.getName(type1), OCLStandardLibraryUtil.getOperationName(opcode));
            this.error(message, "checkMutuallyComparable", problemObject);
            return false;
        }
        return true;
    }

    @Override
    public boolean exactTypeMatch(C type1, C type2) {
        switch (this.getRelationship(type1, type2)) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean compatibleTypeMatch(C type1, C type2) {
        switch (this.getRelationship(type1, type2)) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<O> getOperations(C owner) {
        List<Object> result;
        if (owner instanceof TypeType) {
            TypeType source = (TypeType)owner;
            result = new ArrayList(source.oclOperations());
            for (O o : this.getOperations(source.getReferredType())) {
                if (!this.uml.isStatic(o)) continue;
                result.add(o);
            }
            result = Collections.unmodifiableList(result);
        } else {
            List<O> additionalOperations;
            if (owner instanceof PredefinedType) {
                PredefinedType source = (PredefinedType)owner;
                result = new ArrayList(source.oclOperations());
                if (source instanceof AnyType && !ParsingOptions.getValue(this.env, ParsingOptions.USE_COMPARE_TO_OPERATION).booleanValue()) {
                    Iterator<Object> iter = result.iterator();
                    while (iter.hasNext()) {
                        if (!RELATIONAL_OPERATORS.contains(this.uml.getName(iter.next()))) continue;
                        iter.remove();
                    }
                }
            } else if ((owner = this.uml.asOCLType(owner)) instanceof PredefinedType) {
                PredefinedType pt = (PredefinedType)owner;
                result = new ArrayList(pt.oclOperations());
            } else {
                result = new ArrayList();
                C oclAny = this.stdlib.getOclAny();
                result.addAll(this.uml.getOperations(owner));
                if (this.implicitRootClass != null && this.implicitRootClass != owner) {
                    result.addAll(this.uml.getOperations(this.implicitRootClass));
                }
                result.addAll(this.getOperations(oclAny));
            }
            if ((additionalOperations = this.env.getAdditionalOperations(owner)) != null && !additionalOperations.isEmpty()) {
                result.addAll(additionalOperations);
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    @Override
    public P findAttribute(C owner, String name) {
        List<P> attributes = this.getAttributes(owner);
        ArrayList<P> matches = null;
        for (P attr : attributes) {
            if (!name.equals(this.uml.getName(attr))) continue;
            if (this.uml.getOwningClassifier(attr) == owner) {
                return attr;
            }
            if (matches == null) {
                matches = new ArrayList<P>(3);
            }
            matches.add(attr);
        }
        if (matches != null) {
            if (matches.size() == 1) {
                return (P)matches.get(0);
            }
            if (!matches.isEmpty()) {
                return (P)this.mostSpecificRedefinition(matches);
            }
        }
        return null;
    }

    @Override
    public List<P> getAttributes(C owner) {
        List<Object> result;
        if (owner instanceof TypeType) {
            TypeType source = (TypeType)owner;
            result = new ArrayList();
            for (P p : this.getAttributes(source.getReferredType())) {
                if (!this.uml.isStatic(p)) continue;
                result.add(p);
            }
            result = Collections.unmodifiableList(result);
        } else {
            if (owner instanceof PredefinedType) {
                result = new ArrayList<P>(this.uml.getAttributes(owner));
            } else if ((owner = this.uml.asOCLType(owner)) instanceof PredefinedType) {
                result = new ArrayList<P>(this.uml.getAttributes(owner));
            } else {
                result = new ArrayList();
                C oclAny = this.stdlib.getOclAny();
                result.addAll(this.uml.getAttributes(owner));
                if (this.implicitRootClass != null && this.implicitRootClass != owner) {
                    result.addAll(this.uml.getAttributes(this.implicitRootClass));
                }
                result.addAll(this.getAttributes(oclAny));
            }
            List<P> additionalProperties = this.env.getAdditionalAttributes(owner);
            if (additionalProperties != null && !additionalProperties.isEmpty()) {
                result.addAll(additionalProperties);
            }
            result = Collections.unmodifiableList(result);
        }
        return result;
    }

    @Override
    public O resolveGenericSignature(C owner, O oper) {
        String name = this.uml.getName(oper);
        List<PM> parameters = this.uml.getParameters(oper);
        ArrayList<String> paramNames = new ArrayList<String>(parameters.size());
        ArrayList<C> paramTypes = new ArrayList<C>(parameters.size());
        ArrayList args = new ArrayList(parameters.size());
        for (PM param : parameters) {
            paramNames.add(this.uml.getName(param));
            paramTypes.add(this.resolveGenericType(owner, this.resolve(this.uml.getOCLType(param)), this.stdlib.getT()));
            Object paramType = this.resolve(this.uml.getOCLType(param));
            Variable var = this.oclFactory.createVariable();
            if (paramType instanceof TypeType) {
                TypeType typeType = (TypeType)paramType;
                if (typeType.getReferredType() == null) {
                    var.setType(this.stdlib.getT());
                } else {
                    var.setType(typeType.getReferredType());
                }
            } else {
                CollectionType ct;
                if (paramType instanceof CollectionType && (ct = (CollectionType)paramType).getElementType() == this.stdlib.getT2()) {
                    paramType = this.resolveCollectionType(ct.getKind(), this.stdlib.getT());
                }
                var.setType(paramType);
            }
            args.add(var);
        }
        C resultType = this.getResultType(oper, owner, oper, args);
        return this.uml.createOperation(name, resultType, paramNames, paramTypes);
    }

    protected C resolveGenericType(C owner, C paramType, C argType) {
        Object result = paramType;
        if (result == this.stdlib.getT()) {
            result = owner;
            if (result instanceof CollectionType && (result = ((CollectionType)result).getElementType()) == this.stdlib.getOclVoid()) {
                result = this.stdlib.getT();
            }
        } else if (result instanceof CollectionType) {
            CollectionType collType = (CollectionType)result;
            Object elemType = collType.getElementType();
            if (elemType == this.stdlib.getT()) {
                C ownerMatch = owner;
                if (ownerMatch instanceof CollectionType && (ownerMatch = ((CollectionType)ownerMatch).getElementType()) == this.stdlib.getOclVoid()) {
                    ownerMatch = this.stdlib.getT();
                }
                result = this.resolveCollectionType(collType.getKind(), ownerMatch);
            } else if (elemType == this.stdlib.getT2()) {
                C argMatch = argType;
                if (argMatch instanceof CollectionType && (argMatch = ((CollectionType)argMatch).getElementType()) == this.stdlib.getOclVoid()) {
                    argMatch = this.stdlib.getT();
                }
                result = this.resolveCollectionType(collType.getKind(), argMatch);
            }
        }
        return result;
    }

    @Override
    public boolean matchArgs(C owner, List<?> paramsOrProperties, List<? extends TypedElement<C>> args) {
        int exactitude = this.matchArgsWithExactitude(owner, paramsOrProperties, args);
        return exactitude >= 0;
    }

    protected int matchArgsWithExactitude(C owner, List<?> paramsOrProperties, List<? extends TypedElement<C>> args) {
        int argsize = args == null ? 0 : args.size();
        if (paramsOrProperties.size() != argsize) {
            return -1;
        }
        int exactitude = 0;
        int i = 0;
        for (Object paramOrProperty : paramsOrProperties) {
            TypedElement<C> arg = args.get(i++);
            C argType = arg.getType();
            C popType = this.resolve(this.uml.getOCLType(paramOrProperty));
            if (popType instanceof TypeType) {
                if (arg instanceof TypeExp) continue;
                return -1;
            }
            if ((popType = this.resolveGenericType(owner, popType, argType)) == this.stdlib.getT()) continue;
            int relationship = this.getRelationship(argType, popType);
            if ((relationship & 3) == 0) {
                return -1;
            }
            if (relationship != 1) continue;
            ++exactitude;
        }
        return exactitude;
    }

    @Override
    public C findSignalMatching(C receiver, List<C> signals, String name, List<? extends TypedElement<C>> args) {
        if (args == null) {
            args = Collections.emptyList();
        }
        for (C signal : signals) {
            if (!this.uml.getName(signal).equals(name) || !this.matchArgs(receiver, this.uml.getAttributes(signal), args)) continue;
            return signal;
        }
        return null;
    }

    @Override
    public O findOperationMatching(C owner, String name, List<? extends TypedElement<C>> args) {
        OCLStandardLibrary<C> lib;
        List<O> matches;
        if (args == null) {
            args = Collections.emptyList();
        }
        if ((matches = this.getBestMatchingOperations(owner, name, args)) != null) {
            if (matches.size() == 1) {
                return matches.get(0);
            }
            if (!matches.isEmpty()) {
                return this.mostSpecificRedefinition(matches);
            }
        }
        if (owner == (lib = this.env.getOCLStandardLibrary()).getOclVoid() || owner == lib.getOclInvalid()) {
            return this.findOperationForVoidOrInvalid(owner, name, args);
        }
        if (owner == lib.getUnlimitedNatural()) {
            return this.findOperationMatching(lib.getInteger(), name, args);
        }
        if (owner instanceof SequenceType || owner instanceof SetType || owner instanceof BagType || owner instanceof OrderedSetType) {
            return this.findOperationMatching(lib.getCollection(), name, args);
        }
        return null;
    }

    protected List<O> getBestMatchingOperations(C owner, String name, List<? extends TypedElement<C>> args) {
        List<O> operations = this.getOperations(owner);
        ArrayList<O> matches = null;
        int bestExactitude = 0;
        for (O oper : operations) {
            int exactitude;
            if (!name.equals(this.uml.getName(oper)) || (exactitude = this.matchArgsWithExactitude(owner, this.uml.getParameters(oper), args)) < bestExactitude) continue;
            if (exactitude > bestExactitude) {
                if (matches != null) {
                    matches.clear();
                }
                bestExactitude = exactitude;
            }
            if (matches == null) {
                matches = new ArrayList<O>(3);
            }
            matches.add(oper);
        }
        return matches;
    }

    @Override
    public boolean isStandardLibraryFeature(C owner, Object feature) {
        boolean result = owner instanceof PredefinedType;
        if (result) {
            result = this.uml.isOperation(feature) ? !this.env.getAdditionalOperations(owner).contains(feature) : !this.env.getAdditionalAttributes(owner).contains(feature);
        }
        return result;
    }

    private <F> F mostSpecificRedefinition(List<? extends F> features) {
        LinkedHashMap<C, F> redefinitions = new LinkedHashMap<C, F>();
        for (F next : features) {
            redefinitions.put(this.uml.getOwningClassifier(next), next);
        }
        ArrayList classifiers = new ArrayList(redefinitions.keySet());
        while (true) {
            for (Object next : classifiers) {
                if (classifiers.removeAll(this.uml.getAllSupertypes(next))) continue;
            }
            break;
        }
        if (classifiers.size() > 1 && ParsingOptions.getValue(this.env, ParsingOptions.OVERLOAD_AMBIGUITY_IS_INVALID).booleanValue()) {
            return null;
        }
        return (F)redefinitions.get(classifiers.get(0));
    }

    private O findOperationForVoidOrInvalid(C owner, String name, List<? extends TypedElement<C>> args) {
        C argType;
        O result = null;
        if (args.size() == 1 && (argType = args.get(0).getType()) != owner) {
            result = this.findOperationMatching(argType, name, args);
        }
        return result;
    }

    private void error(String problemMessage, String problemContext, Object problemObject) {
        OCLUtil.getAdapter(this.env, BasicEnvironment.class).utilityError(problemMessage, problemContext, problemObject);
    }

    private String getName(Object element) {
        return element == null ? null : this.uml.getName(element);
    }

    protected abstract TupleType<O, P> resolveTupleType(EList<? extends TypedElement<C>> var1);

    protected abstract CollectionType<C, O> resolveCollectionType(CollectionKind var1, C var2);

    protected abstract C resolve(C var1);
}

