/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.ui.CodeStyleConfiguration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.jdt.ui.text.java.IQuickFixProcessor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.util.Signatures;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.pde.api.tools.ui.internal.refactoring.CreateFileChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.progress.UIJob;

public class ApiQuickFixProcessor
implements IQuickFixProcessor {
    static final String JAVA_ELEMENT_DELIMITERS = TextProcessor.getDefaultDelimiters() + "<>(),?{} ";

    public boolean hasCorrections(ICompilationUnit unit, int problemId) {
        return problemId == 0x1000002;
    }

    public IJavaCompletionProposal[] getCorrections(IInvocationContext context, IProblemLocation[] locations) throws CoreException {
        ArrayList<UnknownAnnotationQuickFix> proposals = new ArrayList<UnknownAnnotationQuickFix>();
        ICompilationUnit unit = context.getCompilationUnit();
        IProject project = unit.getJavaProject().getProject();
        if (!project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature")) {
            return new IJavaCompletionProposal[0];
        }
        IFile build = project.getFile("build.properties");
        if (ApiQuickFixProcessor.needsBuildPropertiesChange(build)) {
            IProblemLocation[] iProblemLocationArray = locations;
            int n = locations.length;
            int n2 = 0;
            while (n2 < n) {
                String[] args;
                IProblemLocation location = iProblemLocationArray[n2];
                if (location.getProblemId() == 0x1000002 && (args = location.getProblemArguments()).length == 1) {
                    String[] stringArray = args;
                    int n3 = args.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String arg = stringArray[n4];
                        String name = ApiPlugin.getJavadocTagManager().getQualifiedNameForAnnotation(arg);
                        if (name != null) {
                            proposals.add(new UnknownAnnotationQuickFix(unit, name));
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return proposals.toArray(new IJavaCompletionProposal[proposals.size()]);
    }

    public static Change createChange(ICompilationUnit unit, String qualifiedname) throws CoreException {
        IProject project = unit.getJavaProject().getProject();
        IFile buildProperties = project.getFile("build.properties");
        boolean isBundle = project.hasNature("org.eclipse.pde.api.tools.apiAnalysisNature");
        if (!isBundle) {
            return new NullChange();
        }
        return new CompositeChange(MarkerMessages.UnknownAnnotationResolution_3, new Change[]{ApiQuickFixProcessor.createBuildPropertiesChange(buildProperties), ApiQuickFixProcessor.createAddImportChange(unit, qualifiedname)});
    }

    public static Change createBuildPropertiesChange(IFile build) throws CoreException {
        String buildPropertiesEntry = "additional.bundles = org.eclipse.pde.api.tools.annotations";
        if (!build.exists()) {
            return new CreateFileChange(build.getFullPath(), buildPropertiesEntry, null);
        }
        TextFileChange change = new TextFileChange(MarkerMessages.UnknownAnnotationResolution_2, build);
        change.setEdit((TextEdit)new MultiTextEdit());
        IPath filepath = build.getFullPath();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        manager.connect(filepath, LocationKind.IFILE, null);
        try {
            ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(filepath, LocationKind.IFILE);
            IDocument document = textFileBuffer.getDocument();
            String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
            IRegion match = new FindReplaceDocumentAdapter(document).find(0, "additional\\.bundles\\s*=\\s*", true, false, false, true);
            if (match != null) {
                StringBuilder buf = new StringBuilder("org.eclipse.pde.api.tools.annotations,\\").append(lineDelim);
                int spaces = match.getOffset() + match.getLength() - document.getLineOffset(document.getLineOfOffset(match.getOffset()));
                while (spaces-- > 0) {
                    buf.append(' ');
                }
                change.addEdit((TextEdit)new InsertEdit(match.getOffset() + match.getLength(), buf.toString()));
            } else {
                String entry = buildPropertiesEntry + lineDelim;
                int len = document.getLength();
                if (len > 0 && document.getLineInformation(document.getNumberOfLines() - 1).getLength() != 0) {
                    entry = lineDelim + entry;
                }
                change.addEdit((TextEdit)new InsertEdit(len, entry));
            }
            TextFileChange textFileChange = change;
            return textFileChange;
        }
        catch (BadLocationException e) {
            ApiUIPlugin.log(e);
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        finally {
            manager.disconnect(filepath, LocationKind.IFILE, null);
        }
    }

    public static boolean needsBuildPropertiesChange(IFile file) {
        if (file.exists()) {
            Properties props = new Properties();
            InputStream stream = null;
            try {
                stream = file.getContents();
                props.load(file.getContents());
                String entry = (String)props.get("additional.bundles");
                if (entry != null && entry.contains("org.eclipse.pde.api.tools.annotations")) {
                    return false;
                }
            }
            catch (IOException | CoreException e) {
                ApiUIPlugin.log(e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        ApiUIPlugin.log(e);
                    }
                }
            }
        }
        return true;
    }

    public static CompilationUnitChange createAddImportChange(ICompilationUnit cu, String fullyQualifiedName) throws CoreException {
        Object[] args = new String[]{TextProcessor.process((String)Signature.getSimpleName((String)fullyQualifiedName), (String)JAVA_ELEMENT_DELIMITERS), TextProcessor.process((String)Signature.getQualifier((String)fullyQualifiedName), (String)JAVA_ELEMENT_DELIMITERS)};
        String label = NLS.bind((String)MarkerMessages.UnknownAnnotationResolution_4, (Object[])args);
        CompilationUnitChange cuChange = new CompilationUnitChange(label, cu);
        ImportRewrite rewrite = CodeStyleConfiguration.createImportRewrite((ICompilationUnit)cu, (boolean)true);
        rewrite.setUseContextToFilterImplicitImports(true);
        rewrite.addImport(fullyQualifiedName);
        cuChange.setEdit(rewrite.rewriteImports(null));
        return cuChange;
    }

    class UnknownAnnotationQuickFix
    implements IJavaCompletionProposal {
        ICompilationUnit fUnit = null;
        String fName = null;

        public UnknownAnnotationQuickFix(ICompilationUnit unit, String qualifiedname) {
            this.fUnit = unit;
            this.fName = qualifiedname;
        }

        public void apply(IDocument document) {
            UIJob job = UIJob.create((String)"Update project to use API Tools annotations", monitor -> {
                Change changes = ApiQuickFixProcessor.createChange(this.fUnit, this.fName);
                changes.perform(monitor);
            });
            job.setPriority(10);
            job.schedule();
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public String getAdditionalProposalInfo() {
            return MarkerMessages.UnknownAnnotationResolution_0;
        }

        public String getDisplayString() {
            return NLS.bind((String)MarkerMessages.UnknownAnnotationResolution_1, (Object[])new Object[]{Signatures.getSimpleTypeName((String)this.fName), Signatures.getPackageName((String)this.fName)});
        }

        public Image getImage() {
            return ApiUIPlugin.getSharedImage("IMG_OBJ_CHANGE_CORRECTION");
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public int getRelevance() {
            return 0;
        }
    }
}

