/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.product;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.product.ISplashHandlerConstants;

public class RemoveSplashHandlerBindingAction
extends Action
implements ISplashHandlerConstants {
    private IPluginModelBase fModel;
    private IProgressMonitor fMonitor;
    private CoreException fException;
    private String fFieldProductID;
    private String fFieldTargetPackage;

    public RemoveSplashHandlerBindingAction() {
        this.reset();
    }

    public void setFieldProductID(String fieldProductID) {
        this.fFieldProductID = fieldProductID;
    }

    public void setFieldTargetPackage(String fieldTargetPackage) {
        this.fFieldTargetPackage = fieldTargetPackage;
    }

    public void reset() {
        this.fModel = null;
        this.fMonitor = null;
        this.fException = null;
        this.fFieldProductID = null;
        this.fFieldTargetPackage = null;
    }

    public void run() {
        try {
            this.updateModel();
        }
        catch (CoreException e) {
            this.fException = e;
        }
    }

    public void hasException() throws CoreException {
        if (this.fException != null) {
            throw this.fException;
        }
    }

    public void setModel(IPluginModelBase model) {
        this.fModel = model;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.fMonitor = monitor;
    }

    private void updateModel() throws CoreException {
        IPluginExtension extension = this.findFirstExtension("org.eclipse.ui.splashHandlers");
        if (extension == null) {
            return;
        }
        this.fMonitor.beginTask(NLS.bind((String)PDEUIMessages.RemoveSplashHandlerBindingAction_msgProgressRemoveProductBindings, (Object)"org.eclipse.ui.splashHandlers"), 1);
        IPluginElement[] productBindingElements = this.findProductBindingElements(extension);
        this.removeMatchingProductBindingElements(extension, productBindingElements);
        this.fMonitor.done();
    }

    private void removeMatchingProductBindingElements(IPluginExtension extension, IPluginElement[] productBindingElements) throws CoreException {
        if (productBindingElements == null || productBindingElements.length == 0) {
            return;
        }
        IPluginElement[] iPluginElementArray = productBindingElements;
        int n = productBindingElements.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginElement element = iPluginElementArray[n2];
            IPluginAttribute productIDAttribute = element.getAttribute("productId");
            if (productIDAttribute == null || !PDETextHelper.isDefined((String)productIDAttribute.getValue())) {
                extension.remove((IPluginObject)element);
            } else {
                IPluginAttribute splashIDAttribute = element.getAttribute("splashId");
                if (splashIDAttribute == null || !PDETextHelper.isDefined((String)splashIDAttribute.getValue())) {
                    extension.remove((IPluginObject)element);
                } else if (productIDAttribute.getValue().equals(this.fFieldProductID) && this.isGeneratedSplashID(splashIDAttribute.getValue())) {
                    extension.remove((IPluginObject)element);
                }
            }
            ++n2;
        }
    }

    private boolean isGeneratedSplashID(String value) {
        String[][] choices;
        String[][] stringArray = choices = ISplashHandlerConstants.F_SPLASH_SCREEN_TYPE_CHOICES;
        int n = choices.length;
        int n2 = 0;
        while (n2 < n) {
            String[] choice = stringArray[n2];
            String splashID = this.fFieldTargetPackage + "." + choice[0];
            if (value.equals(splashID)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private IPluginElement[] findProductBindingElements(IPluginExtension extension) {
        IPluginObject[] pluginObjects;
        ArrayList<void> elements = new ArrayList<void>();
        if (extension.getChildCount() == 0) {
            return null;
        }
        IPluginObject[] iPluginObjectArray = pluginObjects = extension.getChildren();
        int n = pluginObjects.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginObject pluginObject = iPluginObjectArray[n2];
            IPluginObject iPluginObject = pluginObject;
            if (iPluginObject instanceof IPluginElement) {
                void element;
                IPluginElement cfr_ignored_0 = (IPluginElement)iPluginObject;
                IPluginElement cfr_ignored_1 = (IPluginElement)iPluginObject;
                if (element.getName().equals("splashHandlerProductBinding")) {
                    elements.add(element);
                }
            }
            ++n2;
        }
        if (elements.isEmpty()) {
            return null;
        }
        return elements.toArray(new IPluginElement[elements.size()]);
    }

    private IPluginExtension findFirstExtension(String extensionPointID) {
        IPluginExtension[] extensions;
        IPluginExtension[] iPluginExtensionArray = extensions = this.fModel.getPluginBase().getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            String point = extension.getPoint();
            if (extensionPointID.equals(point)) {
                return extension;
            }
            ++n2;
        }
        return null;
    }
}

