/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.core.compiler.ast.nodes.FullyQualifiedReference;
import org.eclipse.php.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class UseStatement
extends Statement {
    public static final int T_NONE = 0;
    public static final int T_FUNCTION = 1;
    public static final int T_CONST = 2;
    private List<UsePart> parts;
    private int statementType;
    private FullyQualifiedReference namespace;

    public UseStatement(int start, int end, List<UsePart> parts) {
        this(start, end, parts, 0);
    }

    public UseStatement(int start, int end, List<UsePart> parts, int statementType) {
        this(start, end, null, parts, statementType);
    }

    public UseStatement(int start, int end, FullyQualifiedReference namespace, List<UsePart> parts) {
        this(start, end, namespace, parts, 0);
    }

    public UseStatement(int start, int end, FullyQualifiedReference namespace, List<UsePart> parts, int statementType) {
        super(start, end);
        assert (parts != null);
        this.setNamespace(namespace);
        this.parts = parts;
        this.statementType = statementType;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            for (UsePart part : this.parts) {
                part.traverse(visitor);
            }
            visitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 70;
    }

    public Collection<UsePart> getParts() {
        return this.parts;
    }

    public void setStatementType(int statementType) {
        this.statementType = statementType;
    }

    public int getStatementType() {
        return this.statementType;
    }

    public void setNamespace(FullyQualifiedReference namespace) {
        this.namespace = namespace;
        if (namespace != null) {
            namespace.removeGlobal();
        }
    }

    public FullyQualifiedReference getNamespace() {
        return this.namespace;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

