/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.proxy.server.core.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.remote.internal.proxy.server.core.commands.AbstractServerExecCommand;
import org.eclipse.remote.proxy.protocol.core.StreamChannel;

public class ServerShellCommand
extends AbstractServerExecCommand {
    public ServerShellCommand(StreamChannel cmdChan, StreamChannel ioChan) {
        super(null, null, null, true, false, cmdChan, ioChan, null);
    }

    @Override
    public Process doRun() throws IOException {
        String shell = this.findLoginShell();
        if (PTY.isSupported((PTY.Mode)PTY.Mode.TERMINAL)) {
            PTY pty = new PTY(PTY.Mode.TERMINAL);
            Process p = ProcessFactory.getFactory().exec(new String[]{shell, "-l"}, null, null, pty);
            return new ShellProcess(p, pty);
        }
        return ProcessFactory.getFactory().exec(new String[]{shell, "-l"}, null, null);
    }

    @Override
    protected void doKill(Process proc) {
        if (proc.isAlive()) {
            proc.destroyForcibly();
        }
    }

    @Override
    protected void doSetTerminalSize(Process proc, int cols, int rows) {
        if (proc.isAlive() && proc instanceof ShellProcess) {
            ShellProcess shell = (ShellProcess)proc;
            shell.setTerminalSize(cols, rows);
        }
    }

    private String findLoginShell() throws IOException {
        String osName = System.getProperty("os.name");
        String userName = System.getProperty("user.name");
        if (osName == null || userName == null) {
            throw new IOException("Unable to obtain information needed to find login shell");
        }
        switch (osName) {
            case "Mac OS X": {
                String[] vals;
                String res = this.executeCommand("dscl . -read /Users/" + userName + " UserShell");
                if (res == null || (vals = res.split(" ")).length != 2) break;
                return vals[1];
            }
            case "Linux": {
                String[] vals;
                String res = this.executeCommand("getent passwd " + userName);
                if (res == null || (vals = res.split(":")).length != 7) break;
                return vals[6];
            }
        }
        throw new IOException("Unable to find login shell for os=" + osName + " user=" + userName);
    }

    private String executeCommand(String command) throws IOException {
        Process p;
        StringBuffer output = new StringBuffer();
        try {
            p = Runtime.getRuntime().exec(command);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        try {
            p.waitFor();
        }
        catch (InterruptedException e) {
            throw new IOException(e.getMessage());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = reader.readLine();
        while (line != null) {
            output.append(line);
            line = reader.readLine();
            if (line == null) continue;
            output.append("\n");
        }
        return output.toString();
    }

    private class ShellProcess
    extends Process {
        private final Process proc;
        private final PTY pty;

        public ShellProcess(Process proc, PTY pty) {
            this.proc = proc;
            this.pty = pty;
        }

        @Override
        public OutputStream getOutputStream() {
            if (this.pty != null) {
                return this.pty.getOutputStream();
            }
            return this.proc.getOutputStream();
        }

        @Override
        public InputStream getInputStream() {
            if (this.pty != null) {
                return this.pty.getInputStream();
            }
            return this.proc.getInputStream();
        }

        @Override
        public InputStream getErrorStream() {
            if (this.pty != null) {
                return this.pty.getInputStream();
            }
            return this.proc.getErrorStream();
        }

        @Override
        public int waitFor() throws InterruptedException {
            return this.proc.waitFor();
        }

        @Override
        public int exitValue() {
            return this.proc.exitValue();
        }

        @Override
        public void destroy() {
            this.proc.destroy();
        }

        public void setTerminalSize(int cols, int rows) {
            if (this.pty != null) {
                this.pty.setTerminalSize(cols, rows);
            }
        }
    }
}

