/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.environment.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.scout.sdk.core.java.ecj.ClasspathEntry;
import org.eclipse.scout.sdk.core.java.ecj.ClasspathWithEcj;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.model.ClasspathEntryWithJdt;
import org.eclipse.scout.sdk.s2e.environment.model.JavaEnvironmentWithJdt;

public class ClasspathWithJdt
extends ClasspathWithEcj {
    private final IPackageFragmentRoot m_cpRoot;
    private final FinalValue<Boolean> m_isSourceFolder;
    private final IJavaProject m_javaProject;

    protected ClasspathWithJdt(ClasspathEntryWithJdt entry, AbstractJavaEnvironment env) {
        super((ClasspathEntry)entry, env);
        this.m_cpRoot = entry.getRoot();
        this.m_isSourceFolder = new FinalValue();
        this.m_javaProject = this.m_cpRoot.getJavaProject();
    }

    public JavaEnvironmentWithJdt getJavaEnvironment() {
        return (JavaEnvironmentWithJdt)super.getJavaEnvironment();
    }

    public boolean isSourceFolder() {
        return (Boolean)this.m_isSourceFolder.computeIfAbsentAndGet(() -> this.getJavaProject().equals(this.getJavaEnvironment().javaProject()) && ClasspathWithJdt.isJavaSourceFolder(this.getRoot()));
    }

    public static boolean isJavaSourceFolder(IPackageFragmentRoot root) {
        try {
            if (root.getKind() != 1 || root.isArchive() || root.isExternal()) {
                return false;
            }
            IResource resource = root.getResource();
            if (resource == null || !resource.exists() || resource.isDerived()) {
                return false;
            }
            return ClasspathWithJdt.isJavaFileIncludedIn(root.getRawClasspathEntry());
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }

    protected static boolean isJavaFileIncludedIn(IClasspathEntry rawClasspathEntry) {
        if (rawClasspathEntry == null) {
            return true;
        }
        IPath[] exclusionPatterns = rawClasspathEntry.getExclusionPatterns();
        if (exclusionPatterns != null && exclusionPatterns.length > 0) {
            char[] javaSample = "Whatever.java".toCharArray();
            for (IPath excludedPath : exclusionPatterns) {
                char[] pattern = excludedPath.toString().toCharArray();
                boolean javaFilesExcluded = CharOperation.pathMatch((char[])pattern, (char[])javaSample, (boolean)true, (char)'/');
                if (!javaFilesExcluded) continue;
                return false;
            }
        }
        return true;
    }

    public IPackageFragmentRoot getRoot() {
        return this.m_cpRoot;
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public String toString() {
        return "ClasspathWithJdt [" + this.getRoot() + ']';
    }
}

