/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.internal.refresh.diagram;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.common.ui.services.editor.EditorService;
import org.eclipse.gmf.runtime.common.ui.util.DisplayUtils;
import org.eclipse.gmf.runtime.diagram.core.util.ViewType;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.util.MeasurementUnitHelper;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.MeasurementUnit;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.sirius.diagram.CollapseFilter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.business.api.diagramtype.ICollapseUpdater;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionQuery;
import org.eclipse.sirius.diagram.ui.business.api.helper.graphicalfilters.CollapseUpdater;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.dialect.SetBestHeightHeaderCommand;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.internal.refresh.AbstractCanonicalSynchronizer;
import org.eclipse.sirius.diagram.ui.internal.refresh.CanonicalSynchronizerResult;
import org.eclipse.sirius.diagram.ui.internal.refresh.diagram.ConnectionsFactory;
import org.eclipse.sirius.diagram.ui.part.SiriusDiagramUpdater;
import org.eclipse.sirius.diagram.ui.part.SiriusLinkDescriptor;
import org.eclipse.sirius.diagram.ui.part.SiriusVisualIDRegistry;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.AnnotationEntry;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class DDiagramCanonicalSynchronizer
extends AbstractCanonicalSynchronizer {
    private Diagram gmfDiagram;
    private ConnectionsFactory connectionsFactory;

    public DDiagramCanonicalSynchronizer(Diagram gmfDiagram) {
        this.gmfDiagram = gmfDiagram;
        this.connectionsFactory = new ConnectionsFactory(gmfDiagram, this.viewpointViewProvider);
        this.loadPreferencesFromOpenedDiagram();
    }

    private void loadPreferencesFromOpenedDiagram() {
        IDiagramGraphicalViewer viewer;
        List diagramEditors = EditorService.getInstance().getRegisteredEditorParts();
        Optional<Object> diagramEditor = diagramEditors.stream().filter(de -> de instanceof DiagramEditor && ((DiagramEditor)de).getDiagramEditPart() != null && this.gmfDiagram.equals(((DiagramEditor)de).getDiagramEditPart().getDiagramView())).findFirst();
        if (diagramEditor.isPresent() && (viewer = ((DiagramEditor)diagramEditor.get()).getDiagramGraphicalViewer()) instanceof DiagramGraphicalViewer) {
            DiagramGraphicalViewer diagramGraphicalViewer = (DiagramGraphicalViewer)viewer;
            IPreferenceStore store = diagramGraphicalViewer.getWorkspaceViewerPreferenceStore();
            this.setSnapToGrid(store.getBoolean("rulergrid.snaptogrid"));
            this.setGridSpacing(this.convertGridSpacingInPixels(store.getDouble("rulergrid.gridspacing"), store.getInt("rulergrid.rulerunit"), MeasurementUnitHelper.getMapMode((MeasurementUnit)this.gmfDiagram.getMeasurementUnit())));
        }
    }

    private int convertGridSpacingInPixels(double gridSpacing, int rulerUnits, IMapMode mapMode) {
        final Display display = DisplayUtils.getDisplay();
        RunnableWithResult.Impl<Point> runnable = new RunnableWithResult.Impl<Point>(){

            public void run() {
                this.setResult(display.getDPI());
            }
        };
        display.syncExec((Runnable)runnable);
        double dotsPerInch = ((Point)runnable.getResult()).x;
        int spacingInPixels = 0;
        switch (rulerUnits) {
            case 0: {
                spacingInPixels = (int)Math.round(dotsPerInch * gridSpacing);
                break;
            }
            case 1: {
                spacingInPixels = (int)Math.round(dotsPerInch * gridSpacing / 2.54);
                break;
            }
            default: {
                spacingInPixels = (int)gridSpacing;
            }
        }
        int spacing = mapMode.DPtoLP(spacingInPixels);
        return spacing;
    }

    public void synchronize() {
        this.refreshSemantic();
    }

    private void refreshSemantic() {
        if (this.gmfDiagram != null && this.gmfDiagram.getElement() != null) {
            CanonicalSynchronizerResult canonicalSynchronizerResult = new CanonicalSynchronizerResult();
            this.refreshSemanticChildren((View)this.gmfDiagram, this.gmfDiagram.getElement(), canonicalSynchronizerResult);
            EList children = this.gmfDiagram.getChildren();
            for (View view : children) {
                this.refreshSemantic(view, canonicalSynchronizerResult);
            }
            canonicalSynchronizerResult.reconciliateOrphanNodes();
            canonicalSynchronizerResult.collectDetachedPGEFromNode();
            canonicalSynchronizerResult.collectAttachedEdgeToNodes();
            canonicalSynchronizerResult.deleteOrphanNodes();
            this.refreshConnections(this.gmfDiagram, canonicalSynchronizerResult);
            canonicalSynchronizerResult.reconciliateOrphanEdges();
            canonicalSynchronizerResult.collectAttachedEdgeToEdges();
            canonicalSynchronizerResult.collectDetachedPGEFromEdge();
            canonicalSynchronizerResult.deleteOrphanEdges();
            canonicalSynchronizerResult.deleteDetachedPGE();
            this.manageCreatedViewsLayout(canonicalSynchronizerResult.getCreatedViews());
            this.manageCollapse(canonicalSynchronizerResult.getCreatedNodes());
            this.manageRegions();
        }
    }

    private void manageRegions() {
        if (this.regionsContainersToLayoutWithImpactStatus.isEmpty()) {
            return;
        }
        ArrayList newArrayList = new ArrayList(this.regionsContainersToLayoutWithImpactStatus.keySet());
        ListIterator regionsContainersToLayoutListIterator = newArrayList.listIterator(newArrayList.size());
        while (regionsContainersToLayoutListIterator.hasPrevious()) {
            View regionsContainer = (View)regionsContainersToLayoutListIterator.previous();
            if (!(regionsContainer instanceof Node)) continue;
            new RegionContainerUpdateLayoutOperation((Node)regionsContainer, (Boolean)this.regionsContainersToLayoutWithImpactStatus.get(regionsContainer)).execute();
        }
        this.regionsContainersToLayoutWithImpactStatus.clear();
    }

    private void manageCreatedViewsLayout(Set<View> createdViews) {
        Set filteredCreatedViewsToLayout = Sets.filter(createdViews, (Predicate)new Predicate<View>(){

            public boolean apply(View input) {
                return input.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getAdapterMarker());
            }
        });
        Set filteredCreatedViewsWithCenterLayout = Sets.filter(createdViews, (Predicate)new Predicate<View>(){

            public boolean apply(View input) {
                return input.eAdapters().contains((Object)SiriusLayoutDataManager.INSTANCE.getCenterAdapterMarker());
            }
        });
        LinkedHashSet createdViewsWithCenterLayout = Sets.newLinkedHashSet((Iterable)filteredCreatedViewsWithCenterLayout);
        LinkedHashSet createdViewsToLayout = Sets.newLinkedHashSet((Iterable)filteredCreatedViewsToLayout);
        this.calculateCenterLayout(createdViewsWithCenterLayout, createdViewsToLayout);
        if (!createdViewsWithCenterLayout.isEmpty() && this.storeViews2Arrange) {
            SiriusLayoutDataManager.INSTANCE.addCreatedViewWithCenterLayout(this.gmfDiagram, Sets.newLinkedHashSet((Iterable)createdViewsWithCenterLayout));
            this.removeAlreadyArrangeMarker(filteredCreatedViewsWithCenterLayout);
        }
        if (!createdViewsToLayout.isEmpty() && this.storeViews2Arrange) {
            SiriusLayoutDataManager.INSTANCE.addCreatedViewsToLayout(this.gmfDiagram, Sets.newLinkedHashSet((Iterable)createdViewsToLayout));
            this.removeAlreadyArrangeMarker(filteredCreatedViewsToLayout);
        }
    }

    private void calculateCenterLayout(Set<View> createdViewsWithSpecialLayout, Set<View> createdViewsToLayout) {
        HashSet<View> toRemove = new HashSet<View>();
        for (View view : createdViewsWithSpecialLayout) {
            if (!this.hasContainer(view, createdViewsWithSpecialLayout)) continue;
            toRemove.add(view);
        }
        createdViewsToLayout.addAll(toRemove);
        createdViewsWithSpecialLayout.removeAll(toRemove);
    }

    private boolean hasContainer(View view, Set<View> createdViewsToLayout) {
        for (View aView : createdViewsToLayout) {
            if (view.equals(aView) || !this.hasContainer(view, aView)) continue;
            return true;
        }
        return false;
    }

    private boolean hasContainer(View view, View aView) {
        View eContainer = view;
        while (eContainer != null && !(eContainer instanceof AnnotationEntry) && !eContainer.equals(aView)) {
            eContainer = eContainer.eContainer();
        }
        return !(eContainer instanceof AnnotationEntry);
    }

    private void removeAlreadyArrangeMarker(Collection<View> createdViews) {
        block0: for (View view : createdViews) {
            Iterator iterator = view.eAdapters().iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!adapter.isAdapterForType((Object)SiriusLayoutDataManager.INSTANCE)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    private CanonicalSynchronizerResult refreshConnections(Diagram diagram, CanonicalSynchronizerResult canonicalSynchronizerResult) {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<SiriusLinkDescriptor> linkDescriptors = this.collectAllLinks((View)diagram, domain2NotationMap);
        LinkedList<Edge> existingLinks = new LinkedList<Edge>((Collection<Edge>)diagram.getEdges());
        existingLinks.removeAll(this.collectAllNoteAttachments(diagram));
        existingLinks.removeAll(this.collectAllLines(diagram));
        existingLinks.removeAll(canonicalSynchronizerResult.getOrphanEdges());
        Iterator linksIterator = existingLinks.iterator();
        while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject nextDiagramLinkEContainer = nextDiagramLink.eContainer();
            if (diagramLinkObject == null) continue;
            EObject diagramLinkEContainer = diagramLinkObject.eContainer();
            if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null || nextDiagramLink.getSource().eContainer() == null || nextDiagramLink.getTarget().eContainer() == null) continue;
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            int diagramLinkVisualID = SiriusVisualIDRegistry.getVisualID((View)nextDiagramLink);
            Iterator<SiriusLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                SiriusLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                boolean exist = nextDiagramLinkEContainer != null && diagramLinkEContainer != null && diagramLinkObject == nextLinkDescriptor.getModelElement();
                boolean bl = exist = exist && diagramLinkSrc == nextLinkDescriptor.getSource() && diagramLinkDst == nextLinkDescriptor.getDestination() && diagramLinkVisualID == nextLinkDescriptor.getVisualID();
                if (exist && diagramLinkSrc instanceof DEdge) {
                    exist = linkDescriptors.stream().noneMatch(input -> input.getModelElement().equals(diagramLinkSrc));
                }
                if (exist && diagramLinkDst instanceof DEdge) {
                    exist = linkDescriptors.stream().noneMatch(input -> input.getModelElement().equals(diagramLinkDst));
                }
                if (!exist) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
            }
        }
        canonicalSynchronizerResult.addOrphanEdges(existingLinks);
        canonicalSynchronizerResult.addCreatedEdges(this.createConnections(linkDescriptors, domain2NotationMap, diagram));
        return canonicalSynchronizerResult;
    }

    private List<Edge> createConnections(Collection<SiriusLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap, Diagram diagram) {
        ArrayList<Edge> createdEdges = new ArrayList<Edge>();
        for (SiriusLinkDescriptor viewDescriptor : linkDescriptors) {
            Edge createdEdge = this.connectionsFactory.createEdge(viewDescriptor, domain2NotationMap);
            if (createdEdge == null) continue;
            createdEdges.add(createdEdge);
        }
        return createdEdges;
    }

    private Collection<SiriusLinkDescriptor> collectAllLinks(View view, Map<EObject, View> domain2NotationMap) {
        if (!"Sirius".equals(SiriusVisualIDRegistry.getModelID(view))) {
            return Collections.emptyList();
        }
        LinkedList<SiriusLinkDescriptor> result = new LinkedList<SiriusLinkDescriptor>();
        result.addAll(SiriusDiagramUpdater.getDDiagram_1000ContainedLinks(view));
        AbstractTreeIterator<View> it = new AbstractTreeIterator<View>(view){

            protected Iterator<? extends View> getChildren(Object object) {
                if (object instanceof View) {
                    View view = (View)object;
                    EList children = view.getChildren();
                    return children.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (it.hasNext()) {
            View child = (View)it.next();
            EObject element = child.getElement();
            if (domain2NotationMap.containsKey(element)) continue;
            domain2NotationMap.put(element, child);
        }
        EList edges = ((Diagram)view).getEdges();
        for (Edge edge : edges) {
            EObject element = edge.getElement();
            if (domain2NotationMap.containsKey(element)) continue;
            domain2NotationMap.put(element, (View)edge);
        }
        return result;
    }

    private Collection<Edge> collectAllNoteAttachments(Diagram diagram) {
        LinkedList<Edge> result = new LinkedList<Edge>();
        for (Edge currentEdge : diagram.getEdges()) {
            if (!ViewType.NOTEATTACHMENT.equals(currentEdge.getType())) continue;
            result.add(currentEdge);
        }
        return result;
    }

    private Collection<Edge> collectAllLines(Diagram diagram) {
        LinkedList<Edge> result = new LinkedList<Edge>();
        for (Edge currentEdge : diagram.getEdges()) {
            if (!"line".equals(currentEdge.getType())) continue;
            result.add(currentEdge);
        }
        return result;
    }

    private void manageCollapse(Set<View> createdNodeViews) {
        if (createdNodeViews.isEmpty() && !(this.gmfDiagram.getElement() instanceof DDiagram)) {
            return;
        }
        DDiagram dDiagram = (DDiagram)this.gmfDiagram.getElement();
        ICollapseUpdater cu = CollapseUpdater.getICollapseUpdater(dDiagram);
        for (Node node : Iterables.filter(createdNodeViews, Node.class)) {
            CollapseFilter filter;
            DDiagramElement dde;
            EObject element = node.getElement();
            if (!(element instanceof DDiagramElement) || !(cu instanceof CollapseUpdater) || !new DDiagramElementQuery(dde = (DDiagramElement)element).isIndirectlyCollapsed() || (filter = (CollapseFilter)Iterables.getFirst((Iterable)Iterables.filter((Iterable)dde.getGraphicalFilters(), (Predicate)Predicates.instanceOf(CollapseFilter.class)), null)) == null || filter.getWidth() != 0 || filter.getHeight() != 0) continue;
            ((CollapseUpdater)cu).storeInFilterAndCollapseBounds(dde, (Option<Node>)Options.newSome((Object)node), false);
        }
    }

    public void postCreation() {
        TransactionalEditingDomain domain;
        if (this.gmfDiagram != null && this.gmfDiagram.getElement() instanceof DDiagram && ((DDiagram)this.gmfDiagram.getElement()).getDescription() != null && new DiagramDescriptionQuery(((DDiagram)this.gmfDiagram.getElement()).getDescription()).isHeaderSectionEnabled() && (domain = TransactionUtil.getEditingDomain((EObject)this.gmfDiagram.getElement())) != null) {
            SetBestHeightHeaderCommand setBestHeightHeaderCommand = new SetBestHeightHeaderCommand(domain, this.gmfDiagram);
            setBestHeightHeaderCommand.execute();
        }
    }
}

