/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility;

import java.util.Optional;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactory;
import org.eclipse.sirius.diagram.tools.api.command.IDiagramCommandFactoryProvider;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.actions.visibility.AbstractRevealElementsAction;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.DiagramOutlinePage;

public class RevealElementsAction
extends AbstractRevealElementsAction<Object> {
    public RevealElementsAction() {
        super(Messages.RevealOutlineElementsAction_label);
    }

    public RevealElementsAction(String text) {
        super(text);
    }

    public static boolean isActive(IDiagramElementEditPart selectedElement) {
        boolean result = true;
        DDiagramElement diagramElement = selectedElement.resolveDiagramElement();
        result = diagramElement == null ? false : !diagramElement.isVisible();
        return result;
    }

    public static boolean isActive(IStructuredSelection selectedElements) {
        for (Object selectedElement : selectedElements) {
            if (!(selectedElement instanceof IDiagramElementEditPart) || !RevealElementsAction.isActive((IDiagramElementEditPart)selectedElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean doRun(Object element) {
        this.run(element);
        return true;
    }

    @Override
    protected Class<Object> getElementType() {
        return Object.class;
    }

    private void run(Object vpe) {
        if (vpe instanceof DDiagramElement && this.selection instanceof DiagramOutlinePage.TreeSelectionWrapper) {
            DiagramOutlinePage.TreeSelectionWrapper wrapper = (DiagramOutlinePage.TreeSelectionWrapper)this.selection;
            RootEditPart root = wrapper.getRoot();
            DDiagramEditor diagramEditor = (DDiagramEditor)wrapper.getViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            this.runRevealCommand(root, diagramEditor, (DDiagramElement)vpe);
        } else if (vpe instanceof IDiagramElementEditPart && RevealElementsAction.isActive((IDiagramElementEditPart)vpe)) {
            Optional<DDiagramElement> optionalDiagramElement = Optional.of((IGraphicalEditPart)vpe).map(IGraphicalEditPart::resolveSemanticElement).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast);
            if (optionalDiagramElement.isPresent()) {
                IDiagramElementEditPart diagramElementEditPart = (IDiagramElementEditPart)vpe;
                SelectionRequest request = new SelectionRequest();
                request.setType((Object)"open");
                diagramElementEditPart.performRequest((Request)request);
            }
        }
    }

    private void runRevealCommand(RootEditPart root, DDiagramEditor editor, DDiagramElement vpe) {
        Object adapter = editor.getAdapter(IDiagramCommandFactoryProvider.class);
        IDiagramCommandFactoryProvider cmdFactoryProvider = (IDiagramCommandFactoryProvider)adapter;
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain((ResourceSet)editor.getEditingDomain().getResourceSet());
        IDiagramCommandFactory emfCommandFactory = cmdFactoryProvider.getCommandFactory(transactionalEditingDomain);
        Command cmd = emfCommandFactory.buildRevealCommand(vpe);
        CompoundCommand allInOne = new CompoundCommand(cmd.getLabel());
        allInOne.append(cmd);
        transactionalEditingDomain.getCommandStack().execute((Command)allInOne);
    }
}

