/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.query;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.model.business.internal.query.DRepresentationInternalQuery;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DRepresentationWithSessionInternalQuery
extends DRepresentationInternalQuery {
    private Session session;

    public DRepresentationWithSessionInternalQuery(DRepresentation representation) {
        super(representation);
    }

    public DRepresentationWithSessionInternalQuery(DRepresentation representation, Session session) {
        this(representation);
        this.session = session;
    }

    public boolean isDanglingRepresentation() {
        if (this.representation instanceof DSemanticDecorator) {
            DSemanticDecorator semDecRep = (DSemanticDecorator)this.representation;
            if (this.session == null) {
                this.session = SessionManager.INSTANCE.getSession(semDecRep.getTarget());
            }
            return semDecRep.getTarget() == null || this.session == null;
        }
        return false;
    }

    public boolean isAutoRefresh() {
        if (this.session == null) {
            this.session = Session.of((EObject)this.representation).orElse(null);
        }
        if (this.session != null) {
            return this.session.getSiriusPreferences().isAutoRefresh();
        }
        return false;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }
}

