/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWT;

public final class Compatibility {
    private static ResourceBundle msgs = null;

    public static int ceil(int p, int q) {
        return (int)Math.ceil((float)p / (float)q);
    }

    public static int round(int p, int q) {
        return Math.round((float)p / (float)q);
    }

    public static int pow2(int n) {
        if (n >= 1 && n <= 30) {
            return 2 << n - 1;
        }
        if (n != 0) {
            SWT.error(6);
        }
        return 1;
    }

    public static void exec(String[] prog, String[] envp, String workingDir) throws IOException {
        Runtime.getRuntime().exec(prog, null, workingDir != null ? new File(workingDir) : null);
    }

    public static String getMessage(String key) {
        Object answer = key;
        if (key == null) {
            SWT.error(4);
        }
        if (msgs == null) {
            try {
                msgs = ResourceBundle.getBundle("org.eclipse.swt.internal.SWTMessages");
            }
            catch (MissingResourceException missingResourceException) {
                answer = key + " (no resource bundle)";
            }
        }
        if (msgs != null) {
            try {
                answer = msgs.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return answer;
    }

    public static String getMessage(String key, Object[] args) {
        Object answer = key;
        if (key == null || args == null) {
            SWT.error(4);
        }
        if (msgs == null) {
            try {
                msgs = ResourceBundle.getBundle("org.eclipse.swt.internal.SWTMessages");
            }
            catch (MissingResourceException missingResourceException) {
                answer = key + " (no resource bundle)";
            }
        }
        if (msgs != null) {
            try {
                MessageFormat formatter = new MessageFormat("");
                formatter.applyPattern(msgs.getString(key));
                answer = formatter.format(args);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return answer;
    }
}

