/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.extensions.ExtensionPointComparator;
import org.eclipse.tcf.te.runtime.nls.Messages;
import org.osgi.framework.Bundle;

public abstract class AbstractExtensionPointManager<V> {
    private boolean initialized = false;
    private Map<String, ExecutableExtensionProxy<V>> extensionsMap = new LinkedHashMap<String, ExecutableExtensionProxy<V>>();
    private ExtensionPointComparator comparator = null;

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ExecutableExtensionProxy<V>> getExtensions() {
        Map<String, ExecutableExtensionProxy<V>> map = this.extensionsMap;
        synchronized (map) {
            if (!this.isInitialized()) {
                this.loadExtensions();
                this.setInitialized(true);
            }
        }
        return this.extensionsMap;
    }

    protected IExtension[] getExtensionsSorted(IExtensionPoint point) {
        Assert.isNotNull((Object)point);
        ArrayList<IExtension> extensions = new ArrayList<IExtension>(Arrays.asList(point.getExtensions()));
        if (extensions.size() > 0) {
            Collections.sort(extensions, this.getExtensionPointComparator());
        }
        return extensions.toArray(new IExtension[extensions.size()]);
    }

    protected final ExtensionPointComparator getExtensionPointComparator() {
        if (this.comparator == null) {
            this.comparator = this.doCreateExtensionPointComparator();
        }
        return this.comparator;
    }

    protected ExtensionPointComparator doCreateExtensionPointComparator() {
        return new ExtensionPointComparator();
    }

    protected abstract String getExtensionPointId();

    protected abstract String getConfigurationElementName();

    protected ExecutableExtensionProxy<V> doCreateExtensionProxy(IConfigurationElement element) throws CoreException {
        Assert.isNotNull((Object)element);
        return new ExecutableExtensionProxy(element);
    }

    protected void doStoreExtensionTo(Map<String, ExecutableExtensionProxy<V>> extensions, ExecutableExtensionProxy<V> candidate, IConfigurationElement element) throws CoreException {
        Assert.isNotNull(extensions);
        Assert.isNotNull(candidate);
        Assert.isNotNull((Object)element);
        if (extensions.containsKey(candidate.getId())) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_duplicateExtension, (Object)candidate.getId(), (Object)element.getContributor().getName()), null));
        }
        extensions.put(candidate.getId(), candidate);
    }

    protected void loadExtensions() {
        if (this.isInitialized()) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(this.getExtensionPointId());
        if (point != null) {
            IExtension[] extensions;
            IExtension[] iExtensionArray = extensions = this.getExtensionsSorted(point);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] elements;
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    block8: {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (this.getConfigurationElementName().equals(element.getName())) {
                            try {
                                ExecutableExtensionProxy<V> candidate = this.doCreateExtensionProxy(element);
                                if (candidate.getId() != null) {
                                    this.doStoreExtensionTo(this.extensionsMap, candidate, element);
                                    break block8;
                                }
                                throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"id", (Object)element.getAttribute("label")), null));
                            }
                            catch (CoreException e) {
                                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_invalidExtensionPoint, (Object)element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e));
                            }
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }
}

