/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.swt.listener;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.tcf.te.ui.swt.SWTControlUtil;
import org.eclipse.tcf.te.ui.swt.listener.AbstractCellPaintListener;

public abstract class AbstractCheckBoxCellPaintListener
extends AbstractCellPaintListener {
    private static final int ENABLED = 1;
    private static final int CHECKED = 2;
    private static final int TRISTATE = 4;
    protected static final int STATE_NONE = -1;
    protected static final int STATE_ENABLED_CHECKED = 3;
    protected static final int STATE_ENABLED_UNCHECKED = 1;
    protected static final int STATE_ENABLED_TRISTATE = 5;
    protected static final int STATE_DISABLED_CHECKED = 2;
    protected static final int STATE_DISABLED_UNCHECKED = 0;
    protected static final int STATE_DISABLED_TRISTATE = 4;

    public AbstractCheckBoxCellPaintListener(Widget widget, int ... columns) {
        super(widget, columns);
    }

    @Override
    protected Point getPaintOrigin(Event event, Image image) {
        boolean isWindowsHost = System.getProperty("os.name", "").toLowerCase().startsWith("windows");
        int x = event.x + (this.getWidgetWidth(event) / 2 - image.getImageData().width / 2);
        int y = isWindowsHost ? event.y : event.y + event.height - (image.getImageData().height + 4);
        return new Point(x, y);
    }

    @Override
    protected Image getImageToDraw(Item item, int columnIndex) {
        int state;
        Assert.isNotNull((Object)item);
        if (this.isPaintImageInColumn(columnIndex) && (state = this.getCheckBoxState(item.getData(), columnIndex)) >= 0) {
            return SWTControlUtil.getCheckBoxImage((state & 2) != 0, (state & 4) != 0, (state & 1) != 0);
        }
        return null;
    }

    protected abstract int getCheckBoxState(Object var1, int var2);
}

