/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.rete.aggregation.IndexerBasedAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.eval.RelationEvaluatorNode;
import org.eclipse.viatra.query.runtime.rete.index.DualInputNode;
import org.eclipse.viatra.query.runtime.rete.index.Indexer;
import org.eclipse.viatra.query.runtime.rete.index.IterableIndexer;
import org.eclipse.viatra.query.runtime.rete.index.ProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.recipes.BetaRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ConstantRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ExpressionEnforcerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerBasedAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.InputRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.MultiParentNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.RelationEvaluationRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SingleColumnAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SingleParentNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.TransitiveClosureRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.UniquenessEnforcerRecipe;
import org.eclipse.viatra.query.runtime.rete.remote.Address;
import org.eclipse.viatra.query.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;

class ConnectionFactory {
    ReteContainer reteContainer;

    public ConnectionFactory(ReteContainer reteContainer) {
        this.reteContainer = reteContainer;
    }

    private boolean isStateful(ReteNodeRecipe recipe) {
        return recipe instanceof ProjectionIndexerRecipe || recipe instanceof IndexerBasedAggregatorRecipe || recipe instanceof SingleColumnAggregatorRecipe || recipe instanceof ExpressionEnforcerRecipe || recipe instanceof TransitiveClosureRecipe || recipe instanceof ProductionRecipe || recipe instanceof UniquenessEnforcerRecipe || recipe instanceof RelationEvaluationRecipe;
    }

    public void connectToParents(RecipeTraceInfo recipeTrace, Node freshNode) {
        ReteNodeRecipe recipe = recipeTrace.getRecipe();
        if (!(recipe instanceof ConstantRecipe)) {
            if (recipe instanceof InputRecipe) {
                throw new IllegalArgumentException(String.valueOf(ConnectionFactory.class.getSimpleName()) + " not intended for input connection: " + recipe);
            }
            if (recipe instanceof SingleParentNodeRecipe) {
                Receiver receiver = (Receiver)freshNode;
                ReteNodeRecipe parentRecipe = ((SingleParentNodeRecipe)recipe).getParent();
                this.connectToParent(recipe, receiver, parentRecipe);
            } else if (recipe instanceof RelationEvaluationRecipe) {
                EList parentRecipes = ((MultiParentNodeRecipe)recipe).getParents();
                ArrayList<Supplier> parentSuppliers = new ArrayList<Supplier>();
                for (ReteNodeRecipe parentRecipe : parentRecipes) {
                    parentSuppliers.add(this.getSupplierForRecipe(parentRecipe));
                }
                ((RelationEvaluatorNode)freshNode).connectToParents(parentSuppliers);
            } else if (recipe instanceof BetaRecipe) {
                DualInputNode beta = (DualInputNode)freshNode;
                ArrayList<RecipeTraceInfo> parentTraces = new ArrayList<RecipeTraceInfo>(recipeTrace.getParentRecipeTraces());
                Slots slots = this.avoidActiveNodeConflict(parentTraces.get(0), parentTraces.get(1));
                beta.connectToIndexers(slots.primary, slots.secondary);
            } else if (recipe instanceof IndexerBasedAggregatorRecipe) {
                IndexerBasedAggregatorNode aggregator = (IndexerBasedAggregatorNode)freshNode;
                IndexerBasedAggregatorRecipe aggregatorRecipe = (IndexerBasedAggregatorRecipe)recipe;
                aggregator.initializeWith((ProjectionIndexer)this.resolveIndexer((IndexerRecipe)aggregatorRecipe.getParent()));
            } else if (recipe instanceof MultiParentNodeRecipe) {
                Receiver receiver = (Receiver)freshNode;
                EList parentRecipes = ((MultiParentNodeRecipe)recipe).getParents();
                for (ReteNodeRecipe parentRecipe : parentRecipes) {
                    this.connectToParent(recipe, receiver, parentRecipe);
                }
            }
        }
    }

    private Indexer resolveIndexer(IndexerRecipe indexerRecipe) {
        Address<? extends Node> address = this.reteContainer.getNetwork().getExistingNodeByRecipe((ReteNodeRecipe)indexerRecipe);
        return (Indexer)this.reteContainer.resolveLocal(address);
    }

    private void connectToParent(ReteNodeRecipe recipe, Receiver freshNode, ReteNodeRecipe parentRecipe) {
        Supplier parentSupplier = this.getSupplierForRecipe(parentRecipe);
        if (freshNode instanceof TransitiveClosureNode) {
            ArrayList<Tuple> tuples = new ArrayList<Tuple>();
            parentSupplier.pullInto(tuples, true);
            ((TransitiveClosureNode)freshNode).reinitializeWith(tuples);
            this.reteContainer.connect(parentSupplier, freshNode);
        } else if (this.isStateful(recipe) || freshNode instanceof Supplier && !((Supplier)((Object)freshNode)).getReceivers().isEmpty()) {
            this.reteContainer.connectAndSynchronize(parentSupplier, freshNode);
        } else {
            this.reteContainer.connect(parentSupplier, freshNode);
        }
    }

    private Supplier getSupplierForRecipe(ReteNodeRecipe recipe) {
        Address<? extends Node> parentAddress = this.reteContainer.getNetwork().getExistingNodeByRecipe(recipe);
        Supplier supplier = this.reteContainer.getProvisioner().asSupplier(parentAddress);
        return supplier;
    }

    private Slots avoidActiveNodeConflict(RecipeTraceInfo primarySlot, RecipeTraceInfo secondarySlot) {
        Slots result = new Slots(primarySlot, secondarySlot){
            {
                this.primary = (IterableIndexer)ConnectionFactory.this.resolveIndexer((IndexerRecipe)((ProjectionIndexerRecipe)recipeTraceInfo.getRecipe()));
                this.secondary = ConnectionFactory.this.resolveIndexer((IndexerRecipe)recipeTraceInfo2.getRecipe());
            }
        };
        if (this.activeNodeConflict(result.primary, result.secondary)) {
            if (result.secondary instanceof IterableIndexer) {
                result.secondary = this.resolveActiveIndexer(secondarySlot);
            } else {
                result.primary = (IterableIndexer)this.resolveActiveIndexer(primarySlot);
            }
        }
        return result;
    }

    private Indexer resolveActiveIndexer(RecipeTraceInfo inactiveIndexerTrace) {
        RecipeTraceInfo activeIndexerTrace = this.reteContainer.getProvisioner().accessActiveIndexer(inactiveIndexerTrace);
        this.reteContainer.getProvisioner().getOrCreateNodeByRecipe(activeIndexerTrace);
        return this.resolveIndexer((IndexerRecipe)((ProjectionIndexerRecipe)activeIndexerTrace.getRecipe()));
    }

    private boolean activeNodeConflict(Indexer primarySlot, Indexer secondarySlot) {
        return !primarySlot.equals(secondarySlot) && primarySlot.getActiveNode().equals(secondarySlot.getActiveNode());
    }

    private static class Slots {
        IterableIndexer primary;
        Indexer secondary;

        private Slots() {
        }
    }
}

