/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette;

import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.TypeParameterComposite;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.dialogs.ResizableTitleAreaDialog;

public final class TypeParametersDialog
extends ResizableTitleAreaDialog {
    private final IJavaProject m_javaProject;
    private final Map<String, CreationDescription.TypeParameterDescription> m_typeParameters;
    private final Map<String, String> m_typeArguments = new TreeMap<String, String>();
    private final Map<String, TypeParameterComposite> m_typeParameterComposites = new TreeMap<String, TypeParameterComposite>();

    public TypeParametersDialog(Shell parentShell, IJavaProject javaProject, Map<String, CreationDescription.TypeParameterDescription> typeParameters) {
        super(parentShell, (AbstractUIPlugin)DesignerPlugin.getDefault());
        this.m_javaProject = javaProject;
        this.m_typeParameters = typeParameters;
    }

    public Map<String, String> getArguments() {
        return this.m_typeArguments;
    }

    protected final Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.configureMessages();
        return control;
    }

    protected void configureMessages() {
        this.getShell().setText(Messages.TypeParametersDialog_shellTitle);
        this.setTitle(Messages.TypeParametersDialog_title);
        this.setMessage(Messages.TypeParametersDialog_message);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridDataFactory.create((Control)container).grab().fill();
        GridLayoutFactory.create((Composite)container).columns(1);
        for (Map.Entry<String, CreationDescription.TypeParameterDescription> typeParameter : this.m_typeParameters.entrySet()) {
            String key = typeParameter.getKey();
            CreationDescription.TypeParameterDescription paramenerInfo = typeParameter.getValue();
            TypeParameterComposite parameterComposite = new TypeParameterComposite(container, 0, this.m_javaProject, paramenerInfo);
            GridDataFactory.create((Control)parameterComposite).grabH().fillH();
            this.m_typeParameterComposites.put(key, parameterComposite);
            this.m_typeArguments.put(key, paramenerInfo.getTypeName());
        }
        return area;
    }

    protected void okPressed() {
        for (Map.Entry<String, TypeParameterComposite> parameterComposite : this.m_typeParameterComposites.entrySet()) {
            this.m_typeArguments.put(parameterComposite.getKey(), parameterComposite.getValue().getArgument());
        }
        super.okPressed();
    }
}

