/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.palette.dialogs.factory;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.palette.dialogs.AbstractPaletteElementDialog;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.dialogfields.BooleanDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogFieldUtils;
import org.eclipse.wb.internal.core.utils.dialogfields.IStringButtonAdapter;
import org.eclipse.wb.internal.core.utils.dialogfields.StringAreaDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringButtonDialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.StringDialogField;
import org.eclipse.wb.internal.core.utils.jdt.ui.JdtUiUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class FactoryAbstractDialog
extends AbstractPaletteElementDialog {
    private final AstEditor m_editor;
    protected final boolean m_forStatic;
    protected StringDialogField m_nameField;
    protected StringButtonDialogField m_factoryClassField;
    protected StringButtonDialogField m_methodSignatureField;
    protected StringAreaDialogField m_descriptionField;
    protected BooleanDialogField m_visibleField;
    private Map<String, FactoryMethodDescription> m_signaturesMap;
    private Composite m_fieldsContainer;

    public FactoryAbstractDialog(Shell parentShell, AstEditor editor, boolean forStatic, String shellText, String titleText) {
        super(parentShell, shellText, titleText, null, Messages.FactoryAbstractDialog_message);
        this.m_editor = editor;
        this.m_forStatic = forStatic;
    }

    protected void createControls(Composite container) {
        this.m_fieldsContainer = container;
        GridLayoutFactory.create((Composite)container).columns(3);
        this.m_nameField = new StringDialogField();
        this.doCreateField((DialogField)this.m_nameField, Messages.FactoryAbstractDialog_nameLabel);
        this.m_factoryClassField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                try {
                    String factoryClassName = JdtUiUtils.selectTypeName(FactoryAbstractDialog.this.getShell(), FactoryAbstractDialog.this.m_editor.getJavaProject());
                    if (factoryClassName != null) {
                        FactoryAbstractDialog.this.m_factoryClassField.setText(factoryClassName);
                    }
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        });
        this.m_factoryClassField.setButtonLabel(Messages.FactoryAbstractDialog_classChoose);
        this.doCreateField((DialogField)this.m_factoryClassField, Messages.FactoryAbstractDialog_classLabel);
        this.m_factoryClassField.getTextControl(null).setEditable(false);
        this.m_methodSignatureField = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                try {
                    ElementListSelectionDialog dialog = new ElementListSelectionDialog(FactoryAbstractDialog.this.getShell(), (ILabelProvider)new LabelProvider(){

                        public Image getImage(Object element) {
                            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
                        }

                        public String getText(Object element) {
                            return super.getText(element);
                        }
                    });
                    dialog.setTitle(Messages.FactoryAbstractDialog_methodDialogTitle);
                    dialog.setMessage(Messages.FactoryAbstractDialog_methodDialogMessage);
                    dialog.setElements(FactoryAbstractDialog.this.m_signaturesMap.keySet().toArray());
                    if (dialog.open() == 0) {
                        String signature = (String)dialog.getFirstResult();
                        FactoryAbstractDialog.this.m_methodSignatureField.setText(signature);
                        FactoryAbstractDialog.this.m_nameField.setText(signature);
                        FactoryAbstractDialog.this.m_descriptionField.setText("");
                    }
                }
                catch (Throwable e) {
                    DesignerPlugin.log((Throwable)e);
                }
            }
        });
        this.m_methodSignatureField.setButtonLabel(Messages.FactoryAbstractDialog_methodChoose);
        this.doCreateField((DialogField)this.m_methodSignatureField, Messages.FactoryAbstractDialog_methodLabel);
        this.m_methodSignatureField.getTextControl(null).setEditable(false);
        this.m_descriptionField = new StringAreaDialogField(5);
        this.doCreateField((DialogField)this.m_descriptionField, Messages.FactoryAbstractDialog_descriptionLabel);
        GridDataFactory.modify((Control)this.m_descriptionField.getTextControl(null)).grabV();
        this.m_visibleField = new BooleanDialogField();
        this.doCreateField((DialogField)this.m_visibleField, Messages.FactoryAbstractDialog_visibleFlag);
    }

    protected final String validate() {
        String factoryClassName = this.m_factoryClassField.getText().trim();
        if (factoryClassName.length() == 0) {
            return Messages.FactoryAbstractDialog_validateEmptyClass;
        }
        try {
            EditorState state = EditorState.get(this.m_editor);
            Class<?> factoryClass = state.getEditorLoader().loadClass(factoryClassName);
            this.m_signaturesMap = FactoryDescriptionHelper.getDescriptionsMap(this.m_editor, factoryClass, this.m_forStatic);
        }
        catch (Throwable e) {
            return e.getClass().getName() + ": " + e.getMessage();
        }
        if (this.m_signaturesMap.isEmpty()) {
            return MessageFormat.format(Messages.FactoryAbstractDialog_validateNoMethods, factoryClassName);
        }
        String signature = this.m_methodSignatureField.getText();
        if (signature.length() == 0) {
            return Messages.FactoryAbstractDialog_validateEmptyMethod;
        }
        String name = this.m_nameField.getText().trim();
        if (name.length() == 0) {
            return Messages.FactoryAbstractDialog_validateEmptyName;
        }
        return null;
    }

    protected final void doCreateField(DialogField dialogField, String labelText) {
        dialogField.setLabelText(labelText);
        dialogField.setDialogFieldListener(this.m_validateListener);
        DialogFieldUtils.fillControls((Composite)this.m_fieldsContainer, (DialogField)dialogField, (int)3, (int)60);
    }

    protected final String getDescriptionText() {
        String text = this.m_descriptionField.getText();
        boolean isEmpty = StringUtils.isEmpty((String)text);
        if (isEmpty) {
            text = null;
        }
        return text;
    }
}

