/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class ArrayEvaluator
implements IExpressionEvaluator {
    /*
     * WARNING - void declaration
     */
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        Expression expression2 = expression;
        if (expression2 instanceof ArrayCreation) {
            void creation;
            ArrayCreation arrayCreation = (ArrayCreation)expression2;
            ArrayCreation cfr_ignored_0 = (ArrayCreation)expression2;
            ArrayInitializer initializer = creation.getInitializer();
            if (initializer != null) {
                return AstEvaluationEngine.evaluate(context, (Expression)initializer);
            }
            return ArrayEvaluator.evaluateEmpty(context, typeBinding, (ArrayCreation)creation);
        }
        Expression expression3 = expression;
        if (expression3 instanceof ArrayInitializer) {
            ArrayInitializer initializer = (ArrayInitializer)expression3;
            ArrayInitializer cfr_ignored_1 = (ArrayInitializer)expression3;
            return ArrayEvaluator.evaluateInitializer(context, typeBinding, initializer);
        }
        Expression expression4 = expression;
        if (expression4 instanceof ArrayAccess) {
            void arrayAccess;
            ArrayAccess arrayAccess2 = (ArrayAccess)expression4;
            ArrayAccess cfr_ignored_2 = (ArrayAccess)expression4;
            Expression arrayExpression = arrayAccess.getArray();
            Expression indexExpression = arrayAccess.getIndex();
            Object arrayObject = AstEvaluationEngine.evaluate(context, arrayExpression);
            Object indexObject = AstEvaluationEngine.evaluate(context, indexExpression);
            if (indexObject instanceof Integer) {
                int index = (Integer)indexObject;
                return Array.get(arrayObject, index);
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static Object evaluateEmpty(EvaluationContext context, ITypeBinding typeBinding, ArrayCreation creation) throws Exception {
        ITypeBinding elementTypeBinding = typeBinding.getElementType();
        Assert.isNotNull((Object)elementTypeBinding);
        String elementTypeName = AstNodeUtils.getFullyQualifiedName(elementTypeBinding, false);
        Class elementType = ReflectionUtils.getClassByName((ClassLoader)context.getClassLoader(), (String)elementTypeName);
        List<Expression> dimensionExpressions = DomGenerics.dimensions(creation);
        int[] dimensions = new int[dimensionExpressions.size()];
        int i = 0;
        while (i < dimensions.length) {
            Expression dimensionExpression = dimensionExpressions.get(i);
            dimensions[i] = (Integer)AstEvaluationEngine.evaluate(context, dimensionExpression);
            ++i;
        }
        return Array.newInstance(elementType, dimensions);
    }

    private static Object evaluateInitializer(EvaluationContext context, ITypeBinding typeBinding, ArrayInitializer initializer) throws Exception {
        ITypeBinding elementTypeBinding = typeBinding.getElementType();
        Assert.isNotNull((Object)elementTypeBinding);
        String elementTypeName = AstNodeUtils.getFullyQualifiedName(elementTypeBinding, false);
        Class elementType = ReflectionUtils.getClassByName((ClassLoader)context.getClassLoader(), (String)elementTypeName);
        List<Expression> expressions = DomGenerics.expressions(initializer);
        int length = expressions.size();
        int[] dimensions = new int[typeBinding.getDimensions()];
        dimensions[0] = length;
        if (typeBinding.getDimensions() == 1 && elementTypeBinding.isPrimitive()) {
            Object values = Array.newInstance(elementType, dimensions);
            int index = 0;
            while (index < length) {
                Expression element = expressions.get(index);
                Object elementValue = AstEvaluationEngine.evaluate(context, element);
                if (elementType == Boolean.TYPE) {
                    Array.setBoolean(values, index, (Boolean)elementValue);
                } else if (elementType == Character.TYPE) {
                    char charValue = elementValue instanceof Number ? (char)((Number)elementValue).intValue() : ((Character)elementValue).charValue();
                    Array.setChar(values, index, charValue);
                } else {
                    Number number = (Number)elementValue;
                    if (elementType == Byte.TYPE) {
                        Array.setByte(values, index, number.byteValue());
                    } else if (elementType == Short.TYPE) {
                        Array.setShort(values, index, number.shortValue());
                    } else if (elementType == Integer.TYPE) {
                        Array.setInt(values, index, number.intValue());
                    } else if (elementType == Long.TYPE) {
                        Array.setLong(values, index, number.longValue());
                    } else if (elementType == Float.TYPE) {
                        Array.setFloat(values, index, number.floatValue());
                    } else if (elementType == Double.TYPE) {
                        Array.setDouble(values, index, number.doubleValue());
                    }
                }
                ++index;
            }
            return values;
        }
        Object[] values = (Object[])Array.newInstance(elementType, dimensions);
        int index = 0;
        while (index < length) {
            Object value;
            Expression element = expressions.get(index);
            values[index] = value = AstEvaluationEngine.evaluate(context, element);
            ++index;
        }
        return values;
    }
}

