/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public final class ClassEvaluator
implements IExpressionEvaluator {
    /*
     * WARNING - void declaration
     */
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        Expression expression2 = expression;
        if (expression2 instanceof TypeLiteral) {
            void typeLiteral;
            TypeLiteral typeLiteral2 = (TypeLiteral)expression2;
            TypeLiteral cfr_ignored_0 = (TypeLiteral)expression2;
            ITypeBinding binding = AstNodeUtils.getTypeBinding(typeLiteral.getType());
            return ClassEvaluator.loadClass(context, binding);
        }
        Expression expression3 = expression;
        if (expression3 instanceof MethodInvocation) {
            void invocation;
            MethodInvocation binding = (MethodInvocation)expression3;
            MethodInvocation cfr_ignored_1 = (MethodInvocation)expression3;
            if (ClassEvaluator.isThisInvocation((MethodInvocation)invocation) && AstNodeUtils.isMethodInvocation((ASTNode)invocation, "getClass()")) {
                TypeDeclaration typeDeclaration = AstNodeUtils.getEnclosingType((ASTNode)invocation);
                ITypeBinding binding2 = AstNodeUtils.getTypeBinding(typeDeclaration);
                return ClassEvaluator.loadClass(context, binding2);
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    private static boolean isThisInvocation(MethodInvocation invocation) {
        Expression expression = invocation.getExpression();
        return expression == null || expression instanceof ThisExpression;
    }

    private static Object loadClass(EvaluationContext context, ITypeBinding binding) throws Exception {
        ClassLoader classLoader = context.getClassLoader();
        String className = AstNodeUtils.getFullyQualifiedName(binding, true);
        return ReflectionUtils.getClassByName((ClassLoader)classLoader, (String)className);
    }
}

