/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.jdt.core;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;

public final class SubtypesScope
implements IJavaSearchScope {
    private final IType[] m_subtypes;
    private final IJavaSearchScope m_hierarchyScope;
    private final Set<String> m_enclosingResourcePaths = new HashSet<String>();

    public SubtypesScope(IType type) throws JavaModelException {
        this.m_hierarchyScope = SearchEngine.createHierarchyScope((IType)type);
        IType[] iTypeArray = this.m_subtypes = type.newTypeHierarchy(null).getAllSubtypes(type);
        int n = this.m_subtypes.length;
        int n2 = 0;
        while (n2 < n) {
            IType subType = iTypeArray[n2];
            IResource resource = subType.getUnderlyingResource();
            if (resource != null) {
                this.m_enclosingResourcePaths.add(resource.getFullPath().toString());
            } else {
                this.m_enclosingResourcePaths.add(subType.getFullyQualifiedName().replace('.', '/') + ".class");
            }
            ++n2;
        }
    }

    public boolean encloses(String resourcePath) {
        String classPath = resourcePath;
        int index = classPath.indexOf("|");
        if (index != -1) {
            classPath = classPath.substring(index + 1);
        }
        return this.m_enclosingResourcePaths.contains(classPath);
    }

    public boolean encloses(IJavaElement element) {
        IType type = (IType)element.getAncestor(7);
        if (type != null) {
            return ArrayUtils.contains((Object[])this.m_subtypes, (Object)type);
        }
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.m_hierarchyScope.enclosingProjectsAndJars();
    }

    public boolean includesBinaries() {
        return this.m_hierarchyScope.includesBinaries();
    }

    public boolean includesClasspaths() {
        return this.m_hierarchyScope.includesClasspaths();
    }

    public void setIncludesBinaries(boolean includesBinaries) {
        this.m_hierarchyScope.setIncludesBinaries(includesBinaries);
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
        this.m_hierarchyScope.setIncludesClasspaths(includesClasspaths);
    }
}

