/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.wizards.palette;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.UiMessages;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.wizards.palette.NewProjectPalettePage;

public final class NewProjectPaletteWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection m_selection;
    private NewProjectPalettePage m_page;

    public NewProjectPaletteWizard() {
        this.setWindowTitle(UiMessages.NewProjectPaletteWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.m_page = new NewProjectPalettePage();
        this.m_page.init(this.m_selection);
        this.addPage((IWizardPage)this.m_page);
    }

    public boolean performFinish() {
        try {
            IProject project = this.m_page.getJavaProject().getProject();
            ToolkitDescription toolkit = this.m_page.getToolkit();
            IFolder metaFolder = project.getFolder("wbp-meta");
            if (!metaFolder.exists()) {
                metaFolder.create(true, true, null);
            }
            IFile paletteFile = metaFolder.getFile(toolkit.getId() + ".wbp-palette.xml");
            String content = StringUtils.join((Object[])new String[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?>", "<palette>", "\t<category id=\"someUniqueId\" name=\"Custom category\" description=\"Category added for project " + project.getName() + "\" open=\"true\">", "\t\t<component class=\"javax.swing.JButton\"/>", "\t\t<component class=\"javax.swing.JRadioButton\" name=\"Your name\" description=\"You can write any description here.\"/>", "\t</category>", "</palette>"}, (String)"\n");
            paletteFile.create((InputStream)new ByteArrayInputStream(content.getBytes()), true, null);
            IDE.openEditor((IWorkbenchPage)DesignerPlugin.getActivePage(), (IFile)paletteFile);
        }
        catch (Throwable e) {
            DesignerPlugin.log((Throwable)e);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.m_selection = selection;
    }
}

