/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.exception;

import com.google.common.collect.MapMaker;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.wb.core.branding.BrandingUtils;
import org.eclipse.wb.core.controls.BrowserComposite;
import org.eclipse.wb.core.editor.errors.IExceptionRewriter;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.errors.ErrorEntryInfo;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.IOUtils2;
import org.eclipse.wb.internal.core.utils.Messages;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.FatalDesignerException;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.xml.parser.QAttribute;
import org.eclipse.wb.internal.core.utils.xml.parser.QHandlerAdapter;
import org.eclipse.wb.internal.core.utils.xml.parser.QParser;
import org.osgi.framework.Bundle;

public final class DesignerExceptionUtils {
    private static Map<Throwable, Integer> m_exceptionPositions = new MapMaker().weakKeys().makeMap();
    private static Map<Integer, ErrorEntryInfo> m_codeToDescription;

    /*
     * WARNING - void declaration
     */
    public static String getExceptionHTML0(String message, Throwable e) {
        Throwable rootException;
        Object html = "";
        if (message != null) {
            html = (String)html + "<H2>" + message + "</H2>";
        }
        if ((rootException = DesignerExceptionUtils.getDesignerCause(e)) != null) {
            Throwable throwable = rootException;
            if (throwable instanceof DesignerException) {
                void designerException;
                DesignerException designerException2 = (DesignerException)throwable;
                DesignerException cfr_ignored_0 = (DesignerException)throwable;
                String description = DesignerExceptionUtils.getErrorEntry((Throwable)designerException).getDescription();
                html = (String)html + StringEscapeUtils.escapeHtml((String)description);
            }
            html = (String)html + Messages.DesignerExceptionUtils_stackTraceLabel;
            html = (String)html + "<pre>";
            html = (String)html + StringEscapeUtils.escapeHtml((String)ExceptionUtils.getStackTrace((Throwable)rootException));
            html = (String)html + "</pre>";
            html = (String)html + Messages.DesignerExceptionUtils_fullStackTraceLabel;
            html = (String)html + "<pre>";
            html = (String)html + StringEscapeUtils.escapeHtml((String)ExceptionUtils.getStackTrace((Throwable)e));
            html = (String)html + "</pre>";
        } else {
            html = (String)html + "<pre>";
            html = (String)html + Messages.DesignerExceptionUtils_noExceptionLabel;
            html = (String)html + "</pre>";
        }
        return html;
    }

    public static String getExceptionHTML(Throwable e) {
        String html;
        ErrorEntryInfo errorDescription = DesignerExceptionUtils.getErrorEntry(e);
        if (!BrowserComposite.browserAvailable((Composite)DesignerPlugin.getShell())) {
            return DesignerExceptionUtils.getPlainTextDescription(errorDescription) + "\n" + ExceptionUtils.getStackTrace((Throwable)e);
        }
        InputStream htmlStream = null;
        try {
            try {
                htmlStream = DesignerPlugin.getFile("icons/actions/errors/errorTemplate.html");
                html = IOUtils2.readString(htmlStream);
            }
            catch (Throwable _e) {
                DesignerPlugin.log(_e);
                String string = DesignerExceptionUtils.getPlainTextDescription(errorDescription);
                IOUtils.closeQuietly((InputStream)htmlStream);
                return string;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)htmlStream);
        }
        Color color = IColorConstants.button;
        String colorString = DesignerExceptionUtils.getColorWebString(color);
        html = StringUtils.replace((String)html, (String)"%bg_color%", (String)colorString);
        html = StringUtils.replace((String)html, (String)"%error_message%", (String)errorDescription.getTitle());
        html = StringUtils.replace((String)html, (String)"%error_description%", (String)errorDescription.getDescription());
        html = DesignerExceptionUtils.includeStackTrace(html, "%stack_trace_short%", DesignerExceptionUtils.getDesignerCause(e));
        html = DesignerExceptionUtils.includeStackTrace(html, "%stack_trace_full%", e);
        return html;
    }

    private static String includeStackTrace(String html, String searchString, Throwable e) {
        String stackTrace = ExceptionUtils.getStackTrace((Throwable)e);
        String stackTraceEscaped = StringEscapeUtils.escapeHtml((String)stackTrace);
        return StringUtils.replace((String)html, (String)searchString, (String)stackTraceEscaped);
    }

    public static String getWarningHTML(ErrorEntryInfo entry) {
        String html;
        if (!BrowserComposite.browserAvailable((Composite)DesignerPlugin.getShell())) {
            return DesignerExceptionUtils.getPlainTextDescription(entry);
        }
        InputStream htmlStream = null;
        try {
            try {
                htmlStream = DesignerPlugin.getFile("icons/actions/errors/warningTemplate.html");
                html = IOUtils2.readString(htmlStream);
            }
            catch (Throwable _e) {
                DesignerPlugin.log(_e);
                String string = DesignerExceptionUtils.getPlainTextDescription(entry);
                IOUtils.closeQuietly((InputStream)htmlStream);
                return string;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)htmlStream);
        }
        Color color = IColorConstants.button;
        String colorString = DesignerExceptionUtils.getColorWebString(color);
        html = StringUtils.replace((String)html, (String)"%bg_color%", (String)colorString);
        html = StringUtils.replace((String)html, (String)"%error_description%", (String)entry.getDescription());
        return html;
    }

    private static String getPlainTextDescription(ErrorEntryInfo errorEntry) {
        if (!StringUtils.isEmpty((String)errorEntry.getAltDescription())) {
            return errorEntry.getAltDescription();
        }
        String description = errorEntry.getDescription();
        description = StringUtilities.stripHtml(description);
        return description;
    }

    public static Throwable getRootCause(Throwable throwable) {
        List list = ExceptionUtils.getThrowableList((Throwable)throwable);
        return (Throwable)GenericsUtils.getLastOrNull(list);
    }

    public static Throwable rewriteException(Throwable throwable) {
        List<IExceptionRewriter> rewriters = ExternalFactoriesHelper.getElementsInstances(IExceptionRewriter.class, "org.eclipse.wb.core.exceptions", "rewriter");
        for (IExceptionRewriter rewriter : rewriters) {
            throwable = rewriter.rewrite(throwable);
        }
        return throwable;
    }

    public static Throwable getDesignerCause(Throwable throwable) {
        Throwable e = throwable;
        while (e != null) {
            if (e instanceof DesignerException) {
                return e;
            }
            e = e.getCause();
        }
        return DesignerExceptionUtils.getRootCause(throwable);
    }

    public static DesignerException getDesignerException(Throwable throwable) {
        return (DesignerException)DesignerExceptionUtils.getDesignerCause(throwable);
    }

    public static void setSourcePosition(Throwable throwable, int position) {
        m_exceptionPositions.put(throwable, position);
    }

    public static int getSourcePosition(Throwable throwable) {
        Integer position = m_exceptionPositions.get(throwable);
        if (position != null) {
            return position;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isWarning(Throwable throwable) {
        Throwable rootException = DesignerExceptionUtils.getDesignerCause(throwable);
        Throwable throwable2 = rootException;
        if (throwable2 instanceof DesignerException) {
            void designerException;
            DesignerException designerException2 = (DesignerException)throwable2;
            DesignerException cfr_ignored_0 = (DesignerException)throwable2;
            int code = designerException.getCode();
            ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry0(code);
            return entry != null && entry.isWarning();
        }
        return false;
    }

    public static boolean isFatal(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof FatalDesignerException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean hasTraceElementsSequence(Throwable e, String[][] expected) {
        StackTraceElement[] elements = e.getStackTrace();
        int i = 0;
        while (i < elements.length) {
            block4: {
                int j = 0;
                while (j < expected.length) {
                    if (i + j < elements.length) {
                        StackTraceElement element = elements[i + j];
                        String expectedClass = expected[j][0];
                        String expectedMethod = expected[j][1];
                        if (element.getClassName().equals(expectedClass) && element.getMethodName().equals(expectedMethod)) {
                            ++j;
                            continue;
                        }
                    }
                    break block4;
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getExceptionTitle(int exceptionCode) {
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry0(exceptionCode);
        if (entry == null) {
            return Messages.DesignerExceptionUtils_noDescriptionTitle2;
        }
        return entry.getTitle();
    }

    /*
     * WARNING - void declaration
     */
    public static ErrorEntryInfo getErrorEntry(Throwable throwable) {
        Throwable rootException = DesignerExceptionUtils.getDesignerCause(throwable);
        Throwable throwable2 = rootException;
        if (throwable2 instanceof DesignerException) {
            void designerException;
            DesignerException designerException2 = (DesignerException)throwable2;
            DesignerException cfr_ignored_0 = (DesignerException)throwable2;
            int code = designerException.getCode();
            String[] parameters = designerException.getParameters();
            return DesignerExceptionUtils.getErrorEntry(code, parameters);
        }
        return DesignerExceptionUtils.getUnexpectedErrorEntryInfo(throwable);
    }

    private static ErrorEntryInfo getUnexpectedErrorEntryInfo(Throwable throwable) {
        String message = throwable.getMessage();
        ErrorEntryInfo e = DesignerExceptionUtils.getErrorEntry(1, new String[0]);
        Object desc = e.getDescription();
        desc = (String)desc + (String)(message != null ? "<p>" + throwable.getClass().getName() + ": " + message + "</p>" : "");
        return new ErrorEntryInfo(e.getCode(), e.isWarning(), e.getTitle(), (String)desc, e.getAltDescription());
    }

    public static ErrorEntryInfo getErrorEntry(int exceptionCode, String ... parameters) {
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry0(exceptionCode, parameters);
        if (entry != null) {
            return entry;
        }
        String description = MessageFormat.format(Messages.DesignerExceptionUtils_noDescriptionMessage, exceptionCode);
        return new ErrorEntryInfo(exceptionCode, false, Messages.DesignerExceptionUtils_noDescriptionTitle, description);
    }

    private static ErrorEntryInfo getErrorEntry0(int exceptionCode, String ... parameters) {
        String description;
        ErrorEntryInfo errorEntryInfo = DesignerExceptionUtils.getErrorEntry0(exceptionCode);
        if (errorEntryInfo != null && (description = errorEntryInfo.getDescription()) != null) {
            int i = 0;
            while (i < parameters.length) {
                String template = "{" + i + "}";
                int index = description.indexOf(template);
                if (index != -1) {
                    description = DesignerExceptionUtils.includeExceptionParameter(description, template, parameters[i]);
                }
                ++i;
            }
            return new ErrorEntryInfo(errorEntryInfo.getCode(), errorEntryInfo.isWarning(), errorEntryInfo.getTitle(), description, errorEntryInfo.getAltDescription());
        }
        return null;
    }

    private static ErrorEntryInfo getErrorEntry0(int exceptionCode) {
        if (m_codeToDescription == null || EnvironmentUtils.DEVELOPER_HOST) {
            DesignerExceptionUtils.fillErrorEntries();
        }
        return m_codeToDescription.get(exceptionCode);
    }

    private static String includeExceptionParameter(String html, String searchString, String message) {
        String messageEscaped = StringEscapeUtils.escapeHtml((String)message);
        return StringUtils.replace((String)html, (String)searchString, (String)messageEscaped);
    }

    private static void fillErrorEntries() {
        m_codeToDescription = new TreeMap<Integer, ErrorEntryInfo>();
        try {
            List<IConfigurationElement> fileElements = ExternalFactoriesHelper.getElements("org.eclipse.wb.core.exceptions", "file");
            for (IConfigurationElement fileElement : fileElements) {
                try {
                    Bundle fileBundle = ExternalFactoriesHelper.getExtensionBundle(fileElement);
                    String filePath = fileElement.getAttribute("path");
                    URL fileURL = fileBundle.getEntry(filePath);
                    final String xmlText = IOUtils2.readString(fileURL.openStream());
                    QParser.parse(new StringReader(xmlText), new QHandlerAdapter(){
                        private ErrorEntryInfo m_errorEntry;
                        private int m_code;
                        private boolean m_isWarning;
                        private String m_description;
                        private String m_altDescription;
                        private int m_descriptionStart;

                        @Override
                        public void startElement(int offset, int length, String tag, Map<String, String> attributes, List<QAttribute> attrList, boolean closed) throws Exception {
                            if ("exception".equals(tag)) {
                                this.m_code = Integer.parseInt(attributes.get("id"));
                                this.m_isWarning = "true".equals(attributes.get("warning"));
                                this.m_description = attributes.get("title");
                                this.m_altDescription = this.applyBranding(attributes.get("alt"));
                                this.m_descriptionStart = xmlText.indexOf(62, offset) + 1;
                            }
                        }

                        @Override
                        public void endElement(int offset, int endOffset, String tag) throws Exception {
                            if ("exception".equals(tag)) {
                                String description = xmlText.substring(this.m_descriptionStart, offset);
                                description = this.applyBranding(description);
                                this.m_errorEntry = new ErrorEntryInfo(this.m_code, this.m_isWarning, this.m_description, description, this.m_altDescription);
                                m_codeToDescription.put(this.m_errorEntry.getCode(), this.m_errorEntry);
                            }
                        }

                        private String applyBranding(String description) {
                            if (description == null) {
                                return null;
                            }
                            String productNameTemplate = "{product_name}";
                            int index = description.indexOf(productNameTemplate);
                            if (index != -1) {
                                description = DesignerExceptionUtils.includeExceptionParameter(description, productNameTemplate, BrandingUtils.getBranding().getProductName());
                            }
                            return description;
                        }
                    });
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable ex) {
            DesignerPlugin.log(ex);
        }
    }

    public static void flushErrorEntriesCache() {
        m_codeToDescription = null;
    }

    public static String getColorWebString(Color color) {
        String colorString = "#" + Integer.toHexString(color.getRed());
        colorString = colorString + Integer.toHexString(color.getGreen());
        colorString = colorString + Integer.toHexString(color.getBlue());
        return colorString;
    }

    public static Image makeScreenshot() {
        Shell shell = DesignerPlugin.getShell();
        shell.redraw();
        shell.update();
        Rectangle shellBounds = shell.getBounds();
        Display standardDisplay = DesignerPlugin.getStandardDisplay();
        standardDisplay.update();
        Image image = new Image((Device)standardDisplay, shellBounds.width, shellBounds.height);
        GC gc = new GC((Drawable)standardDisplay);
        gc.copyArea(image, shellBounds.x, shellBounds.y);
        gc.dispose();
        return image;
    }

    public static void openBrowser(String url) {
        try {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browserSupport = support.createBrowser("wbp.browser");
            browserSupport.openURL(new URL(url));
        }
        catch (Throwable e) {
            Clipboard clipboard = new Clipboard(DesignerPlugin.getStandardDisplay());
            clipboard.setContents((Object[])new String[]{url}, new Transfer[]{TextTransfer.getInstance()});
            clipboard.dispose();
            MessageDialog.openInformation((Shell)DesignerPlugin.getShell(), (String)Messages.DesignerExceptionUtils_openUrlTitle, (String)MessageFormat.format(Messages.DesignerExceptionUtils_openUrlMessage, url));
        }
    }
}

