/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.support;

import java.lang.reflect.Constructor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wb.internal.core.model.menu.MenuVisualData;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.swt.support.AbstractSupport;
import org.eclipse.wb.internal.swt.support.ContainerSupport;
import org.eclipse.wb.internal.swt.support.ControlSupport;
import org.eclipse.wb.internal.swt.support.IToolkitSupport;
import org.osgi.framework.Bundle;

public class ToolkitSupport
extends AbstractSupport {
    private static IToolkitSupport m_impl_RCP;
    private static IToolkitSupport m_impl_eRCP;

    public static void markAsNeededImage(Object control) throws Exception {
        ControlSupport.setData(control, "WBP_NEED_IMAGE", Boolean.TRUE);
    }

    public static Image getShotImage(Object control) throws Exception {
        return (Image)ControlSupport.getData(control, "WBP_IMAGE");
    }

    public static void makeShots(Object control) throws Exception {
        ToolkitSupport.getImpl().makeShots(control);
        ToolkitSupport.makeShotsHierarchy(control);
    }

    private static void makeShotsHierarchy(Object control) throws Exception {
        if (ControlSupport.getData(control, "WBP_NEED_IMAGE") != null) {
            ControlSupport.setData(control, "WBP_IMAGE", ToolkitSupport.getImpl().getShotImage(control));
            if (ContainerSupport.getCompositeClass().isAssignableFrom(control.getClass())) {
                Object[] children;
                Object[] objectArray = children = ContainerSupport.getChildren(control);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    ToolkitSupport.makeShotsHierarchy(child);
                    ++n2;
                }
            }
        }
    }

    public static void beginShot(Object control) throws Exception {
        ToolkitSupport.getImpl().beginShot(control);
    }

    public static void endShot(Object control) throws Exception {
        ToolkitSupport.getImpl().endShot(control);
    }

    public static MenuVisualData fetchMenuVisualData(Object menu) throws Exception {
        return ToolkitSupport.getImpl().fetchMenuVisualData(menu);
    }

    public static int getDefaultMenuBarHeight() throws Exception {
        return ToolkitSupport.getImpl().getDefaultMenuBarHeight();
    }

    public static Object createToolkitImage(Image image) throws Exception {
        return ToolkitSupport.getImpl().createToolkitImage(image);
    }

    public static Image createSWTImage(Object image) throws Exception {
        return ToolkitSupport.getImpl().createSWTImage(image);
    }

    public static void showShell(Object shell) throws Exception {
        ToolkitSupport.getImpl().showShell(shell);
    }

    public static String[] getFontFamilies(boolean scalable) throws Exception {
        return ToolkitSupport.getImpl().getFontFamilies(scalable);
    }

    public static Image getFontPreview(Object font) throws Exception {
        return ToolkitSupport.getImpl().getFontPreview(font);
    }

    private static IToolkitSupport getImpl() throws Exception {
        if (ToolkitSupport.is_RCP()) {
            if (m_impl_RCP == null) {
                m_impl_RCP = ToolkitSupport.createImpl();
            }
            return m_impl_RCP;
        }
        if (m_impl_eRCP == null) {
            m_impl_eRCP = ToolkitSupport.createImpl();
        }
        return m_impl_eRCP;
    }

    private static IToolkitSupport createImpl() throws Exception {
        Bundle bundle = GlobalState.getToolkit().getBundle();
        Object implClassName = bundle.getSymbolicName() + ".support.ToolkitSupportImpl";
        implClassName = StringUtils.replace((String)implClassName, (String)".wb.", (String)".wb.internal.");
        Class implClass = bundle.loadClass((String)implClassName);
        ClassLoader editorLoader = GlobalState.getClassLoader();
        Constructor constructor = implClass.getConstructor(ClassLoader.class);
        return (IToolkitSupport)constructor.newInstance(editorLoader);
    }
}

