/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native.value;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.wst.jsdt.chromium.JsValue;

public class JsDataTypeUtil {
    private static Map<String, JsValue.Type> jsonTypeToEnum = new HashMap<String, JsValue.Type>();
    private static Map<JsValue.Type, String> enumToJsonType = new EnumMap<JsValue.Type, String>(JsValue.Type.class);
    public static final String CLASSNAME_ARRAY = "Array";
    public static final String JSON_NULL_TYPE = "null";
    public static final String JSON_UNDEFINED_TYPE = "undefined";
    public static final String JSON_BOOLEAN_TYPE = "boolean";
    public static final String JSON_NUMBER_TYPE = "number";
    public static final String JSON_STRING_TYPE = "string";
    private static final String CLASSNAME_DATE = "Date";

    static {
        JsDataTypeUtil.put("object", JsValue.Type.TYPE_OBJECT);
        JsDataTypeUtil.put(JSON_NUMBER_TYPE, JsValue.Type.TYPE_NUMBER);
        JsDataTypeUtil.put(JSON_STRING_TYPE, JsValue.Type.TYPE_STRING);
        JsDataTypeUtil.put("function", JsValue.Type.TYPE_FUNCTION);
        JsDataTypeUtil.put(JSON_BOOLEAN_TYPE, JsValue.Type.TYPE_BOOLEAN);
        JsDataTypeUtil.put(JSON_UNDEFINED_TYPE, JsValue.Type.TYPE_UNDEFINED);
        JsDataTypeUtil.put(JSON_NULL_TYPE, JsValue.Type.TYPE_NULL);
        JsDataTypeUtil.put("error", JsValue.Type.TYPE_ERROR);
        JsDataTypeUtil.put("array", JsValue.Type.TYPE_ARRAY);
        JsDataTypeUtil.put("date", JsValue.Type.TYPE_DATE);
        JsDataTypeUtil.put("regexp", JsValue.Type.TYPE_REGEXP);
    }

    public static JsValue.Type fromJsonTypeAndClassName(String jsonType, String className) {
        if (jsonType == null) {
            return null;
        }
        if (CLASSNAME_DATE.equals(className)) {
            return JsValue.Type.TYPE_DATE;
        }
        if (CLASSNAME_ARRAY.equals(className)) {
            return JsValue.Type.TYPE_ARRAY;
        }
        return jsonTypeToEnum.get(jsonType);
    }

    public static String getJsonString(JsValue.Type type) {
        return enumToJsonType.get((Object)type);
    }

    private static void put(String jsonString, JsValue.Type type) {
        jsonTypeToEnum.put(jsonString, type);
        enumToJsonType.put(type, jsonString);
    }

    private JsDataTypeUtil() {
    }
}

