/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.highlighting;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.xtend.ide.common.highlighting.XtendHighlightingStyles;
import org.eclipse.xtext.parser.antlr.ITokenDefProvider;
import org.eclipse.xtext.ui.editor.model.ILexerTokenRegion;
import org.eclipse.xtext.ui.editor.syntaxcoloring.TokenScanner;

public class RichStringAwareTokenScanner
extends TokenScanner
implements XtendHighlightingStyles {
    private RichTextToken currentRichTextToken;
    private String[] allTokenTypesAsString;

    protected RichTextToken createRichTextToken(String id, ILexerTokenRegion token) {
        int tokenOffset = token.getOffset();
        int tokenLength = token.getLength();
        RichTextToken result = new RichTextToken();
        if ("RULE_RICH_TEXT_START".equals(id)) {
            result.delimiter = false;
            result.offsets = new int[]{tokenOffset, tokenOffset + tokenLength - 1};
            result.lengths = new int[]{tokenLength - 1, 1};
        } else if ("RULE_RICH_TEXT_END".equals(id)) {
            result.delimiter = true;
            result.offsets = new int[]{tokenOffset, tokenOffset + 1};
            result.lengths = new int[]{1, tokenLength - 1};
        } else if ("RULE_RICH_TEXT_INBETWEEN".equals(id)) {
            result.delimiter = true;
            if (tokenLength == 2) {
                result.offsets = new int[]{tokenOffset};
                result.lengths = new int[]{tokenLength};
            } else {
                result.offsets = new int[]{tokenOffset, tokenOffset + 1, tokenOffset + tokenLength - 1};
                result.lengths = new int[]{1, tokenLength - 2, 1};
            }
        } else if ("RULE_COMMENT_RICH_TEXT_END".equals(id)) {
            result.delimiter = true;
            result.offsets = new int[]{tokenOffset, tokenOffset + 2};
            result.lengths = new int[]{2, tokenLength - 2};
        } else if ("RULE_COMMENT_RICH_TEXT_INBETWEEN".equals(id)) {
            result.delimiter = true;
            result.offsets = new int[]{tokenOffset, tokenOffset + 2, tokenOffset + tokenLength - 1};
            result.lengths = new int[]{2, tokenLength - 3, 1};
        } else {
            throw new IllegalArgumentException(id);
        }
        return result;
    }

    @Inject
    public void setTokenDefProvider(@Named(value="org.eclipse.xtext.ui.editor.contentassist.antlr.internal.Lexer.HIGHLIGHTING") ITokenDefProvider tokenDefProvider) {
        Map map = tokenDefProvider.getTokenDefMap();
        int minTokenType = 4;
        this.allTokenTypesAsString = new String[map.size() + minTokenType];
        for (Map.Entry entry : map.entrySet()) {
            String tokenName = (String)entry.getValue();
            if (!"RULE_RICH_TEXT_START".equals(tokenName) && !"RULE_RICH_TEXT_END".equals(tokenName) && !"RULE_RICH_TEXT_INBETWEEN".equals(tokenName) && !"RULE_COMMENT_RICH_TEXT_END".equals(tokenName) && !"RULE_COMMENT_RICH_TEXT_INBETWEEN".equals(tokenName)) continue;
            this.allTokenTypesAsString[((Integer)entry.getKey()).intValue()] = tokenName;
        }
    }

    public void setRange(IDocument document, int offset, int length) {
        this.currentRichTextToken = null;
        super.setRange(document, offset, length);
    }

    public IToken nextToken() {
        if (this.currentRichTextToken != null) {
            if (this.currentRichTextToken.hasNext()) {
                return this.currentRichTextToken.nextToken();
            }
            this.currentRichTextToken = null;
        }
        if (!this.getIterator().hasNext()) {
            return Token.EOF;
        }
        ILexerTokenRegion next = (ILexerTokenRegion)this.getIterator().next();
        int tokenType = next.getLexerTokenType();
        if (tokenType >= 0 && this.allTokenTypesAsString[tokenType] != null) {
            this.currentRichTextToken = this.createRichTextToken(this.allTokenTypesAsString[tokenType], next);
            return this.currentRichTextToken.nextToken();
        }
        this.setCurrentToken(next);
        return this.createToken(next);
    }

    public int getTokenLength() {
        if (this.currentRichTextToken != null) {
            return this.currentRichTextToken.getTokenLength();
        }
        return super.getTokenLength();
    }

    public int getTokenOffset() {
        if (this.currentRichTextToken != null) {
            return this.currentRichTextToken.getTokenOffset();
        }
        return super.getTokenOffset();
    }

    protected class RichTextToken {
        private int index = -1;
        private int[] offsets;
        private int[] lengths;
        private boolean delimiter;

        protected RichTextToken() {
        }

        public int getTokenLength() {
            return this.lengths[this.index];
        }

        public int getTokenOffset() {
            return this.offsets[this.index];
        }

        public boolean hasNext() {
            return this.index < this.offsets.length - 1;
        }

        public IToken nextToken() {
            IToken result = this.createToken();
            ++this.index;
            this.delimiter = !this.delimiter;
            return result;
        }

        protected IToken createToken() {
            String attributeId = this.delimiter ? "xtend.richText.delimiter" : "xtend.richText";
            Token token = new Token((Object)RichStringAwareTokenScanner.this.getAttribute(attributeId));
            return token;
        }
    }
}

